/*
 * Decompiled with CFR 0.152.
 */
import COM.livingston.ppp.LEPPPDebugMessage;
import COM.livingston.smartagent.LEAgentMessage;
import COM.livingston.ui.LETextArea;
import COM.livingston.util.LEAppInfo;
import COM.livingston.util.LEDebug;
import COM.livingston.util.LEProperties;
import COM.livingston.util.LEResource;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Enumeration;
import java.util.Vector;

public class LESmartAgentMessagePPPDetailFrame
extends Frame {
    LETextArea m_ta;
    static final String PROP_PPPDETAIL_X = "pppdetail_x";
    static final String PROP_PPPDETAIL_Y = "pppdetail_y";
    static final String PROP_PPPDETAIL_W = "pppdetail_w";
    static final String PROP_PPPDETAIL_H = "pppdetail_h";
    Rectangle m_pppDetailBounds;

    LESmartAgentMessagePPPDetailFrame() {
        ((Component)this).setVisible(false);
        this.loadProps();
        ((Component)this).setSize(this.m_pppDetailBounds.width, this.m_pppDetailBounds.height);
        ((Component)this).setLocation(this.m_pppDetailBounds.x, this.m_pppDetailBounds.y);
        this.setTitle("SmartAgent PPP Detail");
        ((Component)this).setBackground(Color.lightGray);
        this.setLayout(new BorderLayout(5, 5));
        this.m_ta = new LETextArea();
        this.m_ta.setBufSize(20000);
        this.add("Center", this.m_ta);
        Image image = LEResource.GetImage("lucent_32.gif");
        if (image instanceof Image) {
            this.setIconImage(image);
        }
        WinAdapter winAdapter = new WinAdapter();
        this.addWindowListener(winAdapter);
    }

    public static void main(String[] stringArray) {
        ((Component)new LESmartAgentMessagePPPDetailFrame()).setVisible(true);
    }

    void Frame_WindowClosing() {
        this.saveProps();
        ((Component)this).setVisible(false);
        this.dispose();
    }

    public void displayAgentMessageDetails(LEAgentMessage lEAgentMessage) {
        if (lEAgentMessage.getSourceObject() instanceof Vector) {
            Vector vector = (Vector)lEAgentMessage.getSourceObject();
            Enumeration enumeration = vector.elements();
            this.m_ta.setText("Previous output:\n");
            while (enumeration.hasMoreElements()) {
                Object e = enumeration.nextElement();
                if (!(e instanceof LEPPPDebugMessage)) continue;
                LEPPPDebugMessage lEPPPDebugMessage = (LEPPPDebugMessage)e;
                StringBuffer stringBuffer = new StringBuffer(lEPPPDebugMessage.getData());
                stringBuffer.append("\n");
                String string = lEPPPDebugMessage.getTranslatedString();
                if (string != null) {
                    stringBuffer.append(string);
                }
                this.m_ta.append(stringBuffer.toString());
            }
            return;
        }
        if (lEAgentMessage.getSourceObject() instanceof LEPPPDebugMessage) {
            Object object = lEAgentMessage.getSourceObject();
            this.m_ta.setText("PPP Decoded Message:\n");
            LEPPPDebugMessage lEPPPDebugMessage = (LEPPPDebugMessage)object;
            StringBuffer stringBuffer = new StringBuffer(lEPPPDebugMessage.getData());
            stringBuffer.append("\n");
            String string = lEPPPDebugMessage.getTranslatedString();
            if (string != null) {
                stringBuffer.append(string);
            }
            stringBuffer.append("\n");
            this.m_ta.append(stringBuffer.toString());
        }
    }

    public void loadProps() {
        try {
            Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
            int n = 640;
            int n2 = 480;
            int n3 = dimension.width / 2 - n / 2;
            int n4 = dimension.height / 2 - n2 / 2;
            String string = LEProperties.GetProperty(PROP_PPPDETAIL_X);
            if (string != null) {
                n3 = Integer.parseInt(string);
            }
            if ((string = LEProperties.GetProperty(PROP_PPPDETAIL_Y)) != null) {
                n4 = Integer.parseInt(string);
            }
            if ((string = LEProperties.GetProperty(PROP_PPPDETAIL_W)) != null) {
                n = Integer.parseInt(string);
            }
            if ((string = LEProperties.GetProperty(PROP_PPPDETAIL_H)) != null) {
                n2 = Integer.parseInt(string);
            }
            this.m_pppDetailBounds = new Rectangle(n3, n4, n, n2);
            return;
        }
        catch (Exception exception) {
            LEDebug.getLog().logln(20, exception);
            return;
        }
    }

    void saveProps() {
        try {
            Rectangle rectangle = this.getBounds();
            LEProperties.SetProperty(PROP_PPPDETAIL_X, Integer.toString(rectangle.x));
            LEProperties.SetProperty(PROP_PPPDETAIL_Y, Integer.toString(rectangle.y));
            LEProperties.SetProperty(PROP_PPPDETAIL_W, Integer.toString(rectangle.width));
            if (LEAppInfo.isUnix()) {
                LEProperties.SetProperty(PROP_PPPDETAIL_H, Integer.toString(rectangle.height));
                return;
            }
            LEProperties.SetProperty(PROP_PPPDETAIL_H, Integer.toString(rectangle.height + 19));
            return;
        }
        catch (Exception exception) {
            LEDebug.getLog().logln(20, exception);
            return;
        }
    }

    class WinAdapter
    extends WindowAdapter {
        public void windowClosing(WindowEvent windowEvent) {
            Object object = windowEvent.getSource();
            if (object == LESmartAgentMessagePPPDetailFrame.this) {
                LESmartAgentMessagePPPDetailFrame.this.Frame_WindowClosing();
            }
        }

        WinAdapter() {
            LESmartAgentMessagePPPDetailFrame.this = LESmartAgentMessagePPPDetailFrame.this;
        }
    }
}

