/*
 * Decompiled with CFR 0.152.
 */
import com.lucent.ra.nms.backend.LEDebugMessage;
import com.lucent.ra.nms.diag.ppp.LEPPPDebugMessage;
import com.lucent.ra.nms.diag.userlocator.LEHoundDog;
import com.lucent.ra.nms.diag.userlocator.LEHoundDogDetailMessage;
import com.lucent.ra.nms.diag.userlocator.LEHoundDogMessage;
import com.lucent.ra.nms.ui.LEBorderPanel;
import com.lucent.ra.nms.ui.LEMLEvent;
import com.lucent.ra.nms.ui.LEMLListener;
import com.lucent.ra.nms.ui.LEMultiList;
import com.lucent.ra.nms.ui.LEScrollPanel;
import com.lucent.ra.nms.ui.LESplitterPanel;
import com.lucent.ra.nms.ui.LETextArea;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.util.Date;
import java.util.Enumeration;
import java.util.Vector;

public class UTFoundPanel
extends LEBorderPanel
implements LEMLListener,
ActionListener {
    LEMultiList m_ml;
    public static final String[] TITLE = new String[]{"ID", "Hostname", "Slot", "Port ", "Modem", "Time Found", "Current State"};
    LETextArea m_ta;
    Vector m_incomingMessages = new Vector();
    static int UPDATE_SLEEP_TIME = 5000;
    public static final int MAX_NUM_OF_MESSAGES = 150;
    public static final int HOSTNAME_COLUMN = 1;
    public static final int SLOT_NUM_COLUMN = 2;
    public static final int PORT_NUM_COLUMN = 3;
    public static final int MODEM_NUM_COLUMN = 4;
    public static final int STATUS_COLUMN = 6;
    public static final int DATA_COLUMN = 7;
    public static final int KEY_COLUMN = 8;
    public static final String FOUND = new String("Found");
    public static final String FOUND_ALREADY_LOGGED_IN = new String("Found, Already Logged In");
    public static final String MESSAGE_DELETE = "MESSAGE_DELETE";
    public static final String MESSAGE_DELETE_SAME = "MESSAGE_DELETE_SAME";
    public static final String MESSAGE_DELETE_ALL = "MESSAGE_DELETE_ALL";
    public static final String TERMINATED = "TERMINATED";

    public UTFoundPanel() {
        this.setBorderType(3);
        this.setLayout(new BorderLayout(10, 10));
        this.setBackground(Color.lightGray);
        this.add("Center", this.createMessagePanel());
    }

    Panel createMessagePanel() {
        LESplitterPanel lESplitterPanel = new LESplitterPanel();
        this.m_ml = new LEMultiList(1, 0, 7);
        this.m_ml.setMultipleSelect(false);
        int n = 0;
        while (n < 8) {
            this.m_ml.setSortable(n, true);
            ++n;
        }
        this.m_ml.setTitles(0, TITLE);
        this.m_ml.addListener(this);
        this.m_ml.setMinDisplayRows(6);
        LEScrollPanel lEScrollPanel = new LEScrollPanel(this.m_ml);
        lESplitterPanel.addColumn(100);
        lESplitterPanel.addComponent((Component)lEScrollPanel, 0);
        this.m_ta = new LETextArea();
        this.m_ta.setBufSize(24000);
        lESplitterPanel.addComponent((Component)this.m_ta, 0);
        return lESplitterPanel;
    }

    public void addMessage(LEHoundDogMessage lEHoundDogMessage) {
        this.m_incomingMessages.addElement(lEHoundDogMessage);
        this.update();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals(MESSAGE_DELETE)) {
            this.deleteSelectedMessages();
            return;
        }
        if (string.equals(MESSAGE_DELETE_ALL)) {
            this.deleteAllMessage();
            return;
        }
        if (string.equals(MESSAGE_DELETE_SAME)) {
            this.deleteSameMessageType();
        }
    }

    public void onLEMLEvent(LEMLEvent lEMLEvent) {
        int n = lEMLEvent.getType();
        int n2 = lEMLEvent.getRow();
        if (n == 1) {
            this.m_ta.setText("");
            LEHoundDogMessage lEHoundDogMessage = (LEHoundDogMessage)this.m_ml.getCellItem(n2, 7);
            Vector vector = lEHoundDogMessage.getMessages();
            UTUpdateTextAreaThread uTUpdateTextAreaThread = new UTUpdateTextAreaThread(this.m_ta, vector);
            Thread thread = new Thread(uTUpdateTextAreaThread);
            thread.setName("Text Area Update Thread");
            thread.start();
        }
    }

    public void update() {
        Enumeration enumeration = this.m_incomingMessages.elements();
        while (enumeration.hasMoreElements()) {
            Object e;
            LEPPPDebugMessage lEPPPDebugMessage;
            Object object;
            LEHoundDogMessage lEHoundDogMessage = (LEHoundDogMessage)enumeration.nextElement();
            String string = lEHoundDogMessage.getKey();
            if (lEHoundDogMessage.isNew()) {
                this.addNewRow(lEHoundDogMessage);
                continue;
            }
            int n = this.getSourceKeyRow(string);
            if (n == -1) continue;
            String string2 = (String)this.m_ml.getCellItem(n, 3);
            LEHoundDogMessage lEHoundDogMessage2 = (LEHoundDogMessage)this.m_ml.getCellItem(n, 7);
            Vector vector = lEHoundDogMessage2.getMessages();
            Vector vector2 = lEHoundDogMessage.getMessages();
            int n2 = vector2.size();
            int n3 = 0;
            while (n3 < n2) {
                vector.addElement(vector2.elementAt(n3));
                ++n3;
            }
            if (string2.equals("") && (object = vector.lastElement()) instanceof LEPPPDebugMessage && (string2 = (lEPPPDebugMessage = (LEPPPDebugMessage)object).getPortNum()) != null) {
                this.m_ml.setCellItem(n, 3, string2);
            }
            if (((E)(object = (Object)this.m_ml.getSelectedRows())).length >= 1 && (e = object[((E)object).length - 1]) >= 0 && n == e) {
                int n4 = 0;
                while (n4 < n2) {
                    this.updateTextArea(vector2.elementAt(n4));
                    ++n4;
                }
            }
            if (!lEHoundDogMessage.isTerminated()) continue;
            this.m_ml.setCellItem(n, 6, TERMINATED);
            this.m_ml.layoutGrid();
        }
        this.m_incomingMessages.removeAllElements();
    }

    private void addNewRow(LEHoundDogMessage lEHoundDogMessage) {
        Serializable serializable;
        Object object;
        String string = lEHoundDogMessage.getKey();
        String string2 = LEHoundDog.GetHostNameFromKey(string);
        String string3 = LEHoundDog.GetBoardNumFromKey(string);
        if (string3 == null || string3.equals("null")) {
            string3 = new String("");
        }
        String string4 = LEHoundDog.GetSourcePortFromKey(string);
        String string5 = null;
        String string6 = null;
        Vector vector = lEHoundDogMessage.getMessages();
        if (lEHoundDogMessage instanceof LEHoundDogDetailMessage) {
            object = (LEHoundDogDetailMessage)lEHoundDogMessage;
            string6 = ((LEHoundDogDetailMessage)object).getPortNumber();
            string5 = ((LEHoundDogDetailMessage)object).getModemNumber();
        } else if (string4.indexOf("M") != -1 && vector != null && vector.size() >= 0) {
            string5 = string4;
            if (vector.size() > 0) {
                object = vector.lastElement();
                if (object instanceof LEPPPDebugMessage) {
                    serializable = (LEPPPDebugMessage)object;
                    string6 = ((LEPPPDebugMessage)serializable).getPortNum();
                } else {
                    string6 = new String("");
                }
            } else {
                string6 = new String("");
            }
        } else {
            string6 = string4;
            string5 = new String("");
        }
        object = lEHoundDogMessage.getItemFound();
        serializable = new Date(System.currentTimeMillis());
        String string7 = ((Date)serializable).toString();
        Object[] objectArray = new Object[6];
        Object[] objectArray2 = new Object[]{object, string2, string3, string6, string5, string7, FOUND, lEHoundDogMessage};
        objectArray = objectArray2;
        int n = this.m_ml.getNumRows();
        if (n >= 150) {
            this.m_ml.deleteRow(0);
        }
        this.m_ml.addRow(objectArray);
        this.m_ml.layoutGrid();
        this.m_ml.redraw();
    }

    synchronized int getSourceKeyRow(String string) {
        int n = -1;
        int n2 = this.m_ml.getNumRows();
        int n3 = 0;
        while (n3 < n2) {
            LEHoundDogMessage lEHoundDogMessage;
            String string2 = (String)this.m_ml.getCellItem(n3, 6);
            if (!string2.equals(TERMINATED) && (lEHoundDogMessage = (LEHoundDogMessage)this.m_ml.getCellItem(n3, 7)).getKey().equals(string)) {
                return n3;
            }
            ++n3;
        }
        return n;
    }

    public void updateTextArea(Object object) {
        if (object instanceof LEDebugMessage) {
            String string;
            String string2 = ((LEDebugMessage)object).getData();
            if (string2 != null) {
                this.m_ta.append(string2);
                this.m_ta.append("\n");
            }
            if (object instanceof LEPPPDebugMessage && (string = ((LEPPPDebugMessage)object).getTranslatedString()) != null) {
                this.m_ta.append(string);
                this.m_ta.append("\n");
            }
        }
    }

    void display(String[] stringArray) {
    }

    void displayAll() {
    }

    void deleteSelectedMessages() {
        if (this.m_ml.getSelectSize() > 0) {
            int[] nArray = this.m_ml.getSelectedRows();
            this.m_ml.deleteRows(nArray);
            this.m_ta.setText("");
        }
    }

    void deleteAllMessage() {
        if (this.m_ml.getSelectSize() > 0) {
            this.m_ml.deleteAllRows();
            this.m_ta.setText("");
        }
    }

    synchronized void deleteSameMessageType() {
        if (this.m_ml.getSelectSize() > 0) {
            int[] nArray;
            int[] nArray2 = this.m_ml.getSelectedRows();
            String string = (String)this.m_ml.getCellItem(nArray2[0], 0);
            int n = this.m_ml.getNumRows();
            int n2 = 0;
            int[] nArray3 = nArray = new int[n2];
            int n3 = 0;
            while (n3 < n) {
                if (string.equals(this.m_ml.getCellItem(n3, 0))) {
                    nArray3 = nArray;
                    nArray = new int[++n2];
                    int n4 = nArray3.length;
                    int n5 = 0;
                    while (n5 < n4) {
                        nArray[n5] = nArray3[n5];
                        ++n5;
                    }
                    nArray[nArray.length - 1] = n3;
                }
                ++n3;
            }
            this.m_ml.deleteRows(nArray);
            this.m_ta.setText("");
        }
    }
}

