/*
 * Decompiled with CFR 0.152.
 */
package com.acme.crypto;

public class CryptoUtils {
    public static void zeroBlock(byte[] byArray, int n, int n2) {
        int n3 = n;
        while (n3 < n + n2) {
            byArray[n3] = 0;
            ++n3;
        }
    }

    public static void zeroBlock(byte[] byArray) {
        CryptoUtils.zeroBlock(byArray, 0, byArray.length);
    }

    public static void randomBlock(byte[] byArray, int n, int n2) {
        int n3 = n;
        while (n3 < n + n2) {
            byArray[n3] = (byte)(Math.random() * 256.0);
            ++n3;
        }
    }

    public static void randomBlock(byte[] byArray) {
        CryptoUtils.randomBlock(byArray, 0, byArray.length);
    }

    public static void xorBlock(byte[] byArray, int n, byte[] byArray2, int n2, byte[] byArray3, int n3, int n4) {
        int n5 = 0;
        while (n5 < n4) {
            byArray3[n3 + n5] = (byte)(byArray[n + n5] ^ byArray2[n2 + n5]);
            ++n5;
        }
    }

    public static void xorBlock(byte[] byArray, byte[] byArray2, byte[] byArray3) {
        CryptoUtils.xorBlock(byArray, 0, byArray2, 0, byArray3, 0, byArray.length);
    }

    public static void copyBlock(byte[] byArray, int n, byte[] byArray2, int n2, int n3) {
        int n4 = 0;
        while (n4 < n3) {
            byArray2[n2 + n4] = byArray[n + n4];
            ++n4;
        }
    }

    public static void copyBlock(byte[] byArray, byte[] byArray2) {
        CryptoUtils.copyBlock(byArray, 0, byArray2, 0, byArray.length);
    }

    public static boolean equalsBlock(byte[] byArray, int n, byte[] byArray2, int n2, int n3) {
        int n4 = 0;
        while (n4 < n3) {
            if (byArray[n + n4] != byArray2[n2 + n4]) {
                return false;
            }
            ++n4;
        }
        return true;
    }

    public static boolean equalsBlock(byte[] byArray, byte[] byArray2) {
        return CryptoUtils.equalsBlock(byArray, 0, byArray2, 0, byArray.length);
    }

    public static void fillBlock(byte[] byArray, int n, byte by, int n2) {
        int n3 = n;
        while (n3 < n + n2) {
            byArray[n3] = by;
            ++n3;
        }
    }

    public static void fillBlock(byte[] byArray, byte by) {
        CryptoUtils.fillBlock(byArray, 0, by, byArray.length);
    }

    public static void squashBytesToInts(byte[] byArray, int n, int[] nArray, int n2, int n3) {
        int n4 = 0;
        while (n4 < n3) {
            nArray[n2 + n4] = (byArray[n + n4 * 4] & 0xFF) << 24 | (byArray[n + n4 * 4 + 1] & 0xFF) << 16 | (byArray[n + n4 * 4 + 2] & 0xFF) << 8 | byArray[n + n4 * 4 + 3] & 0xFF;
            ++n4;
        }
    }

    public static void spreadIntsToBytes(int[] nArray, int n, byte[] byArray, int n2, int n3) {
        int n4 = 0;
        while (n4 < n3) {
            byArray[n2 + n4 * 4] = (byte)(nArray[n + n4] >>> 24);
            byArray[n2 + n4 * 4 + 1] = (byte)(nArray[n + n4] >>> 16);
            byArray[n2 + n4 * 4 + 2] = (byte)(nArray[n + n4] >>> 8);
            byArray[n2 + n4 * 4 + 3] = (byte)nArray[n + n4];
            ++n4;
        }
    }

    public static void squashBytesToShorts(byte[] byArray, int n, int[] nArray, int n2, int n3) {
        int n4 = 0;
        while (n4 < n3) {
            nArray[n2 + n4] = (byArray[n + n4 * 2] & 0xFF) << 8 | byArray[n + n4 * 2 + 1] & 0xFF;
            ++n4;
        }
    }

    public static void spreadShortsToBytes(int[] nArray, int n, byte[] byArray, int n2, int n3) {
        int n4 = 0;
        while (n4 < n3) {
            byArray[n2 + n4 * 2] = (byte)(nArray[n + n4] >>> 8);
            byArray[n2 + n4 * 2 + 1] = (byte)nArray[n + n4];
            ++n4;
        }
    }

    public static String toStringBlock(byte[] byArray, int n, int n2) {
        String string = "0123456789abcdef";
        StringBuffer stringBuffer = new StringBuffer();
        int n3 = n;
        while (n3 < n + n2) {
            stringBuffer.append(string.charAt(byArray[n3] >>> 4 & 0xF));
            stringBuffer.append(string.charAt(byArray[n3] & 0xF));
            ++n3;
        }
        return "[" + stringBuffer + "]";
    }

    public static String toStringBlock(byte[] byArray) {
        return CryptoUtils.toStringBlock(byArray, 0, byArray.length);
    }
}

