/*
 * Decompiled with CFR 0.152.
 */
package com.lucent.ra.nms.diag;

import com.lucent.ra.nms.amf.LEAMFactory;
import com.lucent.ra.nms.amf.LEAMObserver;
import com.lucent.ra.nms.backend.LEDebugFactory;
import com.lucent.ra.nms.backend.LEDebugMessage;
import com.lucent.ra.nms.diag.LEDiagFactory;
import com.lucent.ra.nms.util.LEAppInfo;
import com.lucent.ra.nms.util.LEDebug;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

public class LESmartDebugFactory
implements LEAMObserver {
    public static final String TYPE_MISC = "MISC";
    public static final String TYPE_PPP = "PPP";
    public static final String TYPE_ISDN_D = "TYPE_ISDN_D";
    public static final String TYPE_MDP = "TYPE_MDP";
    public static final String TYPE_L2TP = "TYPE_L2TP";
    public static final String TYPE_TERM = "TERMINATION";
    public static final String TYPE_LCP = "LCP";
    public static final String TYPE_PAP = "PAP";
    public static final String TYPE_CHAP = "CHAP";
    public static final String TYPE_IPCP = "IPCP";
    public static final String TYPE_IPXCP = "IPXCP";
    public static final String TYPE_CCP = "CCP";
    public static final String TYPE_BACP = "BACP";
    public static final String TYPE_BAP = "BAP";
    public static final String TYPE_UNKNOWN = "UNKNOWN";
    public static final String SPACE = " ";
    public static final String SLOT_STRING = "slot";
    public static final String RECV_STRING = "Received";
    public static final String SEND_STRING = "Sending";
    public static final String MDP_STRING = "mdp";
    public static final String TERMINATION_STRING = "Session Terminated";
    static LESmartDebugFactory s_factory = null;
    static Hashtable s_idsToTypeToDiagFactoryHT = new Hashtable();
    static FileWriter fw;
    static PrintWriter m_pw;

    public static LESmartDebugFactory GetFactory() {
        if (s_factory == null) {
            s_factory = new LESmartDebugFactory();
        }
        return s_factory;
    }

    public static void Register() {
        LESmartDebugFactory.GetFactory();
    }

    public void registerFactory(String string, LEDiagFactory lEDiagFactory, String string2) {
        if (string != null && lEDiagFactory != null && string2 != null) {
            if (!s_idsToTypeToDiagFactoryHT.containsKey(string2)) {
                s_idsToTypeToDiagFactoryHT.put(string2, new Hashtable());
                LEDebugFactory.GetFactory().addObserver(string2, this);
            }
            Hashtable hashtable = (Hashtable)s_idsToTypeToDiagFactoryHT.get(string2);
            hashtable.put(string, lEDiagFactory);
        }
    }

    public void removeObserver(String string) {
        if (s_idsToTypeToDiagFactoryHT.containsKey(string)) {
            LEDebugFactory.GetFactory().deleteObserver(string, this);
            s_idsToTypeToDiagFactoryHT.remove(string);
        }
    }

    public void removeFactory(String string, String string2) {
        Hashtable hashtable;
        if (s_idsToTypeToDiagFactoryHT.containsKey(string) && (hashtable = (Hashtable)s_idsToTypeToDiagFactoryHT.get(string)).containsKey(string2)) {
            hashtable.remove(string2);
            if (hashtable.size() == 0) {
                LEDebugFactory.GetFactory().deleteObserver(string, this);
                s_idsToTypeToDiagFactoryHT.remove(string);
            }
        }
    }

    public void update(LEAMFactory lEAMFactory, String string, Object object) {
        if (object instanceof LEDebugMessage) {
            String string2 = ((LEDebugMessage)object).getData();
            m_pw.println(string2);
            Vector vector = this.processLEDebugMessage((LEDebugMessage)object);
            int n = vector.size();
            int n2 = 0;
            while (n2 < n) {
                Object object2;
                LEDebugMessage lEDebugMessage = (LEDebugMessage)vector.elementAt(n2);
                String string3 = lEDebugMessage.getData();
                String string4 = this.determineType(string3);
                String string5 = lEDebugMessage.getHost();
                if (!s_idsToTypeToDiagFactoryHT.containsKey(string5)) {
                    return;
                }
                Hashtable hashtable = (Hashtable)s_idsToTypeToDiagFactoryHT.get(string5);
                if (string4.equals(TYPE_PPP) && hashtable.containsKey(TYPE_PPP)) {
                    object2 = (LEDiagFactory)hashtable.get(TYPE_PPP);
                    object2.process(lEDebugMessage);
                } else if (string4.equals(TYPE_MDP) && hashtable.containsKey(TYPE_MDP)) {
                    object2 = (LEDiagFactory)hashtable.get(TYPE_MDP);
                    object2.process(lEDebugMessage);
                } else if (string4.equals(TYPE_ISDN_D) && hashtable.containsKey(TYPE_ISDN_D)) {
                    object2 = (LEDiagFactory)hashtable.get(TYPE_ISDN_D);
                    object2.process(lEDebugMessage);
                } else if (string4.equals(TYPE_TERM) && hashtable.containsKey(TYPE_TERM)) {
                    object2 = (LEDiagFactory)hashtable.get(TYPE_TERM);
                    object2.process(lEDebugMessage);
                } else if (string4.equals(TYPE_MISC)) {
                    object2 = "didn't tag type correctly";
                    LEDebug.getLog().logln(20, (String)object2);
                    LEDebug.getLog().logln(20, string3);
                }
                ++n2;
            }
        }
    }

    public String determineType(String string) {
        if (string.indexOf(TERMINATION_STRING) != -1) {
            return TYPE_TERM;
        }
        if (this.isPPPMessage(string)) {
            return TYPE_PPP;
        }
        if (this.isDChannelMessage(string)) {
            return TYPE_ISDN_D;
        }
        if (this.isMDPMessage(string)) {
            return TYPE_MDP;
        }
        return TYPE_MISC;
    }

    boolean isPPPMessage(String string) {
        if (string.indexOf(TYPE_LCP) != -1) {
            return true;
        }
        if (string.indexOf(TYPE_CHAP) != -1) {
            return true;
        }
        if (string.indexOf(TYPE_IPCP) != -1) {
            return true;
        }
        if (string.indexOf(TYPE_IPXCP) != -1) {
            return true;
        }
        if (string.indexOf(TYPE_CCP) != -1) {
            return true;
        }
        if (string.indexOf(TYPE_BAP) != -1) {
            return true;
        }
        if (string.indexOf(TYPE_BACP) != -1) {
            return true;
        }
        if (string.indexOf(TYPE_UNKNOWN) != -1) {
            return true;
        }
        if (string.indexOf("Connection") != -1) {
            return true;
        }
        return string.indexOf(TYPE_PAP) != -1;
    }

    boolean isDChannelMessage(String string) {
        int n = string.length();
        int n2 = 0;
        while (n2 < n) {
            int n3 = string.indexOf("D", n2);
            if (n3 == -1) {
                return false;
            }
            n2 = n3;
            try {
                Integer n4 = Integer.valueOf(String.valueOf(string.charAt(n3 + 1)));
                char c = string.charAt(n3 + 2);
                if (c == ':') {
                    return true;
                }
                n4 = Integer.valueOf(String.valueOf(string.charAt(n3 + 2)));
                char c2 = string.charAt(n3 + 2);
                if (c2 == ':') {
                    return true;
                }
            }
            catch (NumberFormatException numberFormatException) {
                return false;
            }
            ++n2;
        }
        return false;
    }

    boolean isMDPMessage(String string) {
        if (string.indexOf(MDP_STRING) != -1) {
            return true;
        }
        if (string.indexOf("Modem M") != -1) {
            return true;
        }
        if (string.indexOf("Called-Station-ID") != -1) {
            return true;
        }
        if (string.indexOf("Caller-Station-ID") != -1) {
            return true;
        }
        if (string.indexOf("venus") != -1) {
            return true;
        }
        if (string.indexOf("modem-status") != -1) {
            return true;
        }
        if (string.indexOf("M") != -1) {
            try {
                int n = string.indexOf("M");
                Integer n2 = new Integer(String.valueOf(string.charAt(n + 1)));
                char c = string.charAt(n + 2);
                if (c == ':') {
                    return true;
                }
                n2 = new Integer(String.valueOf(string.charAt(n + 2)));
                char c2 = string.charAt(n + 3);
                return c2 == ':';
            }
            catch (Exception exception) {
                return false;
            }
        }
        return false;
    }

    protected Vector processLEDebugMessage(LEDebugMessage lEDebugMessage) {
        Vector<LEDebugMessage> vector = new Vector<LEDebugMessage>();
        boolean bl = false;
        StringBuffer stringBuffer = new StringBuffer();
        try {
            String string = lEDebugMessage.getData();
            StringTokenizer stringTokenizer = new StringTokenizer(string, "\r\n", false);
            String string2 = stringTokenizer.nextToken();
            if (string2.charAt(string2.length() - 1) == ' ') {
                string2 = string2.substring(0, string2.length() - 1);
            }
            stringBuffer.append(string2);
            while (stringTokenizer.hasMoreTokens()) {
                string2 = stringTokenizer.nextToken();
                if (string2.equals(SPACE)) {
                    if (!stringTokenizer.hasMoreTokens()) break;
                    string2 = stringTokenizer.nextToken();
                }
                if (string2.charAt(string2.length() - 1) == ' ') {
                    string2 = string2.substring(0, string2.length() - 1);
                }
                bl = false;
                if (string2.indexOf(SLOT_STRING) != -1) {
                    bl = true;
                }
                StringTokenizer stringTokenizer2 = new StringTokenizer(string2);
                String string3 = null;
                if (stringTokenizer2.hasMoreTokens()) {
                    string3 = stringTokenizer2.nextToken();
                }
                if (bl && stringTokenizer2.hasMoreTokens()) {
                    string3 = stringTokenizer2.nextToken();
                }
                try {
                    Integer.parseInt(string3, 16);
                    stringBuffer.append(SPACE);
                    stringBuffer.append(string3);
                    while (stringTokenizer2.hasMoreTokens()) {
                        String string4 = stringTokenizer2.nextToken();
                        Integer.parseInt(string4, 16);
                        stringBuffer.append(SPACE);
                        string4.trim();
                        stringBuffer.append(string4);
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    vector.addElement(new LEDebugMessage(lEDebugMessage.getRequestID(), lEDebugMessage.getTimestamp(), stringBuffer.toString(), lEDebugMessage.getHost()));
                    string2.trim();
                    stringBuffer = new StringBuffer(string2);
                }
            }
            vector.addElement(new LEDebugMessage(lEDebugMessage.getRequestID(), lEDebugMessage.getTimestamp(), stringBuffer.toString(), lEDebugMessage.getHost()));
        }
        catch (Exception exception) {
            LEDebug.getLog().logln(20, exception);
        }
        return vector;
    }

    static {
        try {
            String string = LEAppInfo.getUserAppDirPath("smartdebugfactory.log");
            fw = new FileWriter(string);
            m_pw = new PrintWriter((Writer)fw, true);
            m_pw.println("SmartDebugFactory log ");
        }
        catch (Exception exception) {
            LEDebug.getLog().logln(20, exception);
        }
    }
}

