/*
 * Decompiled with CFR 0.152.
 */
package com.lucent.ra.nms.diag.isdn;

import com.lucent.ra.nms.diag.LEDiagUtil;
import com.lucent.ra.nms.diag.isdn.LEInfoElement;
import java.util.Hashtable;

public class LEIECallState
extends LEInfoElement {
    int m_length;
    int m_callState;
    public static final Hashtable CALL_STATE = new Hashtable();

    public LEIECallState(int[] nArray) {
        super(nArray);
        this.fillInTheBlanks();
    }

    private void fillInTheBlanks() {
        this.m_length = this.m_data[1];
        this.m_callState = this.m_data[2];
    }

    public String getTranslatedString() {
        StringBuffer stringBuffer = new StringBuffer(20);
        stringBuffer.append("\n\t\tCall State Information Element");
        stringBuffer.append("\n\t\t" + this.getIdentifier());
        stringBuffer.append(" ,IE Element Length:" + this.m_length);
        stringBuffer.append(LEInfoElement.TABS);
        stringBuffer.append(LEDiagUtil.toHexString(this.m_data[2]));
        stringBuffer.append(" Call State:");
        Integer n = new Integer(this.m_callState);
        if (CALL_STATE.containsKey(n)) {
            stringBuffer.append(CALL_STATE.get(n));
        } else {
            stringBuffer.append("RESERVED");
        }
        return stringBuffer.toString();
    }

    static {
        CALL_STATE.put(new Integer(0), "Null");
        CALL_STATE.put(new Integer(1), "Call initiated");
        CALL_STATE.put(new Integer(2), "Overlap sending");
        CALL_STATE.put(new Integer(3), "Outgoing call proceeding");
        CALL_STATE.put(new Integer(4), "Call delivered");
        CALL_STATE.put(new Integer(6), "Call present");
        CALL_STATE.put(new Integer(7), "Call received");
        CALL_STATE.put(new Integer(8), "Connect request");
        CALL_STATE.put(new Integer(9), "Incoming call proceeding");
        CALL_STATE.put(new Integer(10), "Active");
        CALL_STATE.put(new Integer(11), "Disconnect request");
        CALL_STATE.put(new Integer(12), "Disconnect indication");
        CALL_STATE.put(new Integer(15), "Suspend request");
        CALL_STATE.put(new Integer(17), "Resume request");
        CALL_STATE.put(new Integer(19), "Release request");
        CALL_STATE.put(new Integer(25), "Overlap receiving");
        CALL_STATE.put(new Integer(45), "Restart request");
        CALL_STATE.put(new Integer(46), "Restart");
    }
}

