/*
 * Decompiled with CFR 0.152.
 */
package com.lucent.ra.nms.diag.isdn;

import com.lucent.ra.nms.diag.LEDiagUtil;
import com.lucent.ra.nms.diag.isdn.LEInfoElement;

public class LEIEConnectedNumber
extends LEInfoElement {
    int m_length;
    int m_typeOfNumber;
    int m_numPlanID;
    int m_presentationIndicator;
    int m_screeningIndicator;
    String m_numberDigits;

    public LEIEConnectedNumber(int[] nArray) {
        super(nArray);
        this.fillInTheBlanks();
    }

    private void fillInTheBlanks() {
        this.m_length = this.m_data[1];
        this.m_typeOfNumber = (this.m_data[2] & 0x70) >> 4;
        this.m_numPlanID = this.m_data[2] & 0xF;
        if ((this.m_data[2] & 0x50) >> 7 == 0) {
            this.m_presentationIndicator = (this.m_data[3] & 0x60) >> 5;
            this.m_screeningIndicator = this.m_data[3] & 3;
            StringBuffer stringBuffer = new StringBuffer();
            if (this.m_length <= this.m_data.length - 2) {
                char[] cArray = new char[this.m_length - 2];
                int n = 4;
                while (n < this.m_length + 2) {
                    cArray[n - 4] = (char)(this.m_data[n] & 0x7F);
                    ++n;
                }
                stringBuffer.append(cArray);
            } else {
                int n = 4;
                while (n < this.m_data.length) {
                    stringBuffer.append(String.valueOf(this.m_data[n] & 0x7F));
                    ++n;
                }
            }
            this.m_numberDigits = stringBuffer.toString();
            return;
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = 3;
        while (n < this.m_length + 2) {
            stringBuffer.append(String.valueOf(this.m_data[n] & 0x7F));
            ++n;
        }
        this.m_numberDigits = stringBuffer.toString();
    }

    public String getTranslatedString() {
        StringBuffer stringBuffer = new StringBuffer(20);
        stringBuffer.append("\n\t\tConnected Number Information Element");
        stringBuffer.append("\n\t\t" + this.getIdentifier());
        stringBuffer.append(" ,IE Element Length:" + this.m_length);
        stringBuffer.append(LEInfoElement.TABS);
        stringBuffer.append(LEDiagUtil.toHexString(this.m_data[2]));
        if (this.m_typeOfNumber > LEInfoElement.TYPE_OF_NUMBER.length) {
            stringBuffer.append(" Type Of Number:RESERVED");
        } else {
            stringBuffer.append(" Type Of Number:" + LEInfoElement.TYPE_OF_NUMBER[this.m_typeOfNumber]);
        }
        Integer n = new Integer(this.m_numPlanID);
        if (LEInfoElement.NUMBER_PLAN_ID.containsKey(n)) {
            stringBuffer.append(" ,Num Plan ID:" + LEInfoElement.NUMBER_PLAN_ID.get(n));
        } else {
            stringBuffer.append(" ,Num Plan ID:RESERVED");
        }
        if ((this.m_data[2] & 0x50) >> 7 == 0) {
            stringBuffer.append(LEInfoElement.TABS);
            stringBuffer.append(LEDiagUtil.toHexString(this.m_data[3]));
            stringBuffer.append(" Presentation Indicator:" + LEInfoElement.PRES_INDICATOR[this.m_presentationIndicator]);
            stringBuffer.append(" ,Screening Indicator:" + LEInfoElement.SCREEN_INDICATOR[this.m_screeningIndicator]);
        }
        stringBuffer.append("\n\t\tNumbers Digits:" + this.m_numberDigits);
        return stringBuffer.toString();
    }
}

