/*
 * Decompiled with CFR 0.152.
 */
package com.lucent.ra.nms.diag.isdn;

import com.lucent.ra.nms.diag.LEDiagUtil;
import com.lucent.ra.nms.diag.isdn.LEInfoElement;
import java.util.Hashtable;

public class LEIEFacility
extends LEInfoElement {
    int m_length;
    int m_serviceDis;
    int[] m_component;
    public static final Hashtable CALL_STATE_VALUE = new Hashtable();

    public LEIEFacility(int[] nArray) {
        super(nArray);
        this.fillInTheBlanks();
    }

    private void fillInTheBlanks() {
        this.m_length = this.m_data[1];
        this.m_serviceDis = this.m_data[2] & 0x1F;
        if ((this.m_data[2] & 0x50) == 0) {
            this.m_component = new int[this.m_length - 1];
            int n = 3;
            while (n < this.m_length + 1) {
                this.m_component[n - 3] = this.m_data[n];
                ++n;
            }
        }
    }

    public String getTranslatedString() {
        StringBuffer stringBuffer = new StringBuffer(20);
        stringBuffer.append("\n\t\tFacility Information Element");
        stringBuffer.append("\n\t\t" + this.getIdentifier());
        stringBuffer.append(" ,IE Element Length:" + this.m_length);
        stringBuffer.append(LEInfoElement.TABS);
        stringBuffer.append(LEDiagUtil.toHexString(this.m_data[2]));
        stringBuffer.append(" Service Discriminator:");
        if (this.m_serviceDis == 17) {
            stringBuffer.append("Suplementary services");
        } else if (this.m_serviceDis == 18) {
            stringBuffer.append("Management services");
        } else {
            stringBuffer.append("RESERVED");
        }
        if ((this.m_data[2] & 0x50) == 0) {
            stringBuffer.append("\n\t\tComponent:");
            int n = 0;
            while (n < this.m_component.length) {
                stringBuffer.append(this.m_component[n]);
                stringBuffer.append(" ");
                ++n;
            }
        }
        return stringBuffer.toString();
    }

    static {
        CALL_STATE_VALUE.put(new Integer(0), "Null");
        CALL_STATE_VALUE.put(new Integer(1), "Call Initiated");
        CALL_STATE_VALUE.put(new Integer(2), "Overlap Sending");
        CALL_STATE_VALUE.put(new Integer(3), "Outgoing Call Proceeding");
        CALL_STATE_VALUE.put(new Integer(4), "Call Delivered");
        CALL_STATE_VALUE.put(new Integer(6), "Call Present");
        CALL_STATE_VALUE.put(new Integer(7), "Call Received");
        CALL_STATE_VALUE.put(new Integer(8), "Connect Request");
        CALL_STATE_VALUE.put(new Integer(9), "Incoming Call Proceeding");
        CALL_STATE_VALUE.put(new Integer(10), "Active");
        CALL_STATE_VALUE.put(new Integer(11), "Disconnect Request");
        CALL_STATE_VALUE.put(new Integer(12), "Disconnect Indication");
        CALL_STATE_VALUE.put(new Integer(15), "Suspend request");
        CALL_STATE_VALUE.put(new Integer(17), "Resume request");
        CALL_STATE_VALUE.put(new Integer(19), "Release Request");
        CALL_STATE_VALUE.put(new Integer(25), "Overlap receiving");
        CALL_STATE_VALUE.put(new Integer(45), "Restart request");
        CALL_STATE_VALUE.put(new Integer(46), "Restart");
    }
}

