/*
 * Decompiled with CFR 0.152.
 */
package com.lucent.ra.nms.diag.isdn;

import com.lucent.ra.nms.diag.LEDiagUtil;
import com.lucent.ra.nms.diag.isdn.LEInfoElement;
import java.util.Hashtable;

public class LEIEProgressIndicator
extends LEInfoElement {
    int m_length;
    int m_codingStandard;
    int m_genLocation;
    int m_progressDesc;
    public static final Hashtable GENERAL_LOC = new Hashtable();
    public static final Hashtable PROGRESS_DESC;

    public LEIEProgressIndicator(int[] nArray) {
        super(nArray);
        this.fillInTheBlanks();
    }

    private void fillInTheBlanks() {
        this.m_length = this.m_data[1];
        this.m_codingStandard = this.m_data[2] & 3;
        this.m_genLocation = this.m_data[2] & 0xF;
        this.m_progressDesc = this.m_data[3] & 0x7F;
    }

    public String getTranslatedString() {
        StringBuffer stringBuffer = new StringBuffer(20);
        stringBuffer.append("\n\t\tProgress Indicator Information Element");
        stringBuffer.append("\n\t\t" + this.getIdentifier());
        stringBuffer.append(" ,IE Element Length:" + this.m_length);
        stringBuffer.append(LEInfoElement.TABS);
        stringBuffer.append(LEDiagUtil.toHexString(this.m_data[2]));
        stringBuffer.append(" Coding Standard:" + LEInfoElement.CODING_STANDARD[this.m_codingStandard]);
        Integer n = new Integer(this.m_genLocation);
        if (GENERAL_LOC.containsKey(n)) {
            stringBuffer.append(" ,General Location:" + GENERAL_LOC.get(n));
        } else {
            stringBuffer.append(" ,General Location:RESERVED");
        }
        n = new Integer(this.m_progressDesc);
        stringBuffer.append(LEInfoElement.TABS);
        stringBuffer.append(LEDiagUtil.toHexString(this.m_data[3]));
        if (PROGRESS_DESC.containsKey(n)) {
            stringBuffer.append("Progress Desc:" + PROGRESS_DESC.get(n));
        } else {
            stringBuffer.append("Progress Desc:RESERVED");
        }
        return stringBuffer.toString();
    }

    static {
        GENERAL_LOC.put(new Integer(0), "User");
        GENERAL_LOC.put(new Integer(1), "Private network serving the local user");
        GENERAL_LOC.put(new Integer(2), "Public network serving the local user");
        GENERAL_LOC.put(new Integer(3), "Transit network");
        GENERAL_LOC.put(new Integer(4), "Public network serving the remote user");
        GENERAL_LOC.put(new Integer(5), "Private network serving the remote user");
        GENERAL_LOC.put(new Integer(10), "Network beyond the interworking point");
        PROGRESS_DESC = new Hashtable();
        PROGRESS_DESC.put(new Integer(1), "Call is not end-to-end ISDN; further call progress information may be available in-band");
        PROGRESS_DESC.put(new Integer(2), "Destination address is non ISDN");
        PROGRESS_DESC.put(new Integer(3), "Origination address is non ISDN");
        PROGRESS_DESC.put(new Integer(4), "Call has returned to the ISDN");
        PROGRESS_DESC.put(new Integer(5), "Interworking has occurred and has resulted in a telecommunication service change ");
        PROGRESS_DESC.put(new Integer(8), "In-band information or an appropriate pattern is now available.");
    }
}

