/*
 * Decompiled with CFR 0.152.
 */
package com.lucent.ra.nms.diag.isdn;

import com.lucent.ra.nms.diag.LEDiagUtil;
import com.lucent.ra.nms.diag.isdn.LEInfoElement;
import java.util.Hashtable;

public class LEIETerminalCapabilities
extends LEInfoElement {
    int m_length;
    int m_codingStandard;
    int m_capabilityDesc;
    public static final Hashtable CALL_STATE_VALUE = new Hashtable();

    public LEIETerminalCapabilities(int[] nArray) {
        super(nArray);
        this.fillInTheBlanks();
    }

    private void fillInTheBlanks() {
        this.m_length = this.m_data[1];
        this.m_codingStandard = this.m_data[2] & 0xC0;
        this.m_capabilityDesc = this.m_data[2] & 0x3F;
    }

    public String getTranslatedString() {
        StringBuffer stringBuffer = new StringBuffer(20);
        stringBuffer.append("\n\t\tTerminal Capabilities Information Element");
        stringBuffer.append("\n\t\t" + this.getIdentifier());
        stringBuffer.append(" ,IE Element Length:" + this.m_length);
        stringBuffer.append(LEInfoElement.TABS);
        stringBuffer.append(LEDiagUtil.toHexString(this.m_data[2]));
        stringBuffer.append("Coding Standard:" + LEInfoElement.CODING_STANDARD[this.m_codingStandard]);
        stringBuffer.append(" ,Capability Desc:");
        if (this.m_capabilityDesc == 2) {
            stringBuffer.append("Type 2 Stimulus");
        } else {
            stringBuffer.append("???");
        }
        return stringBuffer.toString();
    }

    static {
        CALL_STATE_VALUE.put(new Integer(0), "Null");
        CALL_STATE_VALUE.put(new Integer(1), "Call Initiated");
        CALL_STATE_VALUE.put(new Integer(2), "Overlap Sending");
        CALL_STATE_VALUE.put(new Integer(3), "Outgoing Call Proceeding");
        CALL_STATE_VALUE.put(new Integer(4), "Call Delivered");
        CALL_STATE_VALUE.put(new Integer(6), "Call Present");
        CALL_STATE_VALUE.put(new Integer(7), "Call Received");
        CALL_STATE_VALUE.put(new Integer(8), "Connect Request");
        CALL_STATE_VALUE.put(new Integer(9), "Incoming Call Proceeding");
        CALL_STATE_VALUE.put(new Integer(10), "Active");
        CALL_STATE_VALUE.put(new Integer(11), "Disconnect Request");
        CALL_STATE_VALUE.put(new Integer(12), "Disconnect Indication");
        CALL_STATE_VALUE.put(new Integer(19), "Release Request");
    }
}

