/*
 * Decompiled with CFR 0.152.
 */
package com.lucent.ra.nms.diag.isdn;

import com.lucent.ra.nms.backend.LEDebugMessage;
import com.lucent.ra.nms.diag.LEDiagUtil;
import com.lucent.ra.nms.diag.isdn.LEIEBearerCapability;
import com.lucent.ra.nms.diag.isdn.LEIECallState;
import com.lucent.ra.nms.diag.isdn.LEIECalledPartyNumber;
import com.lucent.ra.nms.diag.isdn.LEIECallingPartyNumber;
import com.lucent.ra.nms.diag.isdn.LEIECause;
import com.lucent.ra.nms.diag.isdn.LEIEChannelIdent;
import com.lucent.ra.nms.diag.isdn.LEIEConnectedNumber;
import com.lucent.ra.nms.diag.isdn.LEIEConnectedSubAddress;
import com.lucent.ra.nms.diag.isdn.LEIEFacility;
import com.lucent.ra.nms.diag.isdn.LEIEInfoReq;
import com.lucent.ra.nms.diag.isdn.LEIEKeypad;
import com.lucent.ra.nms.diag.isdn.LEIENotificationDesc;
import com.lucent.ra.nms.diag.isdn.LEIEProgressIndicator;
import com.lucent.ra.nms.diag.isdn.LEIESendingComplete;
import com.lucent.ra.nms.diag.isdn.LEIESignal;
import com.lucent.ra.nms.diag.isdn.LEIESwitchHook;
import com.lucent.ra.nms.diag.isdn.LEIETerminalCapabilities;
import com.lucent.ra.nms.diag.isdn.LEInfoElement;
import com.lucent.ra.nms.util.LEDebug;
import java.util.Hashtable;
import java.util.StringTokenizer;

public class LEISDNDChannelMessage
extends LEDebugMessage {
    Integer m_iDSL;
    int m_iSeq;
    int m_iType;
    int m_iNsend;
    int m_iNrecv;
    String m_direction;
    int m_iTEI;
    int m_iSAP;
    int m_cr;
    byte m_ea0;
    byte m_ea1;
    int[] m_Data = new int[1500];
    int m_iDataLength;
    public static final String DIRECTION_PM = new String("DIRECTION_PM");
    public static final String DIRECTION_NETWORK = new String("DIRECTION_NETWORK");
    public static final String[] SAPI_SERVICE = new String[]{"Call Controll Signaling(Layer 3)", "X.25 Packet Encapsulation", "Signaling Access Control"};
    public static Hashtable TEI_PACKET_TYPES = new Hashtable();
    public static Hashtable UFRAME_TYPES;
    public static final Hashtable MESSAGE_TYPES;

    public LEISDNDChannelMessage(int n, long l, String string, String string2) {
        super(n, l, string, string2);
    }

    public static LEISDNDChannelMessage TranslateMessage(LEDebugMessage lEDebugMessage) {
        lEDebugMessage.getData();
        return new LEISDNDChannelMessage(lEDebugMessage.getRequestID(), lEDebugMessage.getTimestamp(), lEDebugMessage.getData(), lEDebugMessage.getHost());
    }

    public LEISDNDChannelMessage(LEDebugMessage lEDebugMessage) {
        super(lEDebugMessage.getRequestID(), lEDebugMessage.getTimestamp(), lEDebugMessage.getData(), lEDebugMessage.getHost());
        this.fillInTheBlanks();
    }

    private void fillInTheBlanks() {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        String string = this.getData();
        int n4 = string.length();
        try {
            int n5;
            if (n4 > 0 && (n5 = string.indexOf("D")) != -1) {
                Object object;
                String string2 = string.substring(n5);
                if (!string.equals(string2)) {
                    string = string2;
                }
                int n6 = string.length() - 3;
                Integer.valueOf(string.substring(1, 2));
                if (n6 > 8 && string.charAt(0) == 'D') {
                    ++n;
                    n2 = 0;
                    object = string.substring(1);
                    StringTokenizer stringTokenizer = new StringTokenizer((String)object, ":");
                    String string3 = stringTokenizer.nextToken();
                    this.m_iDSL = Integer.valueOf(string3);
                    n3 = string.indexOf("send");
                    if (n3 == -1) {
                        this.m_direction = DIRECTION_NETWORK;
                        n3 = string.indexOf("recv");
                        n3 = string.indexOf(" ", n3);
                    } else {
                        this.m_direction = DIRECTION_PM;
                    }
                    n3 = string.indexOf(" ", n3);
                    String string4 = string;
                    n2 = n6;
                }
                if (n2 >= 0) {
                    this.m_iDataLength = 0;
                    object = new StringTokenizer(string.substring(n3));
                    while (((StringTokenizer)object).hasMoreTokens()) {
                        this.m_Data[this.m_iDataLength++] = Integer.valueOf(((StringTokenizer)object).nextToken(), 16);
                    }
                    this.m_iSAP = this.m_Data[0] >> 2;
                    this.m_iTEI = this.m_Data[1] >> 1;
                    this.m_cr = (this.m_Data[0] & 2) >> 1;
                    this.m_ea0 = (byte)(this.m_Data[0] & 1);
                    this.m_ea1 = (byte)(this.m_Data[1] & 1);
                    return;
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            LEDebug.getLog().logln(20, numberFormatException);
            return;
        }
        catch (Exception exception) {
            LEDebug.getLog().logln(20, exception);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String getTranslatedString() {
        StringBuffer stringBuffer = new StringBuffer(30);
        switch (this.m_iSAP) {
            case 0: {
                stringBuffer.append("\tSAPI(0):Call Control Signaling (Layer 3)");
                break;
            }
            case 16: {
                stringBuffer.append("\tSAPI(16):X.25 Packet Encapsulation");
                break;
            }
            case 63: {
                stringBuffer.append("\tSAPI(63):Signaling Access Control");
                break;
            }
        }
        stringBuffer.append(" C/R: " + this.m_cr);
        stringBuffer.append(this.getCRMeaning());
        stringBuffer.append(" EA0: " + this.m_ea0);
        stringBuffer.append(" TEI: " + Integer.toString(this.m_iTEI, 16));
        stringBuffer.append(" EA1: " + this.m_ea1);
        if (this.m_iTEI == 127) {
            if (this.m_iDataLength > 3) {
                stringBuffer.append("\n\tReference Indicator(RI): " + this.m_Data[4] + " " + this.m_Data[5]);
            }
            if (this.m_iSAP == 63) {
                stringBuffer.append(this.getTEIManagementInfo());
                stringBuffer.append("\n");
                return stringBuffer.toString();
            } else {
                if (this.m_iSAP != 0) return stringBuffer.toString();
                if (this.m_iDataLength > 3) {
                    stringBuffer.append("\n");
                    stringBuffer.append("\t" + Integer.toString(this.m_Data[6]) + "SETUP Message");
                    int n = this.m_Data[5];
                    int[] nArray = new int[this.m_iDataLength - 7 - n];
                    int n2 = 0;
                    while (n2 < nArray.length) {
                        nArray[n2] = this.m_Data[7 + n + n2];
                        ++n2;
                    }
                    stringBuffer.append(this.newIE_Decode(nArray));
                    return stringBuffer.toString();
                } else {
                    if (this.m_Data[2] != 127) return stringBuffer.toString();
                    stringBuffer.append("SABME\n");
                }
            }
            return stringBuffer.toString();
        }
        try {
            switch (this.m_Data[2] & 3) {
                case 3: {
                    String string = this.getUFrameInfo();
                    stringBuffer.append(string);
                    stringBuffer.append("\n");
                    return stringBuffer.toString();
                }
                case 1: {
                    stringBuffer.append(this.getSFrameInfo());
                    return stringBuffer.toString();
                }
                case 0: 
                case 2: {
                    stringBuffer.append(" \n\tFrame Type:Information(I) Frame");
                    stringBuffer.append(this.decodeIFrame());
                    return stringBuffer.toString();
                }
                default: {
                    return stringBuffer.toString();
                }
            }
        }
        catch (Exception exception) {
            LEDebug.getLog().logln(20, exception);
        }
        return stringBuffer.toString();
    }

    String decodeIFrame() {
        StringBuffer stringBuffer = new StringBuffer(30);
        stringBuffer.append("\n\tNext Send N(S):" + LEDiagUtil.toHexString(this.m_Data[2] >> 1));
        stringBuffer.append(" ,Next Receive N(R):" + LEDiagUtil.toHexString(this.m_Data[3] >> 1));
        stringBuffer.append(" ,P/F:" + (this.m_Data[3] & 1));
        try {
            if (this.m_Data[4] == 8) {
                stringBuffer.append("\n\tProtocol Discriminator:0x08 ");
                int n = this.m_Data[5];
                stringBuffer.append("Reference Length:");
                stringBuffer.append(LEDiagUtil.toHexString(n));
                if (n > 0) {
                    int n2;
                    if (n > 1) {
                        stringBuffer.append("\n\tCall Reference #: ");
                        n2 = this.m_Data[6] & 0x7F;
                        int n3 = this.m_Data[7];
                        stringBuffer.append(LEDiagUtil.toHexString(n3 += (n2 <<= 8)));
                    } else {
                        stringBuffer.append("\n\tCall Reference #: " + LEDiagUtil.toHexString(this.m_Data[6] & 0x7F));
                    }
                    n2 = this.m_Data[6 + n];
                    Integer n4 = new Integer(n2);
                    if (MESSAGE_TYPES.containsKey(n4)) {
                        stringBuffer.append("\n\t " + LEDiagUtil.toHexString(this.m_Data[6 + n]) + " " + MESSAGE_TYPES.get(n4));
                        if (this.m_iDataLength - 7 - n > 0) {
                            int[] nArray = new int[this.m_iDataLength - 7 - n];
                            int n5 = 0;
                            while (n5 < nArray.length) {
                                nArray[n5] = this.m_Data[7 + n + n5];
                                ++n5;
                            }
                            stringBuffer.append(this.newIE_Decode(nArray));
                        }
                    } else {
                        stringBuffer.append("\t " + LEDiagUtil.toHexString(this.m_Data[6 + n]) + " Message type ?? ");
                    }
                } else {
                    stringBuffer.append(this.m_Data[5]);
                }
            }
            return stringBuffer.toString();
        }
        catch (Exception exception) {
            LEDebug.getLog().logln(20, exception);
            return null;
        }
    }

    String newIE_Decode(int[] nArray) {
        try {
            StringBuffer stringBuffer = new StringBuffer(40);
            LEInfoElement lEInfoElement = null;
            if (nArray.length > 2) {
                int[] nArray2 = nArray;
                while (nArray2.length >= 1) {
                    int n;
                    int n2;
                    switch (nArray2[0]) {
                        case 4: {
                            lEInfoElement = new LEIEBearerCapability(nArray2);
                            break;
                        }
                        case 8: {
                            lEInfoElement = new LEIECause(nArray2);
                            break;
                        }
                        case 112: {
                            lEInfoElement = new LEIECalledPartyNumber(nArray2);
                            break;
                        }
                        case 108: {
                            lEInfoElement = new LEIECallingPartyNumber(nArray2);
                            break;
                        }
                        case 20: {
                            lEInfoElement = new LEIECallState(nArray2);
                            break;
                        }
                        case 24: {
                            lEInfoElement = new LEIEChannelIdent(nArray2);
                            break;
                        }
                        case 12: {
                            lEInfoElement = new LEIEConnectedNumber(nArray2);
                            break;
                        }
                        case 13: {
                            lEInfoElement = new LEIEConnectedSubAddress(nArray2);
                            break;
                        }
                        case 28: {
                            lEInfoElement = new LEIEFacility(nArray2);
                            break;
                        }
                        case 50: {
                            lEInfoElement = new LEIEInfoReq(nArray2);
                            break;
                        }
                        case 44: {
                            lEInfoElement = new LEIEKeypad(nArray2);
                            break;
                        }
                        case 39: {
                            lEInfoElement = new LEIENotificationDesc(nArray2);
                            break;
                        }
                        case 30: {
                            lEInfoElement = new LEIEProgressIndicator(nArray2);
                            break;
                        }
                        case 26: {
                            lEInfoElement = new LEIESendingComplete(nArray2);
                            break;
                        }
                        case 52: {
                            lEInfoElement = new LEIESignal(nArray2);
                            break;
                        }
                        case 54: {
                            lEInfoElement = new LEIESwitchHook(nArray2);
                            break;
                        }
                        case 36: {
                            lEInfoElement = new LEIETerminalCapabilities(nArray2);
                            break;
                        }
                        default: {
                            stringBuffer.append("UNKNOWN IE");
                        }
                    }
                    if (lEInfoElement != null) {
                        String string = lEInfoElement.getTranslatedString();
                        stringBuffer.append(string);
                    }
                    if ((n2 = nArray2.length - ((n = nArray2[1]) + 2)) <= 0) break;
                    int[] nArray3 = nArray2;
                    nArray2 = new int[n2];
                    int n3 = n + 2;
                    while (n3 < nArray3.length) {
                        nArray2[n3 - (n + 2)] = nArray3[n3];
                        ++n3;
                    }
                }
            }
            if (stringBuffer.length() > 1) {
                return stringBuffer.toString();
            }
            return new String("UNKNOWN Information Element");
        }
        catch (Exception exception) {
            LEDebug.getLog().logln(20, exception);
            return new String("\n\t\tError Decoding Information Element");
        }
    }

    String getCRMeaning() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.m_direction.equals(DIRECTION_NETWORK)) {
            if (this.m_cr == 1) {
                stringBuffer.append(" (Command)");
            } else {
                stringBuffer.append(" (Response)");
            }
        } else if (this.m_cr == 0) {
            stringBuffer.append(" (Command)");
        } else {
            stringBuffer.append(" (Response)");
        }
        return stringBuffer.toString();
    }

    String getUFrameInfo() {
        StringBuffer stringBuffer = new StringBuffer(30);
        stringBuffer.append(" \n\tFrame Type:Unnumbered(U) Frame ");
        Integer n = new Integer(this.m_Data[2]);
        if (UFRAME_TYPES.containsKey(n)) {
            stringBuffer.append("\n\t");
            stringBuffer.append((String)UFRAME_TYPES.get(n));
            if (n.equals(new Integer(151))) {
                stringBuffer.append("\n\tRejected Frame:" + LEDiagUtil.toHexString(this.m_Data[3]));
                stringBuffer.append(" Control Field:" + LEDiagUtil.toHexString(this.m_Data[4]));
                stringBuffer.append("\n\tV(S):" + LEDiagUtil.toHexString(this.m_Data[5] >> 1));
                stringBuffer.append(" V(R):" + LEDiagUtil.toHexString(this.m_Data[6] >> 1));
                stringBuffer.append(" C/R:" + LEDiagUtil.toHexString(this.m_Data[6] & 1));
                stringBuffer.append("\n\tW:" + LEDiagUtil.toHexString(this.m_Data[7] & 1));
                stringBuffer.append("X:" + LEDiagUtil.toHexString((this.m_Data[7] & 2) >> 1));
                stringBuffer.append("Y:" + LEDiagUtil.toHexString((this.m_Data[7] & 4) >> 2));
                stringBuffer.append("Z:" + LEDiagUtil.toHexString((this.m_Data[7] & 8) >> 3));
            } else if (n.equals(new Integer(175)) || n.equals(new Integer(191))) {
                stringBuffer.append("\n\t  Information Field Octets:");
                int n2 = 3;
                while (n2 < this.m_iDataLength) {
                    stringBuffer.append(LEDiagUtil.toHexString(this.m_Data[n2]));
                    stringBuffer.append(" ");
                    ++n2;
                }
            }
        } else {
            stringBuffer.append("UA ?? " + Integer.toString(this.m_Data[2] >> 1, 16));
        }
        return stringBuffer.toString();
    }

    String getSFrameInfo() {
        StringBuffer stringBuffer = new StringBuffer(30);
        stringBuffer.append(" \n\tFrame Type:Supervisory(S) Frame \n");
        int n = (this.m_Data[2] & 0xC) >> 2;
        String string = LEDiagUtil.toHexString((this.m_Data[3] & 0xFE) >> 1);
        switch (n) {
            case 0: {
                stringBuffer.append("\t  Receiver Ready(RR), Next Receive N(R):" + string);
                stringBuffer.append(" P/F:" + (this.m_Data[3] & 1));
                break;
            }
            case 1: {
                stringBuffer.append("\t  Receiver Not Ready(RNR), Next Receive N(R):" + string);
                stringBuffer.append(" P/F:" + (this.m_Data[3] & 1));
                break;
            }
            case 2: {
                stringBuffer.append("\t  Reject(REJ), Next Receive N(R):" + string);
                stringBuffer.append(" P/F:" + (this.m_Data[3] & 1));
                break;
            }
            default: {
                stringBuffer.append("S ?? " + LEDiagUtil.toHexString(this.m_Data[2] >> 2));
            }
        }
        stringBuffer.append("\n");
        return stringBuffer.toString();
    }

    String getTEIManagementInfo() {
        StringBuffer stringBuffer = new StringBuffer(20);
        Integer n = new Integer(this.m_Data[6]);
        if (TEI_PACKET_TYPES.contains(n)) {
            stringBuffer.append("\n\t");
            stringBuffer.append((String)TEI_PACKET_TYPES.get(n));
            stringBuffer.append("Action Indicator(AI):");
            stringBuffer.append(LEDiagUtil.toHexString(this.m_Data[7] >> 1));
        } else {
            stringBuffer.append("\n\t?? ");
            stringBuffer.append(LEDiagUtil.toHexString(this.m_Data[6]));
            stringBuffer.append(" ");
            stringBuffer.append(LEDiagUtil.toHexString(this.m_Data[7] >> 1));
        }
        return stringBuffer.toString();
    }

    static {
        TEI_PACKET_TYPES.put(new Integer(1), "TEI Identity Request");
        TEI_PACKET_TYPES.put(new Integer(2), "TEI Identity Assigned");
        TEI_PACKET_TYPES.put(new Integer(3), "TEI Identity Denied");
        TEI_PACKET_TYPES.put(new Integer(4), "TEI Identity Check Request");
        TEI_PACKET_TYPES.put(new Integer(5), "TEI Identity Check Response");
        TEI_PACKET_TYPES.put(new Integer(6), "TEI Identity Remove");
        TEI_PACKET_TYPES.put(new Integer(6), "TEI Identity Verify Request");
        UFRAME_TYPES = new Hashtable();
        UFRAME_TYPES.put(new Integer(127), "Link Establishment(SABME)");
        UFRAME_TYPES.put(new Integer(31), "Disconnected Mode (DM)");
        UFRAME_TYPES.put(new Integer(19), "Unnumbered Information (UI)");
        UFRAME_TYPES.put(new Integer(83), "Disconnect (DISC)");
        UFRAME_TYPES.put(new Integer(115), "Unnumbered Acknowledgment (UA)");
        UFRAME_TYPES.put(new Integer(151), "Frame Reject(FRMR)");
        UFRAME_TYPES.put(new Integer(175), "Exchange Identification (XID)");
        UFRAME_TYPES.put(new Integer(191), "Exchange Identification (XID)");
        MESSAGE_TYPES = new Hashtable();
        MESSAGE_TYPES.put(new Integer(1), "ALERTING");
        MESSAGE_TYPES.put(new Integer(2), "CALL PROCEEDING");
        MESSAGE_TYPES.put(new Integer(7), "CONNECT");
        MESSAGE_TYPES.put(new Integer(15), "CONNECT ACKNOWLEDGE");
        MESSAGE_TYPES.put(new Integer(3), "PROGRESS");
        MESSAGE_TYPES.put(new Integer(5), "SETUP MESSAGE");
        MESSAGE_TYPES.put(new Integer(13), "SETUP ACKNOWLEDGE");
        MESSAGE_TYPES.put(new Integer(38), "RESUME");
        MESSAGE_TYPES.put(new Integer(46), "RESUME ACKNOWLEDGE");
        MESSAGE_TYPES.put(new Integer(34), "RESUME REJECT");
        MESSAGE_TYPES.put(new Integer(37), "SUSPEND");
        MESSAGE_TYPES.put(new Integer(33), "SUSPEND REJECT");
        MESSAGE_TYPES.put(new Integer(32), "USER INFORMATION");
        MESSAGE_TYPES.put(new Integer(69), "DISCONNECT");
        MESSAGE_TYPES.put(new Integer(77), "RELEASE");
        MESSAGE_TYPES.put(new Integer(90), "RELEASE COMPLETE");
        MESSAGE_TYPES.put(new Integer(70), "RESTART MESSAGE");
        MESSAGE_TYPES.put(new Integer(78), "RESTART ACKNOWLEDGE MESSAGE");
        MESSAGE_TYPES.put(new Integer(96), "SEGMENT");
        MESSAGE_TYPES.put(new Integer(121), "CONGESTION CONTROL");
        MESSAGE_TYPES.put(new Integer(123), "INFORMATION");
        MESSAGE_TYPES.put(new Integer(110), "NOTIFY");
        MESSAGE_TYPES.put(new Integer(125), "STATUS");
        MESSAGE_TYPES.put(new Integer(117), "STATUS ENQUIRY");
    }
}

