/*
 * Decompiled with CFR 0.152.
 */
package com.lucent.ra.nms.diag.ppp;

import com.lucent.ra.nms.backend.LEDebugMessage;
import com.lucent.ra.nms.diag.LEDiagFactory;
import com.lucent.ra.nms.diag.LEDiagUtil;
import com.lucent.ra.nms.diag.LESmartDebugFactory;
import com.lucent.ra.nms.diag.ppp.LEPPPBACPMessage;
import com.lucent.ra.nms.diag.ppp.LEPPPBAPMessage;
import com.lucent.ra.nms.diag.ppp.LEPPPCCPMessage;
import com.lucent.ra.nms.diag.ppp.LEPPPCHAPMessage;
import com.lucent.ra.nms.diag.ppp.LEPPPDebugMessage;
import com.lucent.ra.nms.diag.ppp.LEPPPIPCPMessage;
import com.lucent.ra.nms.diag.ppp.LEPPPIPXCPMessage;
import com.lucent.ra.nms.diag.ppp.LEPPPLCPMessage;
import com.lucent.ra.nms.diag.ppp.LEPPPPAPMessage;
import com.lucent.ra.nms.model.LEConnectionFacade;
import com.lucent.ra.nms.model.LEPMConnectionFacade;
import com.lucent.ra.nms.model.LEPortMaster;
import com.lucent.ra.nms.util.LEObservable;
import com.lucent.ra.nms.util.LEObserver;
import java.util.Hashtable;

public class LEPPPDebugFactory
extends LEObservable
implements LEDiagFactory {
    static Hashtable s_managers = new Hashtable();
    static Hashtable s_pms = new Hashtable();

    public LEPPPDebugFactory(String string) {
        LESmartDebugFactory lESmartDebugFactory = LESmartDebugFactory.GetFactory();
        lESmartDebugFactory.registerFactory("PPP", this, string);
    }

    public static LEPPPDebugFactory addObserver(LEPortMaster lEPortMaster, LEObserver lEObserver) {
        String string = lEPortMaster.getResourceID();
        LEPPPDebugFactory lEPPPDebugFactory = (LEPPPDebugFactory)s_managers.get(string);
        s_pms.put(string, lEPortMaster);
        if (lEPPPDebugFactory == null) {
            lEPPPDebugFactory = new LEPPPDebugFactory(string);
            s_managers.put(string, lEPPPDebugFactory);
            lEPPPDebugFactory.addObserver(lEObserver);
        } else {
            lEPPPDebugFactory.addObserver(lEObserver);
        }
        LEPPPDebugFactory.SetDebugFlags(lEPortMaster);
        return lEPPPDebugFactory;
    }

    public static String addObserver(String string, LEObserver lEObserver) {
        LEPPPDebugFactory lEPPPDebugFactory = (LEPPPDebugFactory)s_managers.get(string = LEDiagUtil.BuildDescriptiveID(string));
        if (lEPPPDebugFactory == null) {
            lEPPPDebugFactory = new LEPPPDebugFactory(string);
            s_managers.put(string, lEPPPDebugFactory);
            lEPPPDebugFactory.addObserver(lEObserver);
            return "Reading " + string + "\n";
        }
        lEPPPDebugFactory.addObserver(lEObserver);
        return "Reading " + string + "\n";
    }

    public LEDiagFactory getResourceFactory(String string) {
        return (LEDiagFactory)s_managers.get(string);
    }

    public void process(LEDebugMessage lEDebugMessage) {
        lEDebugMessage.getHost();
        LEPPPDebugMessage lEPPPDebugMessage = new LEPPPDebugMessage(lEDebugMessage);
        LEPPPDebugMessage lEPPPDebugMessage2 = this.processPPPDebugMessage(lEPPPDebugMessage);
        this.notifyObservers(lEPPPDebugMessage2);
    }

    public static boolean SetDebugFlags(LEPortMaster lEPortMaster) {
        LEConnectionFacade lEConnectionFacade = lEPortMaster.getConnectionFacade();
        if (!(lEConnectionFacade instanceof LEPMConnectionFacade)) {
            return false;
        }
        LEPMConnectionFacade lEPMConnectionFacade = (LEPMConnectionFacade)lEConnectionFacade;
        if (lEPMConnectionFacade != null) {
            return LEPPPDebugFactory.SendDebugCommand(lEPMConnectionFacade, -1);
        }
        return false;
    }

    public static boolean SendDebugCommand(LEPMConnectionFacade lEPMConnectionFacade, int n) {
        return lEPMConnectionFacade.startDebug(393216, 81, n);
    }

    public static void deleteObserver(String string, LEObserver lEObserver) {
        if (lEObserver == null || string == null) {
            return;
        }
        LEPPPDebugFactory lEPPPDebugFactory = (LEPPPDebugFactory)s_managers.get(string);
        if (lEPPPDebugFactory != null) {
            lEPPPDebugFactory.deleteObserver(lEObserver);
            if (lEPPPDebugFactory.countObservers() == 0) {
                lEPPPDebugFactory.stopDebugging(string);
            }
        }
    }

    private void stopDebugging(String string) {
        LEPortMaster lEPortMaster = (LEPortMaster)s_pms.get(string);
        if (lEPortMaster != null) {
            LEConnectionFacade lEConnectionFacade = lEPortMaster.getConnectionFacade();
            if (!(lEConnectionFacade instanceof LEPMConnectionFacade)) {
                return;
            }
            LEPMConnectionFacade lEPMConnectionFacade = (LEPMConnectionFacade)lEConnectionFacade;
            if (lEPMConnectionFacade != null) {
                lEPMConnectionFacade.stopDebug(393216, 81, -1);
            }
        }
    }

    public static boolean ChangeBoards(LEPortMaster lEPortMaster, int n, int n2) {
        String string = lEPortMaster.getResourceID();
        if (!s_pms.containsKey(string)) {
            return false;
        }
        LEConnectionFacade lEConnectionFacade = lEPortMaster.getConnectionFacade();
        if (!(lEConnectionFacade instanceof LEPMConnectionFacade)) {
            return false;
        }
        LEPMConnectionFacade lEPMConnectionFacade = (LEPMConnectionFacade)lEConnectionFacade;
        if (lEPMConnectionFacade == null) {
            return false;
        }
        if (n >= 0) {
            lEPMConnectionFacade.stopDebug(393216, 81, n);
            lEPMConnectionFacade.execute("set view " + n);
            lEPMConnectionFacade.execute("set debug off");
        }
        return LEPPPDebugFactory.SendDebugCommand(lEPMConnectionFacade, n2);
    }

    public LEPPPDebugMessage processPPPDebugMessage(LEPPPDebugMessage lEPPPDebugMessage) {
        String string = lEPPPDebugMessage.getType();
        if (string.equals("Connection Succeeded") || string.equals("Connection Failed")) {
            return lEPPPDebugMessage;
        }
        if (string.equals("LCP")) {
            return new LEPPPLCPMessage(lEPPPDebugMessage);
        }
        if (string.equals("PAP")) {
            return new LEPPPPAPMessage(lEPPPDebugMessage);
        }
        if (string.equals("CHAP")) {
            return new LEPPPCHAPMessage(lEPPPDebugMessage);
        }
        if (string.equals("IPCP")) {
            return new LEPPPIPCPMessage(lEPPPDebugMessage);
        }
        if (string.equals("CCP")) {
            return new LEPPPCCPMessage(lEPPPDebugMessage);
        }
        if (string.equals("IPXCP")) {
            return new LEPPPIPXCPMessage(lEPPPDebugMessage);
        }
        if (string.equals("BACP")) {
            return new LEPPPBACPMessage(lEPPPDebugMessage);
        }
        if (string.equals("BAP")) {
            return new LEPPPBAPMessage(lEPPPDebugMessage);
        }
        return lEPPPDebugMessage;
    }
}

