/*
 * Decompiled with CFR 0.152.
 */
package com.lucent.ra.nms.diag.ppp;

import com.lucent.ra.nms.diag.LEDiagUtil;
import com.lucent.ra.nms.diag.ppp.LEPPPDebugMessage;
import com.lucent.ra.nms.diag.ppp.LEPPPIPCPMessage;
import com.lucent.ra.nms.diag.ppp.LEPPPIPXCPMessage;
import com.lucent.ra.nms.diag.ppp.LEPPPOptionList;
import com.lucent.ra.nms.util.LEDebug;
import java.util.StringTokenizer;

public class LEPPPLCPMessage
extends LEPPPDebugMessage {
    private String m_code;
    private String m_id;
    private String m_length;
    private LEPPPOptionList m_optionList;
    public static final String SPACE = " ";
    public static final String CCP_PROTOCOL = "80FD";
    public static final String IPCP_PROTOCOL = "8021";
    public static final String IPXCP_PROTOCOL = "802B";
    public static final String LCP_OPEN = new String("LCP Open");
    public static final String LCP_LOOP = new String("LCP Apparent Loop");
    public static final String LCP_CONFIGURE_REQUEST = new String("01");
    public static final String LCP_CONFIGURE_ACK = new String("02");
    public static final String LCP_CONFIGURE_NAK = new String("03");
    public static final String LCP_CONFIGURE_REJECT = new String("04");
    public static final String LCP_TERMINATE_REQUEST = new String("05");
    public static final String LCP_TERMINATE_ACK = new String("06");
    public static final String LCP_CODE_REJECT = new String("07");
    public static final String LCP_PROTOCOL_REJECT = new String("08");
    public static final String LCP_ECHO_REQUEST = new String("09");
    public static final String LCP_ECHO_REPLY = new String("10");
    public static final String LCP_DISCARD_REQUEST = new String("11");
    public static final String[] LCP_OPTIONS = new String[]{"01", "Maximum-Receive-Unit", "02", "Async-Control-Character-Map", "03", "Authentication-Protocol", "04", "Quality-Protocol", "05", "Magic-Number", "06", "RESERVED", "07", "Protocol-Field-Compression", "08", "Address-and-Control-Field-Compression", "09", "FCS-Alternatives", "0A", "Self-Describing-Pad", "0B", "Numbered-Mode", "0C", "Multi-Link-Procedure", "0D", "Callback", "0E", "Connect-Time", "0F", "Compound-Frames", "10", "Nominal-Data-Encapsulation", "11", "Multilink-MRRU", "12", "Multilink-Short-Sequence-Number-Header", "13", "Multilink-Endpoint-Discriminator", "14", "Echo Request", "15", "DCE-Identifier", "16", "Multi-Link-Plus-Procedure", "17", "Link-Discriminator-for-BACP", "F5", "Echo Reply"};

    public LEPPPLCPMessage(int n, long l, String string, String string2) {
        super(n, l, string, string2);
    }

    public LEPPPLCPMessage(LEPPPDebugMessage lEPPPDebugMessage) {
        super(lEPPPDebugMessage);
        this.translateMessage(lEPPPDebugMessage);
    }

    public LEPPPLCPMessage(LEPPPDebugMessage lEPPPDebugMessage, String string, String string2, String string3, LEPPPOptionList lEPPPOptionList) {
        super(lEPPPDebugMessage);
        this.m_code = string;
        this.m_id = string2;
        this.m_length = string3;
        this.m_optionList = lEPPPOptionList;
    }

    void setOptionList(LEPPPOptionList lEPPPOptionList) {
        this.m_optionList = lEPPPOptionList;
    }

    void setCode(String string) {
        this.m_code = string;
    }

    public String getCode() {
        return this.m_code;
    }

    void setID(String string) {
        this.m_id = string;
    }

    public String getID() {
        return this.m_id;
    }

    void setLength(String string) {
        this.m_length = string;
    }

    public String getLength() {
        return this.m_length;
    }

    public String getAuthType() {
        if (this.m_optionList == null) {
            return null;
        }
        LEPPPOptionList lEPPPOptionList = this.m_optionList;
        while (lEPPPOptionList != null) {
            if (lEPPPOptionList.getOption().equals("03")) {
                return LEDiagUtil.outhex(lEPPPOptionList.getData());
            }
            lEPPPOptionList = lEPPPOptionList.getNextOptionList();
        }
        return null;
    }

    public boolean callbackEnabled() {
        if (this.m_optionList == null) {
            return false;
        }
        LEPPPOptionList lEPPPOptionList = this.m_optionList;
        while (lEPPPOptionList != null) {
            if (lEPPPOptionList.getOption().equals("0D")) {
                return true;
            }
            lEPPPOptionList = lEPPPOptionList.getNextOptionList();
        }
        return false;
    }

    public String getMagicNumber() {
        if (this.m_optionList == null) {
            return null;
        }
        LEPPPOptionList lEPPPOptionList = this.m_optionList;
        while (lEPPPOptionList != null) {
            if (lEPPPOptionList.getOption().equals("05")) {
                return LEDiagUtil.outhex(lEPPPOptionList.getData());
            }
            lEPPPOptionList = lEPPPOptionList.getNextOptionList();
        }
        return null;
    }

    public LEPPPOptionList getOptionList() {
        return this.m_optionList;
    }

    public void translateMessage(LEPPPDebugMessage lEPPPDebugMessage) {
        String string = lEPPPDebugMessage.getHexData();
        if (string == null) {
            return;
        }
        try {
            String string2 = string.substring(0, 2);
            String string3 = string.substring(3, 5);
            String string4 = LEDiagUtil.hex2decStr(LEDiagUtil.outhex(string.substring(6, 11)));
            this.m_code = string2;
            this.m_id = string3;
            this.m_length = string4;
            if (string.length() > 12) {
                LEPPPOptionList lEPPPOptionList = new LEPPPOptionList(string.substring(12));
                this.setOptionList(lEPPPOptionList);
                return;
            }
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            LEDebug.getLog().logln(20, stringIndexOutOfBoundsException);
            return;
        }
        catch (Exception exception) {
            LEDebug.getLog().logln(20, exception);
        }
    }

    public String getTranslatedString() {
        if (this.m_code == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer("\t[LCP] Packet Info:  Code: ");
        stringBuffer.append(this.m_code);
        stringBuffer.append(",  ID: ");
        stringBuffer.append(this.m_id);
        stringBuffer.append(", ");
        stringBuffer.append(this.m_length);
        stringBuffer.append(" bytes.");
        try {
            if (this.m_optionList != null) {
                LEPPPOptionList lEPPPOptionList = this.m_optionList;
                while (lEPPPOptionList != null) {
                    String string;
                    if (this.m_code.equals(LCP_PROTOCOL_REJECT)) {
                        string = this.processLCPProtocolReject(lEPPPOptionList);
                        stringBuffer.append(string);
                    } else if (!lEPPPOptionList.getOption().equals("00")) {
                        string = lEPPPOptionList.getOption();
                        int n = LCP_OPTIONS.length;
                        int n2 = 0;
                        while (n2 < n) {
                            if (LCP_OPTIONS[n2].equals(string)) break;
                            n2 += 2;
                        }
                        if (n2 + 1 < LCP_OPTIONS.length) {
                            stringBuffer.append("\n\t ");
                            stringBuffer.append(LCP_OPTIONS[n2 + 1]);
                            stringBuffer.append("[0x");
                            stringBuffer.append(string);
                            stringBuffer.append("], length: (");
                            stringBuffer.append(String.valueOf(lEPPPOptionList.getILength()));
                            stringBuffer.append(" bytes)");
                        } else {
                            stringBuffer.append("\n\t [0x");
                            stringBuffer.append(string);
                            stringBuffer.append("], length: (");
                            stringBuffer.append(String.valueOf(lEPPPOptionList.getILength()));
                            stringBuffer.append(" bytes)");
                        }
                        if (lEPPPOptionList.getData() != null) {
                            String string2 = lEPPPOptionList.getData().length() >= 5 ? new String(String.valueOf(lEPPPOptionList.getData().substring(0, 2)) + lEPPPOptionList.getData().substring(3, 5)).toUpperCase() : new String("");
                            int n3 = 208;
                            n2 = 0;
                            while (n2 < n3) {
                                if (LEPPPDebugMessage.PROTOCOL_LIST[n2].equals(string2)) break;
                                n2 += 2;
                            }
                            if (lEPPPOptionList.getOption().equals("01")) {
                                stringBuffer.append(LEDiagUtil.outhex(LEDiagUtil.hex2decStr(LEDiagUtil.outhex(lEPPPOptionList.getData()))));
                                stringBuffer.append(" bytes");
                            } else if (n2 < 207) {
                                stringBuffer.append(LEPPPDebugMessage.PROTOCOL_LIST[n2 + 1]);
                                stringBuffer.append(" [0x");
                                stringBuffer.append(LEDiagUtil.outhex(lEPPPOptionList.getData()));
                                stringBuffer.append("]");
                            } else {
                                stringBuffer.append("[0x");
                                stringBuffer.append(LEDiagUtil.outhex(lEPPPOptionList.getData()));
                                stringBuffer.append("]");
                            }
                        }
                        if (lEPPPOptionList.getOption().equals("11")) {
                            stringBuffer.append("\n\t\t Max-Receive-Reconstructed-Unit (MRRU): ");
                            stringBuffer.append(LEDiagUtil.hex2decStr(LEDiagUtil.outhex(lEPPPOptionList.getData())));
                            stringBuffer.append(" bytes ");
                        } else if (lEPPPOptionList.getOption().equals("13")) {
                            stringBuffer.append(LEDiagUtil.ParseEndPoint(lEPPPOptionList.getData()));
                        }
                    }
                    lEPPPOptionList = lEPPPOptionList.getNextOptionList();
                }
            }
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            LEDebug.getLog().logln(20, stringIndexOutOfBoundsException);
        }
        stringBuffer.append("\n");
        return stringBuffer.toString();
    }

    String processLCPProtocolReject(LEPPPOptionList lEPPPOptionList) {
        LEPPPOptionList lEPPPOptionList2 = lEPPPOptionList;
        StringBuffer stringBuffer = new StringBuffer();
        String string = lEPPPOptionList2.getData();
        if (string != null) {
            lEPPPOptionList2.getOption();
            lEPPPOptionList2.getLength();
            stringBuffer.append("\n\t Rejected Protocol:");
            StringBuffer stringBuffer2 = new StringBuffer(lEPPPOptionList2.getOption());
            stringBuffer2.append(lEPPPOptionList2.getLength());
            String string2 = stringBuffer2.toString().toUpperCase();
            String string3 = lEPPPOptionList2.getData();
            if (string2.equals(CCP_PROTOCOL)) {
                stringBuffer.append("[0x");
                stringBuffer.append(CCP_PROTOCOL);
                stringBuffer.append("],Compression Control Protocol ");
                stringBuffer.append("\n\t");
                stringBuffer.append(string3);
                stringBuffer.append("\n");
            } else if (string2.equals(IPCP_PROTOCOL)) {
                stringBuffer.append("[0x");
                stringBuffer.append(IPCP_PROTOCOL);
                stringBuffer.append("],Internet Protocol Control Protocol");
                stringBuffer.append("\n\t");
                stringBuffer.append(string3);
                stringBuffer.append("\n");
                LEPPPDebugMessage lEPPPDebugMessage = new LEPPPDebugMessage(this.getRequestID(), this.getTimestamp(), string3, this.getHost());
                lEPPPDebugMessage.setHexData(string3);
                LEPPPIPCPMessage lEPPPIPCPMessage = new LEPPPIPCPMessage(lEPPPDebugMessage);
                stringBuffer.append(lEPPPIPCPMessage.getTranslatedString());
            } else if (string2.equals(IPXCP_PROTOCOL)) {
                stringBuffer.append("[0x");
                stringBuffer.append(IPXCP_PROTOCOL);
                stringBuffer.append("],Internet Protocol Control Protocol");
                stringBuffer.append("\n\t");
                stringBuffer.append(string3);
                stringBuffer.append("\n");
                LEPPPDebugMessage lEPPPDebugMessage = new LEPPPDebugMessage(this.getRequestID(), this.getTimestamp(), string3, this.getHost());
                lEPPPDebugMessage.setHexData(string3);
                LEPPPIPXCPMessage lEPPPIPXCPMessage = new LEPPPIPXCPMessage(lEPPPDebugMessage);
                stringBuffer.append(lEPPPIPXCPMessage.getTranslatedString());
            } else {
                stringBuffer.append("[0x");
                stringBuffer.append(string2);
                stringBuffer.append("]");
                stringBuffer.append("\n\t Data:[0x");
                StringTokenizer stringTokenizer = new StringTokenizer(string3);
                while (stringTokenizer.hasMoreTokens()) {
                    stringBuffer.append(stringTokenizer.nextToken());
                }
                stringBuffer.append("]");
            }
        }
        return stringBuffer.toString();
    }
}

