/*
 * Decompiled with CFR 0.152.
 */
package com.lucent.ra.nms.ui;

import com.lucent.ra.nms.ui.LEColor;
import com.lucent.ra.nms.util.LEDebug;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.TextField;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;

public class LETextField
extends TextField
implements KeyListener,
FocusListener {
    boolean m_numeric = false;
    boolean m_hex = false;
    int m_cols = -1;
    long m_min = -1L;
    long m_max = -1L;
    boolean m_bounds = false;
    boolean m_limit_length = true;
    String m_realText;
    char m_echo;
    boolean m_regexp = false;

    public LETextField() {
        this.m_realText = new String();
    }

    public LETextField(int n) {
        super(n);
        this.m_cols = n;
    }

    public LETextField(String string) {
        super(string);
    }

    public LETextField(String string, int n) {
        super(string, n);
        this.m_cols = n;
    }

    public void addNotify() {
        super.addNotify();
        ((Component)this).setBackground(LEColor.getTextBackground());
        this.addKeyListener(this);
        this.addFocusListener(this);
    }

    public void setEchoChar(char c) {
        String string = this.getText();
        this.m_echo = c;
        this.setText(string);
    }

    public String getText() {
        if (this.m_echo > '\u0000') {
            return this.m_realText;
        }
        return super.getText();
    }

    public void setText(String string) {
        if (this.m_echo > '\u0000') {
            int n = string == null ? 0 : string.length();
            StringBuffer stringBuffer = new StringBuffer(n);
            int n2 = 0;
            while (n2 < n) {
                stringBuffer.append(this.m_echo);
                ++n2;
            }
            super.setText(stringBuffer.toString());
            if (string != null) {
                this.m_realText = string;
                return;
            }
        } else {
            super.setText(string);
        }
    }

    public long getLong() {
        long l = 0L;
        try {
            String string = this.getText();
            if (string.length() > 0) {
                l = this.m_hex ? Long.parseLong(string, 16) : Long.parseLong(string);
            }
        }
        catch (NumberFormatException numberFormatException) {}
        return l;
    }

    public int getInt() {
        int n = 0;
        try {
            String string = this.getText();
            if (string.length() > 0) {
                n = this.m_hex ? Integer.parseInt(string, 16) : Integer.parseInt(string);
            }
        }
        catch (NumberFormatException numberFormatException) {}
        return n;
    }

    public boolean isHex() {
        return this.m_hex;
    }

    public boolean isNumeric() {
        return this.m_numeric;
    }

    public boolean isBounded() {
        return this.m_bounds;
    }

    public boolean isRegExp() {
        return this.m_regexp;
    }

    public void setHex(boolean bl) {
        this.m_hex = bl;
        this.m_numeric = false;
    }

    public void setNumeric(boolean bl) {
        this.m_numeric = bl;
        this.m_hex = false;
    }

    public void setBounded(boolean bl) {
        this.m_bounds = bl;
    }

    public void setBounds(long l, long l2) {
        this.m_min = l;
        this.m_max = l2;
        this.m_bounds = true;
    }

    public void setLimitLength(boolean bl) {
        this.m_limit_length = bl;
    }

    public void setColumns(int n) {
        this.m_cols = n;
    }

    public void setRegExp(boolean bl) {
        this.m_regexp = bl;
    }

    public void keyPressed(KeyEvent keyEvent) {
        int n;
        int n2 = keyEvent.getKeyCode();
        boolean bl = keyEvent.isShiftDown();
        if (!this.validEditKey(n2)) {
            String string;
            if (this.m_hex && !this.validHexKey(n2)) {
                if (!keyEvent.isControlDown()) {
                    keyEvent.consume();
                    return;
                }
                if (this.validPasteKey(keyEvent, n2) && !this.checkPasteHex()) {
                    keyEvent.consume();
                    return;
                }
            }
            if (this.m_numeric && !this.validNumericKey(n2)) {
                if (!keyEvent.isControlDown()) {
                    keyEvent.consume();
                    return;
                }
                if (this.validPasteKey(keyEvent, n2) && !this.checkPasteNumeric()) {
                    keyEvent.consume();
                    return;
                }
            }
            if (this.m_regexp && !this.validRegExpKey(n2, bl)) {
                if (!keyEvent.isControlDown()) {
                    keyEvent.consume();
                    return;
                }
                if (this.validPasteKey(keyEvent, n2) && !this.checkPasteNumeric()) {
                    keyEvent.consume();
                    return;
                }
            }
            if (this.m_cols > -1 && this.getSelectionEnd() <= this.getSelectionStart() && this.m_limit_length && (string = this.getText()) != null && string.length() + 1 > this.m_cols) {
                keyEvent.consume();
                return;
            }
            if (this.m_echo > '\u0000' && this.displayableCharacter(keyEvent.getKeyChar())) {
                this.editRealText(0, keyEvent.getKeyChar());
                keyEvent.consume();
                return;
            }
        } else if (this.m_echo > '\u0000' && ((n = keyEvent.getKeyCode()) == 127 || n == 8)) {
            keyEvent.consume();
            this.editRealText(n, '\u0000');
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void focusGained(FocusEvent focusEvent) {
        if (this.getText() != null) {
            this.selectAll();
        }
    }

    public void focusLost(FocusEvent focusEvent) {
        if (this.m_bounds && (this.m_numeric || this.m_hex)) {
            this.checkBounds();
            return;
        }
        if (this.getText() != null) {
            this.select(0, 0);
        }
    }

    public synchronized Dimension getPreferredSize() {
        if (this.m_cols != -1) {
            return this.getPreferredSize(this.m_cols);
        }
        return super.getPreferredSize();
    }

    public boolean validEditKey(int n) {
        boolean bl = false;
        switch (n) {
            case 8: 
            case 9: 
            case 16: 
            case 37: 
            case 39: 
            case 127: {
                bl = true;
                break;
            }
        }
        return bl;
    }

    public boolean validHexKey(int n) {
        boolean bl = false;
        switch (n) {
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: {
                bl = true;
                break;
            }
        }
        return bl;
    }

    public boolean validNumericKey(int n) {
        boolean bl = false;
        switch (n) {
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: {
                bl = true;
                break;
            }
        }
        return bl;
    }

    public boolean validRegExpKey(int n, boolean bl) {
        boolean bl2 = false;
        if (this.validNumericKey(n)) {
            return true;
        }
        switch (n) {
            case 109: 
            case 189: 
            case 219: 
            case 221: {
                bl2 = true;
                break;
            }
            case 191: {
                if (!bl) break;
                bl2 = true;
                break;
            }
        }
        return bl2;
    }

    private void checkBounds() {
        long l = this.m_min;
        String string = this.getText();
        if (string.length() > 0) {
            try {
                if (this.m_numeric) {
                    l = Long.parseLong(string);
                } else if (this.m_hex) {
                    l = Long.parseLong(string, 16);
                }
                if (l > this.m_max) {
                    if (this.m_numeric) {
                        this.setText(Long.toString(this.m_max));
                    } else if (this.m_hex) {
                        this.setText(Long.toHexString(this.m_max));
                    }
                    this.selectAll();
                    Toolkit.getDefaultToolkit().beep();
                    return;
                }
                if (l < this.m_min) {
                    if (this.m_numeric) {
                        this.setText(Long.toString(this.m_min));
                    } else if (this.m_hex) {
                        this.setText(Long.toHexString(this.m_min));
                    }
                    this.selectAll();
                    Toolkit.getDefaultToolkit().beep();
                    return;
                }
                this.select(0, 0);
                return;
            }
            catch (NumberFormatException numberFormatException) {
                LEDebug.getLog().logln(20, numberFormatException);
                this.setText("");
                return;
            }
        }
    }

    protected boolean validCopyKey(KeyEvent keyEvent, int n) {
        return n == 67 && keyEvent.isControlDown();
    }

    protected boolean validPasteKey(KeyEvent keyEvent, int n) {
        return n == 86 && keyEvent.isControlDown();
    }

    private boolean checkPasteHex() {
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        Transferable transferable = clipboard.getContents(this);
        if (transferable == null) {
            return false;
        }
        try {
            String string = (String)transferable.getTransferData(DataFlavor.stringFlavor);
            int n = 0;
            while (n < string.length()) {
                char c = string.charAt(n);
                if (!this.isHexChar(c)) {
                    return false;
                }
                ++n;
            }
        }
        catch (Exception exception) {
            LEDebug.getLog().logln(20, exception);
            return false;
        }
        return true;
    }

    private boolean checkPasteNumeric() {
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        Transferable transferable = clipboard.getContents(this);
        if (transferable == null) {
            return false;
        }
        try {
            String string = (String)transferable.getTransferData(DataFlavor.stringFlavor);
            int n = 0;
            while (n < string.length()) {
                char c = string.charAt(n);
                if (!Character.isDigit(c)) {
                    return false;
                }
                ++n;
            }
        }
        catch (Exception exception) {
            LEDebug.getLog().logln(20, exception);
            return false;
        }
        return true;
    }

    protected boolean isHexChar(char c) {
        if (Character.isDigit(c)) {
            return true;
        }
        if (Character.toLowerCase(c) == 'a') {
            return true;
        }
        if (Character.toLowerCase(c) == 'b') {
            return true;
        }
        if (Character.toLowerCase(c) == 'c') {
            return true;
        }
        if (Character.toLowerCase(c) == 'd') {
            return true;
        }
        if (Character.toLowerCase(c) == 'e') {
            return true;
        }
        return Character.toLowerCase(c) == 'f';
    }

    boolean displayableCharacter(char c) {
        if (Character.isLetterOrDigit(c)) {
            return true;
        }
        switch (c) {
            case ' ': 
            case '!': 
            case '\"': 
            case '#': 
            case '$': 
            case '%': 
            case '&': 
            case '\'': 
            case '(': 
            case ')': 
            case '*': 
            case '+': 
            case ',': 
            case '-': 
            case '.': 
            case '/': 
            case ':': 
            case ';': 
            case '<': 
            case '=': 
            case '>': 
            case '?': 
            case '@': 
            case '\\': 
            case '^': 
            case '_': 
            case '`': 
            case '{': 
            case '|': 
            case '}': 
            case '~': {
                return true;
            }
        }
        return false;
    }

    boolean requiresShift(char c) {
        if (Character.isLetter(c)) {
            return Character.isUpperCase(c);
        }
        switch (c) {
            case '!': 
            case '\"': 
            case '#': 
            case '$': 
            case '%': 
            case '&': 
            case '(': 
            case ')': 
            case '*': 
            case '+': 
            case ':': 
            case '<': 
            case '>': 
            case '?': 
            case '@': 
            case '^': 
            case '_': 
            case '{': 
            case '|': 
            case '}': {
                return true;
            }
        }
        return false;
    }

    void editRealText(int n, char c) {
        int n2 = this.getSelectionStart();
        int n3 = this.getSelectionEnd();
        int n4 = this.m_realText.length();
        if (n == 8) {
            if (n2 == n3) {
                --n2;
            }
            if (n2 < 0) {
                return;
            }
        } else if (n == 127) {
            if (n2 == n3) {
                ++n3;
            }
            if (n3 > n4) {
                return;
            }
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (n2 > 0) {
            stringBuffer.append(this.m_realText.substring(0, n2));
        }
        if (c > '\u0000') {
            stringBuffer.append(c);
        }
        int n5 = stringBuffer.length();
        if (n3 < n4) {
            stringBuffer.append(this.m_realText.substring(n3));
        }
        this.m_realText = new String(stringBuffer);
        n4 = this.m_realText.length();
        stringBuffer.setLength(0);
        int n6 = 0;
        while (n6 < n4) {
            stringBuffer.append(this.m_echo);
            ++n6;
        }
        super.setText(new String(stringBuffer));
        this.setCaretPosition(n5);
    }
}

