/*
 * Decompiled with CFR 0.152.
 */
package com.lucent.ra.nms.util;

import com.lucent.ra.nms.util.LEClientMDF_R;
import com.lucent.ra.nms.util.LEClientPerf;
import com.lucent.ra.nms.util.LEDebug;
import com.lucent.ra.nms.util.LEDebugLog;
import com.lucent.ra.nms.util.LEMessageType;
import com.lucent.ra.nms.util.LETQClient;
import com.lucent.ra.nms.util.LEThreadedQueue;
import java.rmi.ConnectException;
import java.rmi.RemoteException;

public class LEServerPostBox {
    public long m_last_timeout;
    int m_messages_dropped = 0;
    LESPBX_postman m_postman = new LESPBX_postman();
    LEThreadedQueue m_incoming_messages = new LEThreadedQueue(this.m_postman);
    LEClientMDF_R m_client_mdf = null;

    public void postMessage(LEMessageType lEMessageType) {
        if (this.m_incoming_messages == null) {
            LEDebug.getLog().logln(20, "Server Postbox incorrectly set up.");
            LEDebug.getLog().logln(20, "  Server TQ is NULL!");
            return;
        }
        this.m_incoming_messages.add(lEMessageType);
    }

    public void setClientMDF(LEClientMDF_R lEClientMDF_R) {
        this.m_client_mdf = lEClientMDF_R;
    }

    public void flush() {
        this.m_incoming_messages.shutdown();
        this.m_incoming_messages = null;
        this.m_client_mdf = null;
    }

    public LEClientPerf getClientPerf() {
        LEThreadedQueue lEThreadedQueue = this.m_incoming_messages;
        return new LEClientPerf("", lEThreadedQueue.getQueueSize(), lEThreadedQueue.getIdleTime(), this.m_messages_dropped);
    }

    public void incrMessagesDropped() {
        ++this.m_messages_dropped;
    }

    class LESPBX_postman
    implements LETQClient {
        public void next(Object object) {
            LEMessageType lEMessageType = (LEMessageType)object;
            lEMessageType.getMessageAdminGroup();
            if (LEServerPostBox.this.m_client_mdf == null) {
                if (LEServerPostBox.this.m_last_timeout <= 0L) {
                    LEDebug.getLog().logln(10, "Server Postbox incorrectly set up.");
                    LEDebug.getLog().logln(10, "   client mdf not yet set");
                    LEServerPostBox.this.m_last_timeout = System.currentTimeMillis();
                    return;
                }
            } else {
                try {
                    LEDebugLog lEDebugLog = LEDebug.getLog();
                    if (lEDebugLog.getLogLevel() >= 100) {
                        StringBuffer stringBuffer = new StringBuffer("Sending a message of type '");
                        stringBuffer.append(lEMessageType.getMessageType());
                        stringBuffer.append("' with an admin group of '");
                        stringBuffer.append(lEMessageType.getMessageAdminGroup());
                        stringBuffer.append("'");
                        lEDebugLog.logln(100, stringBuffer.toString());
                    }
                    LEServerPostBox.this.m_client_mdf.receive(lEMessageType);
                    LEServerPostBox.this.m_last_timeout = 0L;
                    return;
                }
                catch (ConnectException connectException) {
                    if (LEServerPostBox.this.m_last_timeout == 0L) {
                        LEServerPostBox.this.m_last_timeout = System.currentTimeMillis();
                    }
                    object = null;
                    LEServerPostBox.this.incrMessagesDropped();
                    return;
                }
                catch (RemoteException remoteException) {
                    LEDebug.getLog().logln(20, "Exception while queueing to client : ");
                    LEDebug.getLog().logln(20, remoteException.getMessage());
                    if (LEServerPostBox.this.m_last_timeout == 0L) {
                        LEServerPostBox.this.m_last_timeout = System.currentTimeMillis();
                    }
                    object = null;
                    LEServerPostBox.this.incrMessagesDropped();
                    return;
                }
                catch (OutOfMemoryError outOfMemoryError) {
                    LEDebug.getLog().logln(10, "OutOfMemory sending a message to client");
                    if (LEServerPostBox.this.m_last_timeout == 0L) {
                        LEServerPostBox.this.m_last_timeout = System.currentTimeMillis();
                    }
                    object = null;
                    LEServerPostBox.this.incrMessagesDropped();
                    return;
                }
            }
        }

        LESPBX_postman() {
            LEServerPostBox.this = LEServerPostBox.this;
        }
    }
}

