/***********************************************************************

RADIUS
Remote Authentication Dial In User Service

Lucent Technologies Remote Access
4464 Willow Road
Pleasanton, CA   94588

Copyright 1992-1999 Lucent Technologies Inc.  All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are
met:

   * Redistributions of source code must retain the above copyright
     notice, this list of conditions and the following disclaimer.

   * Redistributions in binary form must reproduce the above
     copyright notice, this list of conditions and the following
     disclaimer in the documentation and/or other materials provided
     with the distribution.

   * All advertising materials mentioning features or use of this
     software must display the following acknowledgement:

	  This product includes software developed by Lucent
	  Technologies and its contributors.

   * Neither the name of the copyright holder nor the names of its
     contributors may be used to endorse or promote products derived
     from this software without specific prior written permission.

This software is provided by the copyright holders and contributors
``as is'' and any express or implied warranties, including, but not
limited to, the implied warranties of merchantability and fitness for a
particular purpose are disclaimed. In no event shall the copyright
holder or contributors be liable for any direct, indirect, incidental,
special, exemplary, or consequential damages (including, but not
limited to, procurement of substitute goods or services; loss of use,
data, or profits; or business interruption) however caused and on any
theory of liability, whether in contract, strict liability, or tort
(including negligence or otherwise) arising in any way out of the use
of this software, even if advised of the possibility of such damage.

************************************************************************/


static char sccsid[] =
"$Id: builddbm.c,v 1.19 1999/06/23 23:40:38 cdr Exp $ Copyright 1992-1999 Lucent Technologies Inc";

#include	<sys/types.h>
#include	<sys/socket.h>
#include	<sys/time.h>
#include	<sys/file.h>
#include	<netinet/in.h>

#include	<stdio.h>
#include	<netdb.h>
#include	<pwd.h>
#include	<time.h>
#include	<ctype.h>
#include        <errno.h>
#include	<string.h>

#include	"radius.h"

#if defined(NDBM)
# include	<ndbm.h>
# include	<fcntl.h>
#else	/* not NDBM */
# include	<dbm.h>
#endif	/* NDBM */

extern int      errno;

char		*progname;
char		*radius_dir;
char		*radius_log;
int		debug_flag = 0;
int		radius_dbm = 1;	/* needed for version() */
int		accept_zero = 0;

#define FIND_MODE_NAME	0
#define FIND_MODE_REPLY	1
#define FIND_MODE_SKIP	2
#define FIND_MODE_FLUSH	3

FILE		*userfd;
int		default_count;	/* number of DEFAULT entries found */
int		linenum;	/* line in users file, for error messages */
int		lineuser;	/* line current user started on, for error messages */

int
main(argc,argv)
int argc;
char **argv;
{
	char	argval;
	char	content[1024];
	char	name[128];
	datum	contentd;
	datum	named;
	int	chdir();
	int	errcount;	/* number of users not stored, usually dups */ 
	int	usercount;	/* number of users stored */
#ifdef	NDBM
	DBM	*db;
	int	xx;
#else	/* not NDBM */
	int	fd;
#endif	/* NDBM */
	int	user_read();
	void	usage();
	void	version();


	/* Parse arguments */

	progname = *argv++;
	argc--;
	radius_dir = ".";	/* default looks in current directory */

	while(argc) {

		if(**argv != '-') {
			usage();
		}

		argval = *(*argv + 1);
		argc--;
		argv++;

		switch(argval) {

		case 'd':
			if(argc == 0) {
				usage();
			}
			radius_dir = *argv;
			argc--;
			argv++;
			break;

		case 'h':
			usage();
			break;

                case 'l':       /* change logging from syslog */
                        if(argc == 0) {
                                usage();
                        }
                        radius_log = *argv;
                        argc--;
                        argv++;
                        break;

		case 'v':
			version();
			break;

		case 'x':
			debug_flag = 1;
			break;
		
		default:
			usage();
			break;
		}
	}


        if (debug_flag) {
                if (radius_log == (char *)NULL) {
                        /*
                         * for backward compatibility
                         * send messages to users tty
                         */
                        radius_log = "/dev/tty";
                } else if (strcmp(radius_log, "syslog") == 0) {
                        /*
                         * allow user to override backward compatibility
                         * and send debug to syslog
                         */
                        radius_log = (char *)NULL;
                }
        }


	/* Open Database */

	errno = 0;
	if (chdir(radius_dir) < 0) {
		fprintf(stderr, "%s: unable to change to directory %s - %s\n",progname,radius_dir,sys_errlist[errno]);
		exit(-1);
	}
#ifdef NDBM
	errno = 0;
	if((db = dbm_open("users", O_RDWR | O_CREAT | O_TRUNC, 0600))
							== (DBM *)NULL) {
		fprintf(stderr, "%s: dbm_open failed - %s\n", progname, sys_errlist[errno]);
		exit(-1);
	}

#else /* not NDBM */

	errno = 0;
	if((fd = open("users.pag", O_WRONLY | O_CREAT | O_TRUNC, 0600)) < 0) {
		fprintf(stderr,"%s: Couldn't open users.pag for writing - %s\n",progname,sys_errlist[errno]);
		exit(-1);
	}
	close(fd);

	errno = 0;
	if((fd = open("users.dir", O_WRONLY | O_CREAT | O_TRUNC, 0600)) < 0) {
		fprintf(stderr,"%s: Couldn't open users.dir for writing - %s\n",progname,sys_errlist[errno]);
		exit(-1);
	}
	close(fd);

	errno = 0;
	if(dbminit("users") != 0) {
		fprintf(stderr, "%s: dbminit failed - %s\n",progname, sys_errlist[errno]);
		exit(-1);
	}

#endif /* not NDBM */


	/* read through users file putting entries into database */

	default_count = 0;
	errcount = 0;
	usercount = 0;
	while(user_read(name, content) == 0) {
		named.dptr = name;
		named.dsize = strlen(name);
		contentd.dptr = content;
		contentd.dsize = strlen(content);
#ifdef NDBM
		if((xx = dbm_store(db, named, contentd, DBM_INSERT)) != 0)
#else /* not NDBM */
		if(store(named, contentd) != 0)
#endif /* not NDBM */

		{
			fprintf(stderr, "%s: could not store %s from line %d, check for duplicate\n", progname,name,lineuser);
			errcount++;
		} else {
			usercount++;
		}
	}
#ifdef NDBM
	dbm_close(db);
#else /* not NDBM */
	dbmclose();
#endif /* not NDBM */


	/* report results */

	printf("%s: %d user%s stored in DBM file",progname,usercount,usercount==1?"":"s");
	if (default_count > 0) {
		printf(" including %d DEFAULT entries\n",default_count);
	} else {
		printf("\n");
	}
	if (errcount > 0) {
		printf("%s: %d user%s not written to DBM file, check for duplicates\n",progname,errcount,errcount==1?"":"s");
	}
	exit(0);
}

/*************************************************************************
 *
 *	Function: user_read
 *
 *	Purpose: Return each user in the database - name is key content
 *		 is 2 strings - check values, and reply values seperated
 *		 by a newline.
 *
 *************************************************************************/

int
user_read(name, content)
char	*name;
char	*content;
{
	extern int	linenum;
	extern int	lineuser;
	static char	buffer[256];
	char		*ptr;
	int		mode;
	char 		*base_name = name;

	/*
	 * Open the user table
	 */
	if(userfd == (FILE *)NULL) {
		if((userfd = fopen(RADIUS_USERS, "r")) == (FILE *)NULL) {
			fprintf(stderr, "%s: could not open %s for reading\n",
					progname, buffer);
			exit(-1);
		}
		linenum = 0;
		*buffer = '\0';
	}

	mode = FIND_MODE_NAME;

	while(*buffer || (fgets(buffer, sizeof(buffer), userfd) != (char *)NULL)) {
		linenum++;	/* track line number for error messages */
		/* skip comments */
		if (*buffer == '#') {
			*buffer = '\0';
			continue;
		}
		if(mode == FIND_MODE_NAME) {
			/*
			 * Find the entry starting with the users name
			 */
			if(*buffer != '\t' && *buffer != ' '
						&& *buffer != '\n'
						&& *buffer != '\r') {
				ptr = buffer;
				while(*ptr != ' ' && *ptr != '\t' &&
								*ptr != '\0') {
					*name++ = *ptr++;
				}
				*name = '\0';
				if(*ptr == '\0') {
					continue;
				}
				if (strncmp(base_name, "DEFAULT",7) == 0) {
					if (default_count > 0) {
						sprintf(base_name, "DEFAULT%d",
							default_count);
					}  else {
						strcpy(base_name, "DEFAULT");
					}
					default_count++;
				}
				ptr++;
				while(*ptr == ' ' || *ptr == '\t') {
					ptr++;
				}
				strcpy(content, ptr);
				content += strlen(content);
				mode = FIND_MODE_REPLY;
				lineuser = linenum;
			}
			*buffer = '\0';
		}
		else {
			if(*buffer == ' ' || *buffer == '\t') {
				ptr = buffer;
				while(*ptr == ' ' || *ptr == '\t') {
					ptr++;
				}
				strcpy(content, ptr);
				content += strlen(content) - 1;
				/* strip trailing white space and comma */
				while(*content == ' ' || *content == '\t' ||
					*content == '\n' || *content == ',' ) {
					content--;
				}
				content++;
				*content = ',';
				content++;
				*content = '\0';
				*buffer = '\0';
			}
			else {
				/* We are done, leave buffer for next call */
				if (*buffer == '\n') {
					*buffer = '\0';
				} else {
					linenum--;
				}
				if(*(content - 1) == ',') {
					*(content-1) = '\0';
				}
				return(0);
			}
		}
	}
	if (mode == FIND_MODE_REPLY) {	/* return last entry */
		*buffer = '\0';
		if(*(content - 1) == ',') {
			*(content-1) = '\0';
		}
		return (0);
	}
	fclose(userfd);
	return(-1);
}


/*************************************************************************
 *
 *	Function: usage
 *
 *	Purpose: Display the syntax for starting this program.
 *
 *************************************************************************/

void
usage()
{
	fprintf(stderr, "Usage: %s", progname);
	fprintf(stderr, " [-d <db_dir>]");
	fprintf(stderr, " [-h]");
	fprintf(stderr, " [-v]");
	fprintf(stderr, " [-x]\n");
	exit(-1);
}
