/***********************************************************************

RADIUS
Remote Authentication Dial In User Service

Lucent Technologies Remote Access
4464 Willow Road
Pleasanton, CA   94588

Copyright 1992-1999 Lucent Technologies Inc.  All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are
met:

   * Redistributions of source code must retain the above copyright
     notice, this list of conditions and the following disclaimer.

   * Redistributions in binary form must reproduce the above
     copyright notice, this list of conditions and the following
     disclaimer in the documentation and/or other materials provided
     with the distribution.

   * All advertising materials mentioning features or use of this
     software must display the following acknowledgement:

	  This product includes software developed by Lucent
	  Technologies and its contributors.

   * Neither the name of the copyright holder nor the names of its
     contributors may be used to endorse or promote products derived
     from this software without specific prior written permission.

This software is provided by the copyright holders and contributors
``as is'' and any express or implied warranties, including, but not
limited to, the implied warranties of merchantability and fitness for a
particular purpose are disclaimed. In no event shall the copyright
holder or contributors be liable for any direct, indirect, incidental,
special, exemplary, or consequential damages (including, but not
limited to, procurement of substitute goods or services; loss of use,
data, or profits; or business interruption) however caused and on any
theory of liability, whether in contract, strict liability, or tort
(including negligence or otherwise) arising in any way out of the use
of this software, even if advised of the possibility of such damage.

************************************************************************/


static char sccsid[] =
"$Id: dbmkeys.c,v 1.8 1999/06/23 23:40:38 cdr Exp $ Copyright 1992-1999 Lucent Technologies Inc";

#include	<stddef.h>
#include	<fcntl.h>

#include	"radius.h"

#ifdef NDBM
# include	<ndbm.h>
#else /* not NDBM */
# include	<dbm.h>
#endif /* not NDBM */

extern int errno;
/* extern char *sys_errlist[]; */

main(argc, argv)
int argc;
char * argv[];
{
	datum		key;
#ifdef NDBM
	DBM		*db;
#endif /* NDBM */
	int		i;

#ifdef NDBM
	if ((db = dbm_open("raddb/users", O_RDONLY, 0)) == (DBM *)NULL)
#else /* not NDBM */
	if(dbminit("raddb/users") != 0)
#endif /* not NDBM */
	{
		printf("Couldn't open DBM file error<%s>\n",
				sys_errlist[errno]);
		exit(errno);
	}

	for (i=1; ; i++) {
		if (i == 1) {
#ifdef NDBM
			key = dbm_firstkey(db);
#else /* not NDBM */
			key = firstkey(db);
#endif /* not NDBM */
		} else {
#ifdef NDBM
			key = dbm_nextkey(db);
#else /* not NDBM */
			key = nextkey(key);
#endif /* not NDBM */
		}
		if(key.dsize == 0) {
			break;
		}
		key.dptr[key.dsize] = 0;
		printf(" %4d key <%s>\n", i, key.dptr);
	}

#ifdef NDBM
	dbm_close(db);
#else /* not NDBM */
	dbmclose();
#endif /* not NDBM */
	exit(0);
}
