/***********************************************************************

RADIUS
Remote Authentication Dial In User Service

Lucent Technologies Remote Access
4464 Willow Road
Pleasanton, CA   94588

Copyright 1992-1999 Lucent Technologies Inc.  All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are
met:

   * Redistributions of source code must retain the above copyright
     notice, this list of conditions and the following disclaimer.

   * Redistributions in binary form must reproduce the above
     copyright notice, this list of conditions and the following
     disclaimer in the documentation and/or other materials provided
     with the distribution.

   * All advertising materials mentioning features or use of this
     software must display the following acknowledgement:

	  This product includes software developed by Lucent
	  Technologies and its contributors.

   * Neither the name of the copyright holder nor the names of its
     contributors may be used to endorse or promote products derived
     from this software without specific prior written permission.

This software is provided by the copyright holders and contributors
``as is'' and any express or implied warranties, including, but not
limited to, the implied warranties of merchantability and fitness for a
particular purpose are disclaimed. In no event shall the copyright
holder or contributors be liable for any direct, indirect, incidental,
special, exemplary, or consequential damages (including, but not
limited to, procurement of substitute goods or services; loss of use,
data, or profits; or business interruption) however caused and on any
theory of liability, whether in contract, strict liability, or tort
(including negligence or otherwise) arising in any way out of the use
of this software, even if advised of the possibility of such damage.

************************************************************************/


static char sccsid[] =
"$Id: dbmrec.c,v 1.10 1999/06/23 23:40:39 cdr Exp $ Copyright 1992-1999 Lucent Technologies Inc";

#include	<stddef.h>
#include	<fcntl.h>

#include	"radius.h"

#ifdef NDBM
# include	<ndbm.h>
#else /* not NDBM */
# include	<dbm.h>
#endif /* NDBM */

int		radius_dbm;
char		*radius_dir;
char		*radius_log;
char		*progname;

int		accept_zero = 0;
int		debug_flag = 0;
int		debug_mem = 0;

extern int errno;
// extern char * sys_errlist[];

int
main(argc, argv)
int argc;
char * argv[];
{
	VALUE_PAIR	*values;
	char 		*ptr;
	datum		key;
	datum		rec;
	int		dict_init();
	int		userparse();
	void		pairfree();
	void		show_val();
	void		usage();
	void		log_version();
#ifdef NDBM
	DBM		*db;
#endif /* NDBM */

	progname = argv[0];
	if (argc != 2) {
		usage();
	}
	radius_dbm = 1;
	radius_dir = "raddb";
	radius_log = "/dev/tty";


	log_version();
	if(dict_init() != 0) {
		printf("dict_init FAILED\n");
		exit(1);
	}

#ifdef NDBM
	if ((db = dbm_open("raddb/users", O_RDONLY, 0)) == (DBM *)NULL)
#else /* not NDBM */
	if(dbminit("raddb/users") != 0)
#endif /* NDBM */
	{
		printf("Couldn't open DBM file error<%s>\n",
				sys_errlist[errno]);
		exit(errno);
	}

	key.dptr = argv[1];
	key.dsize = strlen(key.dptr);

#ifdef NDBM
	rec = dbm_fetch(db, key);
#else /* not NDBM */
	rec = fetch(key);
#endif /* NDBM */

	if (rec.dsize == 0) {
		printf("Record <%s> not found!\n", key.dptr);
	} else {
		printf("Recode <%s> len %d\n", key.dptr, rec.dsize);
		ptr = rec.dptr;
		rec.dptr[rec.dsize] = '\0';

		values = (VALUE_PAIR *)NULL;

		/*
		 * Parse check values
		 */
		if(userparse(ptr, &values) != 0) {
			log_err("userparse ERROR\n");
		}
		show_val("Check", values);
		pairfree(values,"main");
		values = (VALUE_PAIR *)NULL;

		while(*ptr != '\n' && *ptr != '\0') {
			ptr++;
		}
		if(*ptr == '\n') {
			ptr++;

			/*
			 * Parse reply values
			 */
			if(userparse(ptr, &values) != 0) {
				log_err("userparse ERROR\n");
			}
			show_val("Reply", values);
			pairfree(values,"main");
		}
	}

#ifdef NDBM
	dbm_close(db);
#else /* not NDBM */
	dbmclose();
#endif /* NDBM */
	exit(0);
}

void
show_val(str, vp)
char *str;
VALUE_PAIR *vp;
{
	printf("%s values:\n", str);
	while (vp) {
		printf("  <%s> = ", vp->name);
		switch(vp->type) {
		case PW_TYPE_STRING:
			printf("<%s>\n", vp->strvalue);
			break;
		case PW_TYPE_INTEGER:
		case PW_TYPE_IPADDR:
		case PW_TYPE_DATE:
			printf("<%x>\n",(unsigned int)vp->lvalue);
			break;
		}
		vp = vp->next;
	}
}

VALUE_PAIR *
get_attribute(value_list, attribute)
VALUE_PAIR	*value_list;
int		attribute;
{
	while(value_list != (VALUE_PAIR *)NULL) {
		if(value_list->attribute == attribute) {
			return(value_list);
		}
		value_list = value_list->next;
	}
	return((VALUE_PAIR *)NULL);
}

void
usage()
{
	printf("usage: %s <key>\n", progname);
	exit(1);
}

void
rad_exit(rc)
int rc;
{
	exit(rc);
}
