/*
 * Decompiled with CFR 0.152.
 */
package com.lucent.ra.nms.pmwizard;

import com.lucent.ra.nms.backend.LEConnectionManager;
import com.lucent.ra.nms.backend.LEDSSException;
import com.lucent.ra.nms.backend.LEDSSPMAuthFailureException;
import com.lucent.ra.nms.model.LEPMFactory;
import com.lucent.ra.nms.model.LEPortMaster;
import com.lucent.ra.nms.netboot.LEBootPARPTableHandler;
import com.lucent.ra.nms.netboot.LEBootPIPHandler;
import com.lucent.ra.nms.netboot.LEBootPPacketHandler;
import com.lucent.ra.nms.netboot.LEBootPServer;
import com.lucent.ra.nms.pmwizard.LEPMWizardModel;
import com.lucent.ra.nms.ui.LEActionClient;
import com.lucent.ra.nms.ui.LEActionDialog;
import com.lucent.ra.nms.ui.LEStatusBar;
import com.lucent.ra.nms.ui.LEUiUtils;
import com.lucent.ra.nms.util.LEAppInfo;
import com.lucent.ra.nms.util.LEDebug;
import com.lucent.ra.nms.util.LEIPAddress;
import com.lucent.ra.nms.util.LEStatusManager;
import com.lucent.ra.nms.wizard.LEWizardAction;
import com.lucent.ra.nms.wizard.LEWizardActionClient;
import com.lucent.ra.nms.wizard.LEWizardDataModel;
import java.awt.Component;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.NoRouteToHostException;
import java.net.SocketException;
import java.util.Hashtable;
import java.util.PropertyResourceBundle;

public class LEPMBootpAction
extends LEWizardAction
implements LEActionClient {
    public static final String IP_DONE = "SetupIPDone";
    static final int MAX_CONNECT_ATTEMPTS = 30;
    public static final String EXT_CONFIG_PROBLEM = "CONFIG_ERROR_MSG";
    public static final String CONFIG_PROBLEM = "Could not retrieve the configuration information.";
    static final String NO_DEVICE = "Could not find the device with the specified IP Address.  Make sure the device is on the same subnet.";
    static final String BAD_PASSWORD_MSG = "You entered a wrong password for this device.";
    static final String NEED_ROOT = "You need to be root in order to set the Internet address from the wizard!";
    static final String UNKNOWN_PROBLEM = "An unknown problem has occurred, please restart the wizard.";
    static final String SOCKET_EXCEPTION = "The BootP server could not start because another application is using the socket.";
    static final String SECURITY_EXCEPTION = "The BootP server could not start because you don't have the necessary privledges.";
    static final String CONNECTION_REFUSED = "Connection to the specified address was refused.";
    static final String SUCCESS = "Successful Connection.";
    static final String VENDOR_CODE = "00:c0:05:";
    static final int CONNECTED = 0;
    static final int NO_RESPONSE = -1;
    static final int BAD_PASSWORD = -2;
    static final int ROOT = -3;
    static final int NO_SOCKET = -4;
    static final int SECURITY = -5;
    static final int CONNECT_FAILURE = -6;
    static final int UNKNOWN_FAILURE = -20;
    boolean m_connected;
    boolean m_canceled = false;
    LEBootPPacketHandler m_ipHandler;
    LEActionDialog m_connectDlg;
    String m_problem;
    LEStatusBar m_status;
    LEPortMaster m_pm;
    LEStatusManager m_manager;
    PropertyResourceBundle m_resource = (PropertyResourceBundle)this.m_model.getObject(LEPMWizardModel.RESOURCE_BUNDLE);

    public LEPMBootpAction(LEWizardDataModel lEWizardDataModel, LEWizardActionClient lEWizardActionClient) {
        super(lEWizardDataModel, lEWizardActionClient);
        this.m_thread = new Thread(this);
    }

    public void run() {
        this.m_client.actionStart(this, "Connecting...");
        this.setupDialog();
        this.m_thread.suspend();
        if (this.m_canceled) {
            if (!this.m_connected) {
                this.m_model.set(LEPMWizardModel.CONNECTED, "off");
            }
            this.m_client.actionDone(this, "", -3);
            return;
        }
        if (!this.m_connected) {
            this.m_model.set(LEPMWizardModel.CONNECTED, "off");
            this.m_client.actionDone(this, this.m_problem, -1);
            return;
        }
        this.m_model.set(LEPMWizardModel.CONNECTED, "on");
        if (this.m_problem == null) {
            this.m_client.actionDone(this, "", 0);
            return;
        }
        this.m_client.actionDone(this, this.m_problem, -1);
    }

    public void actionStart(LEActionDialog lEActionDialog) {
        this.m_status = lEActionDialog.getStatusBar();
        this.m_status.setStatusText("Connecting to device");
        this.setupPM();
    }

    public void actionDone(LEActionDialog lEActionDialog) {
        if (this.m_thread != null) {
            this.m_thread.resume();
        }
    }

    public void actionCancel(LEActionDialog lEActionDialog) {
        this.m_canceled = true;
        if (this.m_pm != null) {
            this.m_pm.disconnect();
            this.m_pm = null;
        }
        if (this.m_thread != null) {
            this.m_thread.resume();
        }
    }

    void setupDialog() {
        this.m_manager = new LEStatusManager();
        this.m_connectDlg = new LEActionDialog(LEUiUtils.GetBaseFrame(), "Connecting...", this, this.m_manager);
        ((Component)this.m_connectDlg).setVisible(true);
        new Thread(this.m_connectDlg).start();
    }

    private int connectToPM() {
        LEConnectionManager lEConnectionManager = (LEConnectionManager)this.m_model.getObject(LEPMWizardModel.CONNECTION_MGR);
        try {
            this.m_pm = LEPMFactory.GetFromPM(lEConnectionManager, this.m_model.get(LEPMWizardModel.IPADDRESS), "!root", this.m_model.get(LEPMWizardModel.ADMIN_PASSWORD));
            if (this.m_pm != null && this.m_pm.isConnected()) {
                this.m_model.putObject(LEPMWizardModel.PORTMASTER, this.m_pm);
            }
        }
        catch (LEDSSPMAuthFailureException lEDSSPMAuthFailureException) {
            try {
                this.m_pm = LEPMFactory.GetFromPM(lEConnectionManager, this.m_model.get(LEPMWizardModel.IPADDRESS), "!root", "");
                if (this.m_pm != null && this.m_pm.isConnected()) {
                    this.m_model.putObject(LEPMWizardModel.PORTMASTER, this.m_pm);
                }
            }
            catch (LEDSSPMAuthFailureException lEDSSPMAuthFailureException2) {
                return -2;
            }
            catch (Exception exception) {
                LEDebug.getLog().logln(20, exception);
                return -20;
            }
        }
        catch (LEDSSException lEDSSException) {
            LEDebug.getLog().logln(20, lEDSSException);
            return -20;
        }
        catch (NoRouteToHostException noRouteToHostException) {
            return -1;
        }
        catch (ConnectException connectException) {
            LEDebug.getLog().logln(20, connectException);
            return -6;
        }
        catch (Exception exception) {
            LEDebug.getLog().logln(20, exception);
            return -20;
        }
        if (this.m_model.getObject(LEPMWizardModel.PORTMASTER) == null) {
            this.m_connected = false;
            return -1;
        }
        this.m_connected = true;
        return 0;
    }

    private void setupPM() {
        try {
            int n = this.connectToPM();
            if (n == -1) {
                int n2 = 0;
                if (LEAppInfo.isUnix()) {
                    String string = System.getProperty("user.name");
                    if (string.equals("root")) {
                        int n3 = this.runIPHandler();
                        if (n3 < 0) {
                            n = n3;
                            n2 = 30;
                        }
                        try {
                            Thread.currentThread();
                            Thread.sleep(15000L);
                        }
                        catch (Exception exception) {}
                    } else {
                        n = -3;
                        n2 = 30;
                    }
                } else {
                    int n4 = this.runIPHandler();
                    if (n4 < 0) {
                        n = n4;
                        n2 = 30;
                    }
                    try {
                        Thread.currentThread();
                        Thread.sleep(15000L);
                    }
                    catch (Exception exception) {}
                }
                while (n2 < 30) {
                    this.m_status.setStatusText("Setting the unit's ipaddress and then connecting...");
                    ++n2;
                    n = this.connectToPM();
                    if (n != 0) continue;
                    n2 = 30;
                }
            }
            switch (n) {
                case 0: {
                    this.m_status.setStatusText("Connected, getting configuration...");
                    if (!this.m_model.getModelInfo()) {
                        this.m_status.setStatusText("Could not get configuration!");
                        try {
                            this.m_problem = this.m_resource.getString(EXT_CONFIG_PROBLEM);
                        }
                        catch (Exception exception) {
                            this.m_problem = CONFIG_PROBLEM;
                        }
                    }
                    break;
                }
                case -2: {
                    this.m_status.setStatusText("Incorrect password");
                    this.m_problem = BAD_PASSWORD_MSG;
                    break;
                }
                case -3: {
                    this.m_problem = NEED_ROOT;
                    break;
                }
                case -5: {
                    this.m_problem = SECURITY_EXCEPTION;
                    break;
                }
                case -4: {
                    this.m_problem = SOCKET_EXCEPTION;
                    break;
                }
                case -6: {
                    this.m_problem = CONNECTION_REFUSED;
                    break;
                }
                case -20: {
                    this.m_problem = NO_DEVICE;
                    break;
                }
                default: {
                    this.m_problem = UNKNOWN_PROBLEM;
                    break;
                }
            }
        }
        catch (Exception exception) {
            this.m_status.setStatusText("Could not connect.");
            LEDebug.getLog().logln(20, exception);
        }
        if (this.m_ipHandler != null) {
            this.m_ipHandler.disconnect();
        }
    }

    private int runIPHandler() {
        try {
            String string = this.m_model.get(LEPMWizardModel.IPADDRESS);
            String string2 = this.m_model.get(LEPMWizardModel.MAC_ADDRESS);
            String string3 = LEIPAddress.determineBroadcastAddress(string, this.m_model.get(LEPMWizardModel.NETMASK));
            InetAddress inetAddress = InetAddress.getLocalHost();
            String string4 = inetAddress.getHostAddress();
            InetAddress inetAddress2 = InetAddress.getByName(string3);
            LEBootPServer.GetServer().startServer();
            if (string2.equals("")) {
                this.m_ipHandler = new LEBootPIPHandler(string, string4, inetAddress2);
            } else {
                Hashtable<String, String> hashtable = new Hashtable<String, String>();
                hashtable.put(string2, string);
                this.m_ipHandler = new LEBootPARPTableHandler(hashtable, string4, inetAddress2);
            }
        }
        catch (SecurityException securityException) {
            return -5;
        }
        catch (SocketException socketException) {
            return -4;
        }
        catch (Exception exception) {
            LEDebug.getLog().logln(20, exception);
            return -20;
        }
        return 0;
    }
}

