/*
 * Decompiled with CFR 0.152.
 */
package com.lucent.ra.nms.backend;

import com.lucent.ra.nms.backend.LEEntityMessage;
import com.lucent.ra.nms.util.LEDebug;
import com.lucent.ra.nms.util.LEUpTimeCompare;
import java.io.Serializable;

public class LEISDNSummaryMessage
extends LEEntityMessage
implements Serializable {
    String m_dno;
    String m_ports;
    String m_l1_state;
    String m_l2_state;
    int m_time;
    String m_ftime;
    String m_isdn_init;
    String m_isdn_up;
    String m_isdn_down;

    public LEISDNSummaryMessage(String string, int n, String string2) {
        super(string, n, string2);
    }

    public String getDNumber() {
        return this.m_dno;
    }

    public String getPorts() {
        return this.m_ports;
    }

    public String getL1State() {
        return this.m_l1_state;
    }

    public String getL2State() {
        return this.m_l2_state;
    }

    public int getTime() {
        return this.m_time;
    }

    public String getISDNInit() {
        return this.m_isdn_init;
    }

    public String getISDNUp() {
        return this.m_isdn_up;
    }

    public String getISDNDown() {
        return this.m_isdn_down;
    }

    public String getFormatedTime() {
        if (this.m_ftime == null) {
            this.m_ftime = LEUpTimeCompare.FormatTime(this.m_time);
        }
        return this.m_ftime;
    }

    public void setAttribute(int n, String string) {
        try {
            switch (n) {
                case 416: {
                    this.m_dno = string;
                    return;
                }
                case 275: {
                    this.setBoard(string);
                    return;
                }
                case 132: {
                    this.m_ports = string;
                    return;
                }
                case 67: {
                    this.m_time = Integer.parseInt(string);
                    return;
                }
                case 96: {
                    this.m_l1_state = string;
                    return;
                }
                case 127: {
                    this.m_l2_state = string;
                    return;
                }
                case 126: {
                    this.m_isdn_init = string;
                    return;
                }
                case 124: {
                    this.m_isdn_up = string;
                    return;
                }
                case 125: {
                    this.m_isdn_down = string;
                    return;
                }
            }
            LEDebug.getLog().logln(20, "Bad ISDN Summary Attribute: " + n + ", " + string);
            return;
        }
        catch (Exception exception) {
            LEDebug.getLog().logln(20, exception);
            return;
        }
    }
}

