/*
 * Decompiled with CFR 0.152.
 */
package com.lucent.ra.nms.backend;

import com.lucent.ra.nms.amf.LEAMRouter_RI;
import com.lucent.ra.nms.backend.LEDSSPortMaster_RI;
import com.lucent.ra.nms.backend.LESendResponse;
import com.lucent.ra.nms.util.LEAppInfo;
import com.lucent.ra.nms.util.LEDebug;
import com.lucent.ra.nms.util.LEObservable;
import com.lucent.ra.nms.util.LETokenizer;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;

public class LEPMListen
extends LEObservable
implements Runnable {
    static FileWriter s_dbgFile;
    static PrintWriter s_pw;
    LESendResponse m_sbIn;
    DataInputStream m_inStream;
    String m_id;
    boolean m_running = false;
    Thread m_thread;
    LEAMRouter_RI m_router = LEAMRouter_RI.GetAMRouter();

    public LEPMListen(DataInputStream dataInputStream, String string) {
        this.m_inStream = dataInputStream;
        this.m_id = string;
        if (s_dbgFile == null) {
            try {
                String string2 = LEAppInfo.getUserAppDirPath("dbgmsg.txt");
                File file = new File(string2);
                s_dbgFile = new FileWriter(file);
                s_pw = new PrintWriter((Writer)s_dbgFile, true);
                return;
            }
            catch (Exception exception) {
                s_dbgFile = null;
                s_pw = null;
                return;
            }
        }
    }

    public void run() {
        while (this.m_running) {
            this.readSocket();
        }
        this.m_thread = null;
    }

    void readSocket() {
        try {
            this.m_sbIn = new LESendResponse();
            this.m_sbIn.m_idByte = this.m_inStream.readByte();
            this.m_sbIn.m_opCode = this.m_inStream.readByte();
            this.m_sbIn.m_sendLength = this.m_inStream.readShort();
            this.m_sbIn.setSize(this.m_sbIn.m_sendLength);
            this.dumpLogV("Send Length: " + this.m_sbIn.m_sendLength);
            LEDSSPortMaster_RI.dumpSRMsg("Listened: " + LEDSSPortMaster_RI.GetOpCodeString(this.m_sbIn.m_opCode));
            LEPMListen.dumpSRMsg("Listened: " + LEDSSPortMaster_RI.GetOpCodeString(this.m_sbIn.m_opCode));
            this.m_inStream.readFully(this.m_sbIn.m_data, 0, this.m_sbIn.m_sendLength);
            switch (this.m_sbIn.m_opCode) {
                case 9: {
                    this.setChanged();
                    LEDSSPortMaster_RI.dumpSRMsg(this.m_sbIn.toString());
                    LEDSSPortMaster_RI.dumpSRMsg("End Listen");
                    LEDSSPortMaster_RI.dumpSRMsg("");
                    this.notifyObservers(this.m_sbIn);
                    return;
                }
                case 26: {
                    LEPMListen.dumpSRMsg(this.m_sbIn.toString());
                    LEPMListen.dumpSRMsg("End Listen");
                    LEPMListen.dumpSRMsg("");
                    LETokenizer lETokenizer = new LETokenizer(this.m_sbIn.m_data);
                    this.m_router.distribute(this.m_id, "MONITOR", lETokenizer);
                    return;
                }
                case 27: {
                    LEPMListen.dumpSRMsg(this.m_sbIn.toString());
                    LEPMListen.dumpSRMsg("End Listen");
                    LEPMListen.dumpSRMsg("");
                    LETokenizer lETokenizer = new LETokenizer(this.m_sbIn.m_data);
                    this.m_router.distribute(this.m_id, "DEBUG", lETokenizer);
                    return;
                }
                case 28: {
                    LEPMListen.dumpSRMsg(this.m_sbIn.toString());
                    LEPMListen.dumpSRMsg("End Listen");
                    LEPMListen.dumpSRMsg("");
                    LETokenizer lETokenizer = new LETokenizer(this.m_sbIn.m_data);
                    this.m_router.distribute(this.m_id, "DELTA", lETokenizer);
                    return;
                }
                case 30: {
                    LEPMListen.dumpSRMsg(this.m_sbIn.toString());
                    LEPMListen.dumpSRMsg("End Listen");
                    LEPMListen.dumpSRMsg("");
                    LETokenizer lETokenizer = new LETokenizer(this.m_sbIn.m_data);
                    this.m_router.distribute(this.m_id, "ALARM", lETokenizer);
                    return;
                }
                case 37: {
                    LEPMListen.dumpSRMsg(this.m_sbIn.toString());
                    LEPMListen.dumpSRMsg("End Listen");
                    LEPMListen.dumpSRMsg("");
                    LETokenizer lETokenizer = new LETokenizer(this.m_sbIn.m_data);
                    this.m_router.distribute(this.m_id, "ASYNC", lETokenizer);
                    return;
                }
                case 32: {
                    this.setChanged();
                    LEDSSPortMaster_RI.dumpSRMsg(this.m_sbIn.toString());
                    LEDSSPortMaster_RI.dumpSRMsg("End Listen");
                    LEDSSPortMaster_RI.dumpSRMsg("");
                    this.notifyObservers(this.m_sbIn);
                    return;
                }
                case 34: {
                    this.setChanged();
                    LEDSSPortMaster_RI.dumpSRMsg(this.m_sbIn.toString());
                    LEDSSPortMaster_RI.dumpSRMsg("End Listen");
                    LEDSSPortMaster_RI.dumpSRMsg("");
                    this.notifyObservers(this.m_sbIn);
                    return;
                }
                case 39: {
                    LEPMListen.dumpSRMsg(this.m_sbIn.toString());
                    LEPMListen.dumpSRMsg("End Listen");
                    LEPMListen.dumpSRMsg("");
                    LETokenizer lETokenizer = new LETokenizer(this.m_sbIn.m_data);
                    this.m_router.distribute(this.m_id, "CNM", lETokenizer);
                    return;
                }
                default: {
                    this.dumpLogV("Unexpected message: " + LEDSSPortMaster_RI.GetOpCodeString(this.m_sbIn.m_opCode));
                    return;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 18: 
                case 19: 
                case 20: 
                case 21: 
                case 22: 
                case 23: 
                case 24: 
                case 29: 
                case 33: 
                case 38: {
                    return;
                }
            }
        }
        catch (EOFException eOFException) {
            if (!this.m_running) {
                return;
            }
            this.m_running = false;
            LEDebug.getLog().logln(20, eOFException);
            LEDebug.getLog().logln(20, "LEPMListen Socket Exception ");
            EOFException eOFException2 = new EOFException("LEPMListen Socket Exception " + eOFException.getMessage());
            this.setChanged();
            this.notifyObservers(eOFException2);
            return;
        }
        catch (IOException iOException) {
            if (!this.m_running) {
                return;
            }
            this.m_running = false;
            LEDebug.getLog().logln(20, iOException);
            LEDebug.getLog().logln(20, "LEPMListen Socket Exception ");
            IOException iOException2 = new IOException("LEPMListen Socket Exception " + iOException.getMessage());
            this.setChanged();
            this.notifyObservers(iOException2);
            return;
        }
        catch (Exception exception) {
            if (!this.m_running) {
                return;
            }
            this.m_running = false;
            LEDebug.getLog().logln(20, "***** LEPMListen problem");
            LEDebug.getLog().logln(20, this.m_sbIn.toString());
            LEDebug.getLog().logln(20, exception);
            this.setChanged();
            this.notifyObservers(exception);
            return;
        }
    }

    public synchronized void start() {
        if (!this.m_running) {
            this.m_thread = new Thread(this);
            this.m_thread.setName("PM Listener for " + this.m_id);
            this.m_running = true;
            this.m_thread.start();
        }
    }

    public void shutdown() {
        try {
            if (this.m_running && this.m_thread != null) {
                this.m_thread.stop();
            }
            this.m_thread = null;
            if (this.m_inStream != null) {
                this.m_inStream.close();
            }
            this.m_inStream = null;
            return;
        }
        catch (Exception exception) {
            LEDebug.getLog().logln(20, exception);
            return;
        }
    }

    protected final void dumpLogV(String string) {
        LEDebug.getLog().logln(40, string);
    }

    public static void dumpSRMsg(String string) {
        if (s_pw != null && LEDebug.getLog().shouldLog(30)) {
            try {
                s_pw.println(string);
                return;
            }
            catch (Exception exception) {
                LEDebug.getLog().logln(20, exception);
                return;
            }
        }
    }
}

