/*
 * Decompiled with CFR 0.152.
 */
package com.lucent.ra.nms.netboot;

import com.lucent.ra.nms.netboot.LETFTPPacket;
import com.lucent.ra.nms.netboot.LETFTPServer;
import com.lucent.ra.nms.util.LEAppInfo;
import com.lucent.ra.nms.util.LEDebug;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;

public abstract class LETFTPClient {
    private static final int IPPORT_RESERVED_START = 1024;
    private static final int IPPORT_RESERVED_END = 20000;
    private int m_remotePort;
    private InetAddress m_remoteIPAddress;
    private String m_fullPath;
    private DatagramSocket m_socket;
    public static final int INIT = 1;
    public static final int XFER_IN_PROGRESS = 2;
    public static final int END_FAIL = 3;
    public static final int END_SUCCESS = 4;
    protected int m_state = 1;
    public static final String INIT_STR = "INITIALIZING";
    public static final String IN_PROGRESS_STR = "TRANSFER IN PROGRESS";
    public static final String END_FAIL_STR = "TRANSFER FAILED";
    public static final String END_SUCCESS_STR = "TRANSFER SUCCESSFUL";
    public static final String TERMINATED_STR = "TRANSFER TERMINATED";

    LETFTPClient(DatagramPacket datagramPacket) {
        this.m_remoteIPAddress = datagramPacket.getAddress();
        this.m_remotePort = datagramPacket.getPort();
        this.m_socket = this.createSocket();
        if (this.m_socket == null) {
            LEDebug.getLog().logln(20, "Could not open TFTP socket");
            return;
        }
        LETFTPServer.GetServer().printMsg("Socket created on local port " + this.m_socket.getLocalPort());
    }

    public String getFilePath() {
        return this.m_fullPath;
    }

    public int getRemotePort() {
        return this.m_remotePort;
    }

    public InetAddress getRemoteAddress() {
        return this.m_remoteIPAddress;
    }

    public int getState() {
        return this.m_state;
    }

    public String getStateStr() {
        switch (this.m_state) {
            case 1: {
                return INIT_STR;
            }
            case 2: {
                return IN_PROGRESS_STR;
            }
            case 3: {
                return END_FAIL_STR;
            }
            case 4: {
                return END_SUCCESS_STR;
            }
        }
        return "";
    }

    protected void send(LETFTPPacket lETFTPPacket) {
        DatagramPacket datagramPacket = new DatagramPacket(lETFTPPacket.getBytes(), lETFTPPacket.getSize(), this.m_remoteIPAddress, this.m_remotePort);
        try {
            this.m_socket.send(datagramPacket);
            return;
        }
        catch (IOException iOException) {
            LEDebug.getLog().logln(20, "Error sending packet");
            return;
        }
        catch (SecurityException securityException) {
            LEDebug.getLog().logln(20, "Error sending packet to destination" + this.m_remoteIPAddress.toString());
            return;
        }
    }

    protected void setFilePath(String string, String string2) {
        if (string2 != null) {
            if (string2.startsWith(string)) {
                this.m_fullPath = string2;
                return;
            }
            this.m_fullPath = LEAppInfo.createFullPath(string, string2);
            return;
        }
        this.m_fullPath = string;
    }

    protected DatagramSocket getSocket() {
        return this.m_socket;
    }

    private DatagramSocket createSocket() {
        int n = 1024;
        while (n < 20000) {
            try {
                DatagramSocket datagramSocket = new DatagramSocket(n);
                return datagramSocket;
            }
            catch (SocketException socketException) {
            }
            catch (SecurityException securityException) {}
            ++n;
        }
        return null;
    }

    public abstract String getType();

    public abstract int getBytesTransferred();

    public void terminate() {
        LETFTPServer.GetServer().printMsg("Terminating client " + this.m_remoteIPAddress.getHostAddress());
        if (this.m_socket != null) {
            this.m_socket.close();
            this.m_socket = null;
        }
    }

    protected void finalize() {
        if (this.m_socket != null) {
            this.m_socket.close();
            this.m_socket = null;
        }
    }
}

