/*
 * Decompiled with CFR 0.152.
 */
package com.lucent.ra.nms.netboot;

import com.lucent.ra.nms.netboot.LETFTPClientFactory;
import com.lucent.ra.nms.netboot.LEUDPServer;
import com.lucent.ra.nms.util.LEAppInfo;
import com.lucent.ra.nms.util.LEDebug;
import com.lucent.ra.nms.util.LEProperties;
import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.UnknownHostException;

public class LETFTPServer
extends LEUDPServer {
    public static final int TFTP_PORT = 69;
    public static final int MIN_TIMEOUT = 1;
    public static final int MAX_TIMEOUT = 30;
    private static final int DEF_TIMEOUT = 5;
    public static final int MIN_RETRIES = 0;
    public static final int MAX_RETRIES = 10;
    private static final int DEF_MAX_RETRIES = 5;
    private static final String PROP_TFTP_BASE_DIR = "tftp_base_dir";
    private static final String PROP_TFTP_TIMEOUT = "tftp_timeout";
    private static final String PROP_TFTP_MAX_RETRIES = "tftp_max_retries";
    private static LETFTPServer s_singleton = null;
    private PrintWriter m_pw;
    private LETFTPClientFactory m_clientFactory = new LETFTPClientFactory();
    private int m_timeoutInterval;
    private int m_maxRetries;
    private String m_baseDir;

    public static LETFTPServer GetServer() {
        if (s_singleton == null) {
            s_singleton = new LETFTPServer();
        }
        return s_singleton;
    }

    public LETFTPServer() {
        super(69);
        try {
            String string = LEAppInfo.getUserAppDirPath("tftplog.txt");
            File file = new File(string);
            FileWriter fileWriter = new FileWriter(file);
            this.m_pw = new PrintWriter((Writer)fileWriter, true);
            this.m_pw.println(LEAppInfo.getAppTitle());
            return;
        }
        catch (Exception exception) {
            this.m_pw = null;
            LEDebug.getLog().logln(20, exception);
            return;
        }
    }

    public void process(DatagramPacket datagramPacket) {
        this.printMsg("");
        this.printMsg("Received packet on port 69");
        this.m_clientFactory.addConnection(datagramPacket);
    }

    public void setTimeoutInterval(int n) {
        this.m_timeoutInterval = n;
    }

    public int getTimeoutInterval() {
        return this.m_timeoutInterval;
    }

    public void setMaxRetries(int n) {
        this.m_maxRetries = n;
    }

    public int getMaxRetries() {
        return this.m_maxRetries;
    }

    public void setBaseDir(String string) {
        this.m_baseDir = string;
    }

    public String getBaseDir() {
        return this.m_baseDir;
    }

    public void loadProperties() {
        String string = LEProperties.GetProperty(PROP_TFTP_BASE_DIR);
        if (string == null) {
            this.m_baseDir = LEAppInfo.getUserDirPath("tftpboot");
            File file = new File(this.m_baseDir);
            if (!file.exists() || !file.isDirectory()) {
                this.m_baseDir = LEAppInfo.getUserAppDir();
            }
        } else {
            this.m_baseDir = string;
        }
        this.m_timeoutInterval = (string = LEProperties.GetProperty(PROP_TFTP_TIMEOUT)) == null ? 5 : Integer.parseInt(string);
        string = LEProperties.GetProperty(PROP_TFTP_MAX_RETRIES);
        if (string == null) {
            this.m_maxRetries = 5;
            return;
        }
        this.m_maxRetries = Integer.parseInt(string);
    }

    public void saveProperties() {
        try {
            LEProperties.SetProperty(PROP_TFTP_BASE_DIR, this.m_baseDir);
            LEProperties.SetProperty(PROP_TFTP_MAX_RETRIES, Integer.toString(this.m_maxRetries));
            LEProperties.SetProperty(PROP_TFTP_TIMEOUT, Integer.toString(this.m_timeoutInterval));
            return;
        }
        catch (Exception exception) {
            LEDebug.getLog().logln(20, exception);
            return;
        }
    }

    public void printMsg(String string) {
        this.print(this.m_pw, string, true);
    }

    public void printMsg(String string, boolean bl) {
        this.print(this.m_pw, string, bl);
    }

    public LETFTPClientFactory getFactory() {
        return this.m_clientFactory;
    }

    public void startServer() {
        try {
            InetAddress inetAddress = InetAddress.getLocalHost();
            this.printMsg("Starting TFTP Server at address " + inetAddress.toString());
        }
        catch (UnknownHostException unknownHostException) {
            LEDebug.getLog().logln(30, "Unknown Host");
        }
        super.startServer();
    }

    public void stopServer() {
        this.printMsg("Terminating TFTP Server");
        this.m_clientFactory.closeConnections();
        super.stopServer();
    }
}

