/*
 * Decompiled with CFR 0.152.
 */
package com.lucent.ra.nms.netboot;

import com.lucent.ra.nms.util.LEDebug;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Date;

public class LEUDPServer
implements Runnable {
    private static final int MAX_PACKET_SIZE = 256;
    private int m_port;
    private Thread m_serverThread;
    private DatagramSocket m_socket;
    private boolean m_serverRunning;
    private String m_errorMsg = new String("");

    public LEUDPServer(int n) {
        this.m_port = n;
        this.m_serverRunning = false;
    }

    public void startServer() {
        if (this.m_serverRunning) {
            return;
        }
        try {
            InetAddress inetAddress = InetAddress.getLocalHost();
            this.m_socket = new DatagramSocket(this.m_port, inetAddress);
        }
        catch (SocketException socketException) {
            this.m_errorMsg = socketException.getMessage();
            LEDebug.getLog().logln(30, "Error opening socket on port " + Integer.toString(this.m_port) + "; " + socketException.getClass().getName() + socketException.getMessage());
            return;
        }
        catch (SecurityException securityException) {
            this.m_errorMsg = "Security error";
            LEDebug.getLog().logln(30, "Security error opening socket for port " + Integer.toString(this.m_port));
            return;
        }
        catch (UnknownHostException unknownHostException) {
            this.m_errorMsg = "Unknown Host";
            LEDebug.getLog().logln(30, this.m_errorMsg);
            return;
        }
        if (this.m_socket != null) {
            this.m_serverRunning = true;
            this.m_serverThread = new Thread(this);
            this.m_serverThread.start();
        }
    }

    public void run() {
        byte[] byArray = new byte[256];
        DatagramPacket datagramPacket = new DatagramPacket(byArray, byArray.length);
        while (true) {
            try {
                while (true) {
                    this.m_socket.receive(datagramPacket);
                    this.process(datagramPacket);
                }
            }
            catch (Exception exception) {
                LEDebug.getLog().logln(20, exception);
                continue;
            }
            break;
        }
    }

    public void send(DatagramPacket datagramPacket) throws IOException {
        this.m_socket.send(datagramPacket);
    }

    public void process(DatagramPacket datagramPacket) {
    }

    public void stopServer() {
        if (this.m_serverThread != null) {
            this.m_serverThread.stop();
        }
        if (this.m_socket != null) {
            this.m_socket.close();
        }
        this.m_serverRunning = false;
    }

    public void print(PrintWriter printWriter, String string, boolean bl) {
        if (printWriter != null && LEDebug.getLog().shouldLog(30)) {
            try {
                if (bl) {
                    Date date = new Date(System.currentTimeMillis());
                    printWriter.println(String.valueOf(string) + " at " + date.toString());
                    return;
                }
                printWriter.println(string);
                return;
            }
            catch (Exception exception) {
                LEDebug.getLog().logln(20, exception);
                return;
            }
        }
    }

    public boolean isServerRunning() {
        return this.m_serverRunning;
    }

    public String getErrorMessage() {
        return this.m_errorMsg;
    }

    protected void finalize() {
        if (this.m_socket != null) {
            this.m_socket.close();
        }
    }
}

