/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.button;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.SystemColor;
import oracle.ewt.button.ButtonContent;
import oracle.ewt.button.EwtButton;

public class DefaultableButton
extends EwtButton {
    private static final int _DEFAULT_RING_THICKNESS = 1;
    private boolean _default;

    public DefaultableButton(ButtonContent buttonContent) {
        super(buttonContent);
    }

    public DefaultableButton(String string) {
        super(string);
    }

    public void setDefault(boolean bl) {
        if (this._default != bl) {
            this._default = bl;
            this.repaint();
        }
    }

    public boolean isDefault() {
        return this._default;
    }

    public Dimension getMinimumSize() {
        Dimension dimension = super.getMinimumSize();
        dimension.width += 2;
        dimension.height += 2;
        return dimension;
    }

    public void paintInterior(Graphics graphics) {
        Dimension dimension = this.getSize();
        if (this.isDefault()) {
            Color color = graphics.getColor();
            graphics.setColor(SystemColor.controlDkShadow);
            graphics.drawRect(0, 0, dimension.width - 1, dimension.height - 1);
            graphics.setColor(color);
        }
        super.paintInterior(graphics);
    }

    protected Rectangle getPaintRectangle() {
        Rectangle rectangle = super.getPaintRectangle();
        if (this.isDefault()) {
            rectangle.grow(-1, -1);
        }
        return rectangle;
    }
}

