/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.dialog.directory;

import java.awt.Image;
import java.io.File;
import oracle.ewt.dTree.DTreeDeferredParent;
import oracle.ewt.dTree.DTreeDeferringParent;
import oracle.ewt.dTree.DTreeItemFactory;
import oracle.ewt.dataSource.OneDDataSource;
import oracle.ewt.dialog.directory.DirectoryItem;
import oracle.ewt.dialog.directory.DirectoryParentItemFactory;
import oracle.ewt.dialog.directory.DirectoryTree;
import oracle.ewt.dialog.directory.FileDataSource;
import oracle.ewt.dialog.directory.FileUtils;

class DirectoryParentItem
extends DTreeDeferredParent
implements DirectoryItem {
    public DirectoryParentItem(FileDataSource fileDataSource) {
        super(fileDataSource);
    }

    public File createDirectory(String string) {
        FileDataSource fileDataSource = this.getFileDataSource();
        return fileDataSource.createDirectory(string);
    }

    public File getDirectory() {
        DTreeDeferringParent dTreeDeferringParent = this.getDeferringParent();
        return (File)dTreeDeferringParent.getChildData(this.getIndex());
    }

    public Image getIcon() {
        return DirectoryTree.getDirectoryIcon();
    }

    public String getLabel() {
        File file = this.getDirectory();
        return FileUtils.getName(file);
    }

    public DTreeItemFactory getItemFactory() {
        return DirectoryParentItemFactory.getInstance();
    }

    public boolean isExpandable() {
        return true;
    }

    public void setExpanded(boolean bl) {
        OneDDataSource oneDDataSource;
        if (bl && (oneDDataSource = this.getDataSource()) instanceof FileDataSource) {
            FileDataSource fileDataSource = (FileDataSource)oneDDataSource;
            fileDataSource.itemExpanding();
        }
        super.setExpanded(bl);
    }

    protected FileDataSource getFileDataSource() {
        OneDDataSource oneDDataSource = this.getDataSource();
        return (FileDataSource)oneDDataSource;
    }
}

