/*
 * Decompiled with CFR 0.152.
 */
package com.lucent.ra.nms.ui;

import com.lucent.ra.nms.ui.LEColor;
import com.lucent.ra.nms.ui.LEListDrawInfo;
import com.lucent.ra.nms.ui.LEMLEvent;
import com.lucent.ra.nms.ui.LEMLListener;
import com.lucent.ra.nms.ui.LEScrollPanel;
import com.lucent.ra.nms.ui.LEScrollable;
import com.lucent.ra.nms.util.LEAlphaNumericCompare;
import com.lucent.ra.nms.util.LECompare;
import com.lucent.ra.nms.util.LENumCompare;
import com.lucent.ra.nms.util.LEVector;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Hashtable;

public class LEOptMultiList
extends Canvas
implements LECompare,
LEScrollable,
MouseListener,
MouseMotionListener {
    public static final int LEFT = 0;
    public static final int CENTER = 1;
    public static final int RIGHT = 2;
    boolean m_recalc;
    boolean m_resize;
    boolean m_redraw;
    boolean m_adjust;
    Image m_buf;
    int m_x;
    int m_y;
    Dimension m_area = new Dimension(0, 0);
    boolean m_smooth = true;
    LEScrollPanel m_panel;
    LEVector m_data = new LEVector();
    Hashtable m_rowObjs = new Hashtable();
    Dimension m_titles = new Dimension(0, 0);
    int m_numTitleRows;
    int m_numTitleCols;
    int m_rows;
    int m_cols;
    int m_height;
    int[] m_minWidths;
    int[] m_widths;
    int[] m_justs;
    int[] m_titleJusts;
    int[] m_fixed;
    Color m_dataBack = Color.white;
    Font m_font;
    Font m_bold;
    int m_cellHB = 4;
    int m_cellVB = 2;
    int m_cellOB = 1;
    int m_minDisplayRows;
    boolean m_grid = false;
    int m_minDragX;
    int m_dragCol;
    int m_dragX = -1;
    LEVector m_select = new LEVector();
    boolean m_multiSelect = true;
    Color m_selectFore = LEColor.getSelectForeground();
    Color m_selectBack = LEColor.getSelectBackground();
    LECompare m_comp = new LEAlphaNumericCompare();
    LECompare[] m_sortObj;
    boolean[] m_sortable;
    int m_sortCol = -1;
    int m_lastCol = -1;
    int m_currCol;
    boolean m_rev = false;
    LEVector m_listeners = new LEVector();

    public LEOptMultiList() {
    }

    public LEOptMultiList(int n, int n2, int n3) {
        this.initialize(n, n2, n3);
    }

    public void initialize(int n, int n2, int n3) {
        this.addMouseListener(this);
        this.m_numTitleRows = n;
        this.m_numTitleCols = n2;
        this.m_cols = n2 + n3;
        this.m_widths = new int[this.m_cols];
        this.m_minWidths = new int[this.m_cols];
        this.m_justs = new int[this.m_cols];
        this.m_titleJusts = new int[this.m_cols];
        this.m_fixed = new int[this.m_cols];
        this.m_sortObj = new LECompare[this.m_cols];
        this.m_sortable = new boolean[this.m_cols];
        int n4 = 0;
        while (n4 < this.m_cols) {
            this.m_sortable[n4] = true;
            ++n4;
        }
        int n5 = 0;
        while (n5 < this.m_numTitleRows) {
            this.m_data.addElement(null);
            ++this.m_rows;
            ++n5;
        }
    }

    public void addNotify() {
        super.addNotify();
        this.m_font = this.getFont();
        this.m_bold = new Font(this.m_font.getFamily(), 1, this.m_font.getSize());
    }

    public void addRow(String[] stringArray) {
        this.m_data.addElement(stringArray);
        ++this.m_rows;
        this.m_recalc = true;
    }

    public void deleteRow(int n) {
        if (this.delete(n += this.m_numTitleRows)) {
            this.notifyListeners(new LEMLEvent(this, 3));
        }
    }

    public void deleteRows(int[] nArray) {
        boolean bl = false;
        int n = nArray.length - 1;
        while (n > -1) {
            int n2 = nArray[n] + this.m_numTitleRows;
            bl |= this.delete(n2);
            --n;
        }
        if (bl) {
            this.notifyListeners(new LEMLEvent(this, 3));
        }
    }

    public void deleteAllRows() {
        boolean bl = false;
        int n = this.m_rows - 1;
        while (n >= this.m_numTitleRows) {
            bl |= this.delete(n);
            --n;
        }
        if (bl) {
            this.notifyListeners(new LEMLEvent(this, 3));
        }
    }

    public void addListener(LEMLListener lEMLListener) {
        this.m_listeners.addElementUnique(lEMLListener);
    }

    public void deleteListener(LEMLListener lEMLListener) {
        this.m_listeners.removeElement(lEMLListener);
    }

    public void swapRows(int n, int n2) {
        if ((n += this.m_numTitleRows) < this.m_rows && (n2 += this.m_numTitleRows) < this.m_rows) {
            this.m_data.swapElements(n, n2);
            this.m_redraw = true;
        }
    }

    public void setTitles(int n, String[] stringArray) {
        this.m_data.setElementAt(stringArray, n);
        this.m_recalc = true;
    }

    public void setGrid(boolean bl) {
        this.m_grid = bl;
        this.m_redraw = true;
    }

    public void setCellItem(int n, int n2, String string) {
        this.setCellString(n, n2, string);
    }

    public void setCellString(int n, int n2, String string) {
        if ((n += this.m_numTitleRows) < 0 || n >= this.m_rows) {
            return;
        }
        String[] stringArray = (String[])this.m_data.elementAt(n);
        if (stringArray == null || n2 >= stringArray.length) {
            return;
        }
        stringArray[n2] = string;
        this.m_recalc = true;
    }

    public void setRowObject(int n, Object object) {
        if ((n += this.m_numTitleRows) < 0 || n >= this.m_rows) {
            return;
        }
        Object object2 = this.m_data.elementAt(n);
        this.m_rowObjs.put(object2, object);
    }

    public void setCellJustification(int n, int n2) {
        if (n < 0 || n >= this.m_cols) {
            return;
        }
        this.m_justs[n] = n2;
        this.m_redraw = true;
    }

    public void setTitleJustification(int n, int n2) {
        if (n < 0 || n >= this.m_cols) {
            return;
        }
        this.m_titleJusts[n] = n2;
        this.m_redraw = true;
    }

    public void setSortable(int n, boolean bl) {
        if (n < 0 || n >= this.m_cols) {
            return;
        }
        this.m_sortable[n] = bl;
    }

    public void setSortObject(int n, LECompare lECompare) {
        if (n < 0 || n >= this.m_cols) {
            return;
        }
        this.m_sortObj[n] = lECompare;
    }

    public void setColumnWidth(int n, int n2) {
        if (n < 0 || n >= this.m_cols) {
            return;
        }
        this.m_fixed[n] = n2;
        this.m_recalc = true;
    }

    public void setSelectBackground(Color color) {
        this.m_selectBack = color;
        this.m_redraw = true;
    }

    public void setSelectForeground(Color color) {
        this.m_selectFore = color;
        this.m_redraw = true;
    }

    public void setMultipleSelect(boolean bl) {
        this.m_multiSelect = bl;
    }

    public void setMinDisplayRows(int n) {
        this.m_minDisplayRows = n;
    }

    public void setSmoothScrolling(boolean bl) {
        this.m_smooth = bl;
    }

    public int getNumRows() {
        return this.m_rows - this.m_numTitleRows;
    }

    public int getNumColumns() {
        return this.m_cols;
    }

    public Object getCellItem(int n, int n2) {
        return this.getCellString(n, n2);
    }

    public String getCellString(int n, int n2) {
        if ((n += this.m_numTitleRows) < 0 || n >= this.m_rows) {
            return null;
        }
        String[] stringArray = (String[])this.m_data.elementAt(n);
        if (stringArray == null || n2 >= stringArray.length) {
            return null;
        }
        return stringArray[n2];
    }

    public Object getRowObject(int n) {
        if ((n += this.m_numTitleRows) < 0 || n >= this.m_rows) {
            return null;
        }
        Object object = this.m_data.elementAt(n);
        return this.m_rowObjs.get(object);
    }

    public boolean isRowSelected(int n) {
        return this.rowSelected(n += this.m_numTitleRows);
    }

    public void selectRow(int n, boolean bl) {
        this.select(n + this.m_numTitleRows, bl);
        if (bl) {
            this.notifyListeners(new LEMLEvent(this, 3));
        }
    }

    public void selectRows(int[] nArray, boolean bl) {
        this.clearSelect(true);
        int n = 0;
        while (n < nArray.length) {
            int n2 = nArray[n] + this.m_numTitleRows;
            if (n2 >= this.m_numTitleRows && n2 < this.m_rows) {
                this.select(n2, bl);
            }
            ++n;
        }
        if (bl) {
            this.notifyListeners(new LEMLEvent(this, 3));
        }
    }

    public void unselectRow(int n, boolean bl) {
        this.unselect(n + this.m_numTitleRows, bl);
        if (bl) {
            this.notifyListeners(new LEMLEvent(this, 3));
        }
    }

    public void clearSelection(boolean bl) {
        this.clearSelect(bl);
        if (bl) {
            this.notifyListeners(new LEMLEvent(this, 3));
        }
    }

    public int getSelectSize() {
        return this.m_select.size();
    }

    public int[] getSelectedRows() {
        int[] nArray = this.getSelected();
        LEVector lEVector = new LEVector();
        int n = 0;
        while (n < nArray.length) {
            lEVector.addElement(new Integer(nArray[n] - this.m_numTitleRows));
            ++n;
        }
        lEVector.quickSort(new LENumCompare());
        int n2 = 0;
        while (n2 < nArray.length) {
            nArray[n2] = (Integer)lEVector.elementAt(n2);
            ++n2;
        }
        return nArray;
    }

    public void layoutGrid() {
        this.repaint();
    }

    public void recalc() {
        this.m_recalc = true;
        this.repaint();
    }

    public void redraw() {
        this.m_redraw = true;
        this.repaint();
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.m_redraw = true;
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        super.setBounds(n, n2, n3, n4);
        this.m_resize = true;
    }

    public void setSize(int n, int n2) {
        super.setSize(n, n2);
        this.m_resize = true;
    }

    public void setSize(Dimension dimension) {
        super.setSize(dimension);
        this.m_resize = true;
    }

    public Dimension getMinimumSize() {
        return this.m_area;
    }

    public Dimension getPreferredSize() {
        return this.m_area;
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public void paint(Graphics graphics) {
        Object object;
        if (this.m_resize) {
            if (this.m_buf != null) {
                this.m_buf.flush();
                this.m_buf = null;
            }
            object = this.getSize();
            if (((Dimension)object).width > 0 && ((Dimension)object).height > 0) {
                this.m_buf = this.createImage(((Dimension)object).width, ((Dimension)object).height);
                this.m_adjust = true;
                this.m_redraw = true;
            }
            this.m_resize = false;
        }
        if (this.m_recalc) {
            this.calculateLayout(graphics);
            this.m_recalc = false;
            this.m_redraw = true;
        }
        if (this.m_adjust) {
            this.adjustWidth(this.getSize());
            this.m_adjust = false;
        }
        if (this.m_redraw && this.m_buf != null) {
            object = this.m_buf.getGraphics();
            this.draw((Graphics)object);
            ((Graphics)object).dispose();
            this.m_redraw = false;
        }
        if (this.m_buf != null) {
            graphics.drawImage(this.m_buf, 0, 0, null);
            if (this.m_dragX > -1) {
                graphics.setColor(this.getForeground());
                graphics.drawLine(this.m_dragX, 0, this.m_dragX, this.getSize().height);
            }
        }
    }

    public void notifyListeners(LEMLEvent lEMLEvent) {
        int n = this.m_listeners.size();
        int n2 = n - 1;
        while (n2 > -1) {
            LEMLListener lEMLListener = (LEMLListener)this.m_listeners.elementAt(n2);
            lEMLListener.onLEMLEvent(lEMLEvent);
            --n2;
        }
    }

    public void sort(int n) {
        if (n < 0 || n >= this.m_cols || !this.m_sortable[n]) {
            return;
        }
        this.notifyListeners(new LEMLEvent(this, 4));
        if (n == this.m_sortCol) {
            this.m_rev = !this.m_rev;
        } else {
            this.m_lastCol = this.m_sortCol;
            this.m_sortCol = n;
        }
        this.sortData();
        this.notifyListeners(new LEMLEvent(this, 5));
        this.redraw();
    }

    public int compare(Object object, Object object2) {
        String[] stringArray = (String[])object;
        String[] stringArray2 = (String[])object2;
        String string = stringArray[this.m_currCol];
        String string2 = stringArray2[this.m_currCol];
        if (string == null && string2 == null) {
            return 0;
        }
        if (string == null) {
            return -1;
        }
        if (string2 == null) {
            return 1;
        }
        if (this.m_sortObj[this.m_currCol] != null) {
            return this.m_sortObj[this.m_currCol].compare(string, string2);
        }
        return this.m_comp.compare(string, string2);
    }

    public void setScrollPanel(LEScrollPanel lEScrollPanel) {
        this.m_panel = lEScrollPanel;
    }

    public void setOrigin(int n, int n2) {
        this.m_x = n;
        this.m_y = n2;
    }

    public void scrollTo(int n, int n2) {
        this.m_x = n;
        this.m_y = n2;
        if (this.m_smooth) {
            this.redraw();
        }
    }

    public void startScroll() {
    }

    public void endScroll() {
        if (!this.m_smooth) {
            this.redraw();
        }
    }

    public Dimension totalArea() {
        return this.m_area;
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (!this.isEnabled()) {
            return;
        }
        Point point = mouseEvent.getPoint();
        if (point.y <= this.m_titles.height) {
            if (point.x > this.m_titles.width && this.checkForResize(point)) {
                this.m_dragX = point.x;
                this.repaint();
                this.addMouseMotionListener(this);
                return;
            }
            int n = this.getColumnAt(point);
            if (n > -1) {
                this.sort(n);
                return;
            }
        } else {
            int n = this.getRowAt(point);
            if (n < this.m_numTitleRows) {
                return;
            }
            if (mouseEvent.getClickCount() % 2 == 0) {
                this.notifyListeners(new LEMLEvent(this, 6, n - this.m_numTitleRows));
                return;
            }
            if (this.m_multiSelect && mouseEvent.isShiftDown()) {
                if (this.m_select.size() > 0) {
                    int n2;
                    int[] nArray = this.getSelected();
                    int n3 = Math.min(n, nArray[0]);
                    if (n3 < (n2 = Math.max(n, nArray[0]))) {
                        int n4 = 1;
                        while (n4 < nArray.length) {
                            if (nArray[n4] < n3 || nArray[n4] > n2) {
                                this.unselect(nArray[n4], true);
                            }
                            ++n4;
                        }
                        int n5 = n3;
                        while (n5 <= n2) {
                            if (!this.rowSelected(n5)) {
                                this.select(n5, true);
                            }
                            ++n5;
                        }
                    }
                } else {
                    this.select(n, true);
                }
            } else if (mouseEvent.isControlDown()) {
                if (this.rowSelected(n)) {
                    this.unselect(n, true);
                } else {
                    this.select(n, true);
                }
            } else {
                this.clearSelect(true);
                this.select(n, true);
            }
            this.notifyListeners(new LEMLEvent(this, 3));
            this.repaint();
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (this.m_dragX > -1) {
            this.removeMouseMotionListener(this);
            this.m_fixed[this.m_dragCol] = Math.max(1, this.m_dragX - this.m_minDragX);
            this.m_dragX = -1;
            this.recalc();
        }
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        this.m_dragX = Math.max(mouseEvent.getX(), this.m_minDragX);
        this.repaint();
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }

    synchronized void draw(Graphics graphics) {
        graphics.setColor(this.m_dataBack);
        Dimension dimension = this.getSize();
        graphics.fillRect(0, 0, dimension.width, dimension.height);
        this.drawData(graphics, this.m_x, this.m_y, dimension);
        if (this.m_grid) {
            this.drawGrid(graphics, this.m_x, this.m_y, dimension);
        }
        this.drawRowTitles(graphics, this.m_x, this.m_y, dimension);
        this.drawColumnTitles(graphics, this.m_x, this.m_y, dimension);
        this.drawCorner(graphics);
    }

    void drawCorner(Graphics graphics) {
        graphics.setColor(this.getBackground());
        graphics.fill3DRect(0, 0, this.m_titles.width - this.m_cellOB, this.m_titles.height - this.m_cellOB, true);
        graphics.fillRect(this.m_titles.width - this.m_cellOB, 0, this.m_cellOB, this.m_titles.height - this.m_cellOB);
        graphics.fillRect(0, this.m_titles.height - this.m_cellOB, this.m_titles.width - this.m_cellOB, this.m_cellOB);
        Color color = this.isEnabled() ? this.getForeground() : this.getBackground().darker();
        graphics.setColor(color);
        graphics.setFont(this.m_bold);
        FontMetrics fontMetrics = graphics.getFontMetrics();
        LEListDrawInfo lEListDrawInfo = new LEListDrawInfo();
        lEListDrawInfo.m_h = this.m_height - 2 * this.m_cellVB;
        lEListDrawInfo.m_fh = fontMetrics.getHeight();
        lEListDrawInfo.m_fa = fontMetrics.getAscent();
        lEListDrawInfo.m_fd = fontMetrics.getDescent();
        lEListDrawInfo.m_fm = fontMetrics;
        int n = 0;
        int n2 = 0;
        while (n2 < this.m_numTitleRows) {
            int n3 = 0;
            String[] stringArray = (String[])this.m_data.elementAt(n2);
            if (stringArray != null) {
                int n4 = 0;
                while (n4 < this.m_numTitleCols) {
                    if (stringArray[n4] != null) {
                        lEListDrawInfo.m_x = n3 + this.m_cellHB;
                        lEListDrawInfo.m_y = n + this.m_cellVB;
                        lEListDrawInfo.m_w = this.m_widths[n4] - 2 * this.m_cellHB;
                        this.drawString(stringArray[n4], graphics, this.m_titleJusts[n4], lEListDrawInfo);
                    }
                    n3 += this.m_widths[n4] + this.m_cellOB;
                    ++n4;
                }
            }
            n += this.m_height + this.m_cellOB;
            ++n2;
        }
    }

    void drawRowTitles(Graphics graphics, int n, int n2, Dimension dimension) {
        Rectangle rectangle = new Rectangle(0, this.m_titles.height, this.m_titles.width, dimension.height);
        Rectangle rectangle2 = new Rectangle(0, 0, 0, 0);
        Color color = this.getBackground();
        Color color2 = this.isEnabled() ? this.getForeground() : this.getBackground().darker();
        graphics.setFont(this.m_bold);
        FontMetrics fontMetrics = graphics.getFontMetrics();
        LEListDrawInfo lEListDrawInfo = new LEListDrawInfo();
        lEListDrawInfo.m_h = this.m_height - 2 * this.m_cellVB;
        lEListDrawInfo.m_fh = fontMetrics.getHeight();
        lEListDrawInfo.m_fa = fontMetrics.getAscent();
        lEListDrawInfo.m_fd = fontMetrics.getDescent();
        lEListDrawInfo.m_fm = fontMetrics;
        int n3 = n2 + this.m_titles.height;
        int n4 = this.m_numTitleRows;
        while (n4 < this.m_rows) {
            int n5 = 0;
            String[] stringArray = (String[])this.m_data.elementAt(n4);
            rectangle2.setBounds(0, n3, this.m_titles.width, this.m_height);
            if (rectangle2.intersects(rectangle)) {
                graphics.setColor(color);
                graphics.fillRect(0, n3, this.m_titles.width - this.m_cellOB, this.m_height);
                graphics.draw3DRect(0, n3, this.m_titles.width - 1 - this.m_cellOB, this.m_height - 1, true);
                graphics.setColor(color2);
                int n6 = 0;
                while (n6 < this.m_numTitleCols) {
                    if (stringArray[n6] != null) {
                        lEListDrawInfo.m_x = n5 + this.m_cellHB;
                        lEListDrawInfo.m_y = n3 + this.m_cellVB;
                        lEListDrawInfo.m_w = this.m_widths[n6] - 2 * this.m_cellHB;
                        this.drawString(stringArray[n6], graphics, this.m_titleJusts[n6], lEListDrawInfo);
                    }
                    n5 += this.m_widths[n6] + this.m_cellOB;
                    ++n6;
                }
            }
            n3 += this.m_height + this.m_cellOB;
            ++n4;
        }
    }

    void drawColumnTitles(Graphics graphics, int n, int n2, Dimension dimension) {
        Rectangle rectangle = new Rectangle(this.m_titles.width, 0, dimension.width, this.m_titles.height);
        Rectangle rectangle2 = new Rectangle(0, 0, 0, 0);
        Color color = this.getBackground();
        Color color2 = this.isEnabled() ? this.getForeground() : this.getBackground().darker();
        graphics.setColor(color);
        graphics.setFont(this.m_bold);
        FontMetrics fontMetrics = graphics.getFontMetrics();
        LEListDrawInfo lEListDrawInfo = new LEListDrawInfo();
        lEListDrawInfo.m_h = this.m_height - 2 * this.m_cellVB;
        lEListDrawInfo.m_fh = fontMetrics.getHeight();
        lEListDrawInfo.m_fa = fontMetrics.getAscent();
        lEListDrawInfo.m_fd = fontMetrics.getDescent();
        lEListDrawInfo.m_fm = fontMetrics;
        int n3 = n + this.m_titles.width;
        int n4 = this.m_numTitleCols;
        while (n4 < this.m_cols) {
            int n5 = 0;
            rectangle2.setBounds(n3, 0, this.m_widths[n4], this.m_titles.height);
            if (rectangle2.intersects(rectangle)) {
                if (n4 > this.m_numTitleCols) {
                    graphics.fillRect(n3 - this.m_cellOB, 0, this.m_cellOB, this.m_titles.height - this.m_cellOB);
                }
                graphics.fillRect(n3, 0, this.m_widths[n4], this.m_titles.height - this.m_cellOB);
                graphics.setColor(color2);
                lEListDrawInfo.m_w = this.m_widths[n4] - 2 * this.m_cellHB;
                int n6 = 0;
                while (n6 < this.m_numTitleRows) {
                    String[] stringArray = (String[])this.m_data.elementAt(n6);
                    if (stringArray != null && stringArray[n4] != null) {
                        lEListDrawInfo.m_x = n3 + this.m_cellHB;
                        lEListDrawInfo.m_y = n5 + this.m_cellVB;
                        this.drawString(stringArray[n4], graphics, this.m_titleJusts[n4], lEListDrawInfo);
                    }
                    n5 += this.m_height + this.m_cellOB;
                    ++n6;
                }
                graphics.setColor(color);
                graphics.draw3DRect(n3, 0, this.m_widths[n4] - 1, this.m_titles.height - 1 - this.m_cellOB, true);
            }
            n3 += this.m_widths[n4] + this.m_cellOB;
            ++n4;
        }
    }

    void drawData(Graphics graphics, int n, int n2, Dimension dimension) {
        Rectangle rectangle = new Rectangle(this.m_titles.width, this.m_titles.height, dimension.width, dimension.height);
        Rectangle rectangle2 = new Rectangle(0, 0, 0, 0);
        Color color = this.isEnabled() ? this.getForeground() : this.getBackground().darker();
        Color color2 = this.isEnabled() ? this.m_selectFore : this.m_selectFore.darker();
        int n3 = this.m_height + this.m_cellOB;
        int n4 = this.m_numTitleRows - n2 / n3;
        int n5 = Math.min(this.m_rows, n4 + (dimension.height - this.m_titles.height) / n3 + 1);
        graphics.setFont(this.m_font);
        FontMetrics fontMetrics = graphics.getFontMetrics();
        LEListDrawInfo lEListDrawInfo = new LEListDrawInfo();
        lEListDrawInfo.m_h = this.m_height - 2 * this.m_cellVB;
        lEListDrawInfo.m_fh = fontMetrics.getHeight();
        lEListDrawInfo.m_fa = fontMetrics.getAscent();
        lEListDrawInfo.m_fd = fontMetrics.getDescent();
        lEListDrawInfo.m_fm = fontMetrics;
        int n6 = n2 + this.m_titles.height + (n4 - this.m_numTitleRows) * n3;
        int n7 = n4;
        while (n7 < n5) {
            Color color3;
            Color color4;
            int n8 = n + this.m_titles.width;
            String[] stringArray = (String[])this.m_data.elementAt(n7);
            if (this.m_select.contains(stringArray)) {
                color4 = this.m_selectBack;
                color3 = color2;
            } else {
                color4 = this.m_dataBack;
                color3 = color;
            }
            graphics.setColor(color4);
            int n9 = this.m_numTitleCols;
            while (n9 < this.m_cols) {
                rectangle2.setBounds(n8, n6, this.m_widths[n9], this.m_height);
                if (rectangle2.intersects(rectangle)) {
                    graphics.fillRect(n8, n6, this.m_widths[n9], this.m_height);
                    if (stringArray != null && stringArray[n9] != null) {
                        graphics.setColor(color3);
                        lEListDrawInfo.m_x = n8 + this.m_cellHB;
                        lEListDrawInfo.m_y = n6 + this.m_cellVB;
                        lEListDrawInfo.m_w = this.m_widths[n9] - 2 * this.m_cellHB;
                        this.drawString(stringArray[n9], graphics, this.m_justs[n9], lEListDrawInfo);
                        graphics.setColor(color4);
                    }
                    graphics.fillRect(n8 + this.m_widths[n9], n6, this.m_cellOB, this.m_height);
                }
                n8 += this.m_widths[n9] + this.m_cellOB;
                ++n9;
            }
            n6 += n3;
            ++n7;
        }
    }

    void drawGrid(Graphics graphics, int n, int n2, Dimension dimension) {
        graphics.setColor(this.getBackground());
        int n3 = n2 + this.m_titles.height - this.m_cellOB;
        int n4 = this.m_numTitleRows;
        while (n4 < this.m_rows) {
            if ((n3 += this.m_height + this.m_cellOB) > 0 && n3 < dimension.height) {
                graphics.drawLine(0, n3, dimension.width, n3);
            }
            ++n4;
        }
        int n5 = n + this.m_titles.width - this.m_cellOB;
        int n6 = Math.min(dimension.height, this.m_area.height) - this.m_titles.height;
        int n7 = this.m_titles.height + n6;
        int n8 = this.m_numTitleCols;
        while (n8 < this.m_cols) {
            if ((n5 += this.m_widths[n8] + this.m_cellOB) > 0 && n5 < dimension.width) {
                graphics.drawLine(n5, this.m_titles.height, n5, n7);
            }
            ++n8;
        }
    }

    void drawString(String string, Graphics graphics, int n, LEListDrawInfo lEListDrawInfo) {
        if (string == null) {
            return;
        }
        int n2 = lEListDrawInfo.m_x;
        int n3 = lEListDrawInfo.m_y + lEListDrawInfo.m_h - (lEListDrawInfo.m_h - lEListDrawInfo.m_fh) / 2 - lEListDrawInfo.m_fd;
        switch (n) {
            case 1: {
                n2 = Math.max(lEListDrawInfo.m_x, lEListDrawInfo.m_x + (lEListDrawInfo.m_w - lEListDrawInfo.m_fm.stringWidth(string)) / 2);
                break;
            }
            case 2: {
                n2 = Math.max(lEListDrawInfo.m_x, lEListDrawInfo.m_x + lEListDrawInfo.m_w - lEListDrawInfo.m_fm.stringWidth(string));
                break;
            }
        }
        graphics.drawString(string, n2, n3);
    }

    synchronized void calculateLayout(Graphics graphics) {
        int n;
        if (this.m_sortCol != -1) {
            this.sortData();
        }
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 2 * this.m_cellHB;
        FontMetrics fontMetrics = graphics.getFontMetrics(this.m_font);
        FontMetrics fontMetrics2 = graphics.getFontMetrics(this.m_bold);
        this.m_height = fontMetrics2.getHeight() + 2 * this.m_cellVB;
        int n7 = 0;
        while (n7 < this.m_rows) {
            String[] stringArray = (String[])this.m_data.elementAt(n7);
            if (stringArray != null) {
                int n8 = Math.min(stringArray.length, this.m_cols);
                n = 0;
                while (n < n8) {
                    if (this.m_fixed[n] == 0 && stringArray[n] != null) {
                        int n9 = n < this.m_numTitleCols || n7 < this.m_numTitleRows ? fontMetrics2.stringWidth(stringArray[n]) + n6 : fontMetrics.stringWidth(stringArray[n]) + n6;
                        this.m_minWidths[n] = Math.max(this.m_minWidths[n], n9);
                    }
                    ++n;
                }
            }
            ++n7;
        }
        n = 0;
        while (n < this.m_cols) {
            if (this.m_fixed[n] > 0) {
                this.m_minWidths[n] = this.m_fixed[n];
            }
            ++n;
        }
        n2 = this.m_numTitleRows * (this.m_height + this.m_cellOB);
        if (this.m_rows > 0) {
            n4 = this.m_rows * this.m_height + (this.m_rows - 1) * this.m_cellOB;
        }
        n = 0;
        while (n < this.m_numTitleCols) {
            n3 += this.m_minWidths[n];
            ++n;
        }
        if (this.m_numTitleCols > 0) {
            n3 += this.m_numTitleCols * this.m_cellOB;
        }
        n5 += n3;
        n = this.m_numTitleCols;
        while (n < this.m_cols) {
            n5 += this.m_minWidths[n];
            ++n;
        }
        int n10 = this.m_cols - this.m_numTitleCols;
        if (n10 > 1) {
            n5 += (n10 - 1) * this.m_cellOB;
        }
        if (this.m_minDisplayRows > 0) {
            int n11 = this.m_minDisplayRows * this.m_height + (this.m_minDisplayRows - 1) * this.m_cellOB;
            n4 = Math.max(n4, n11);
        }
        this.m_area.setSize(n5, n4);
        this.m_titles.setSize(n3, n2);
        this.m_adjust = true;
        if (this.m_panel != null) {
            this.m_panel.updateScrollbars(this.m_area.width, this.m_area.height);
        }
    }

    void adjustWidth(Dimension dimension) {
        System.arraycopy(this.m_minWidths, 0, this.m_widths, 0, this.m_cols);
        int n = dimension.width - this.m_area.width;
        if (n > 0) {
            int n2 = 0;
            int n3 = this.m_numTitleCols;
            while (n3 < this.m_cols) {
                if (this.m_fixed[n3] == 0) {
                    ++n2;
                }
                ++n3;
            }
            if (n2 > 0) {
                int n4 = n / n2;
                int n5 = n - n4 * n2;
                int n6 = this.m_numTitleCols;
                while (n6 < this.m_cols) {
                    if (this.m_fixed[n6] == 0) {
                        int n7 = n6;
                        this.m_widths[n7] = this.m_widths[n7] + n4;
                        if (--n2 == 0) {
                            int n8 = n6;
                            this.m_widths[n8] = this.m_widths[n8] + n5;
                        }
                    }
                    ++n6;
                }
            }
        }
    }

    boolean checkForResize(Point point) {
        Rectangle rectangle = new Rectangle();
        int n = this.m_cols - 1;
        int n2 = this.m_x + this.m_titles.width;
        int n3 = this.m_cellOB + 2;
        int n4 = this.m_numTitleCols;
        while (n4 < n) {
            rectangle.setBounds(n2 += this.m_widths[n4], 0, n3, this.m_titles.height);
            if (rectangle.contains(point)) {
                this.m_minDragX = Math.max(n2 - this.m_widths[n4], this.m_titles.width);
                this.m_dragCol = n4;
                return true;
            }
            n2 += this.m_cellOB;
            ++n4;
        }
        return false;
    }

    int getColumnAt(Point point) {
        int n = point.x;
        if (n > this.m_titles.width) {
            n -= this.m_x;
        }
        int n2 = 0;
        int n3 = 0;
        while (n3 < this.m_cols) {
            if (n < (n2 += this.m_widths[n3])) {
                return n3;
            }
            ++n3;
        }
        return -1;
    }

    int getRowAt(Point point) {
        int n = (point.y - this.m_y) / (this.m_height + this.m_cellOB);
        if (n >= this.m_rows) {
            n = -1;
        }
        return n;
    }

    boolean rowSelected(int n) {
        if (n < 0 || n >= this.m_rows) {
            return false;
        }
        Object object = this.m_data.elementAt(n);
        return this.m_select.contains(object);
    }

    void select(int n, boolean bl) {
        if (n < 0 || n >= this.m_rows) {
            return;
        }
        Object object = this.m_data.elementAt(n);
        if (!this.m_select.contains(object)) {
            this.m_select.addElement(object);
            this.m_redraw = true;
            if (bl) {
                this.notifyListeners(new LEMLEvent(this, 1, n - this.m_numTitleRows));
            }
        }
    }

    void unselect(int n, boolean bl) {
        if (n < 0 || n >= this.m_rows) {
            return;
        }
        Object object = this.m_data.elementAt(n);
        if (this.m_select.contains(object)) {
            this.m_select.removeElement(object);
            this.m_redraw = true;
            if (bl) {
                this.notifyListeners(new LEMLEvent(this, 2, n - this.m_numTitleRows));
            }
        }
    }

    void clearSelect(boolean bl) {
        if (this.m_select.size() > 0) {
            int[] nArray = this.getSelected();
            int n = 0;
            while (n < nArray.length) {
                this.unselect(nArray[n], bl);
                ++n;
            }
        }
    }

    int[] getSelected() {
        int n = this.m_select.size();
        int[] nArray = new int[n];
        int n2 = 0;
        while (n2 < n) {
            nArray[n2] = this.getRowFor(this.m_select.elementAt(n2));
            ++n2;
        }
        return nArray;
    }

    int getRowFor(Object object) {
        int n = 0;
        while (n < this.m_rows) {
            if (object == this.m_data.elementAt(n)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    boolean delete(int n) {
        boolean bl = false;
        if (n < 0 || n >= this.m_rows) {
            return false;
        }
        if (this.rowSelected(n)) {
            bl = true;
            this.unselect(n, true);
        }
        String[] stringArray = (String[])this.m_data.removeElementAt(n);
        this.m_rowObjs.remove(stringArray);
        --this.m_rows;
        this.m_recalc = true;
        return bl;
    }

    void sortData() {
        int n = this.m_rows - this.m_numTitleRows;
        if (n == 0) {
            return;
        }
        this.m_currCol = this.m_sortCol;
        this.m_data.quickSort(this, this.m_numTitleRows, this.m_data.size() - 1, this.m_rev);
        if (this.m_lastCol == -1) {
            return;
        }
        this.m_currCol = this.m_lastCol;
        String string = this.getCellString(0, this.m_sortCol);
        int n2 = 0;
        int n3 = 0;
        n3 = 1;
        while (n3 < n) {
            String string2 = this.getCellString(n3, this.m_sortCol);
            if (string != null && string2 != null && !string2.equals(string)) {
                if (n3 - n2 > 2) {
                    this.m_data.quickSort(this, n2 + this.m_numTitleRows, n3 - 1 + this.m_numTitleRows, this.m_rev);
                }
                n2 = n3;
            }
            string = string2;
            ++n3;
        }
        if (n3 - n2 > 2) {
            this.m_data.quickSort(this, n2 + this.m_numTitleRows, n3 - 1 + this.m_numTitleRows, this.m_rev);
        }
    }
}

