/*
 * Decompiled with CFR 0.152.
 */
package com.lucent.ra.nms.ui;

import com.lucent.ra.nms.ui.LETreeGraphicsInfo;
import com.lucent.ra.nms.ui.LETreeItem;
import java.awt.Color;
import java.awt.Image;

public abstract class LETreeLAF {
    public static final int T_CONNECT = 1;
    public static final int L_CONNECT = 2;
    LETreeGraphicsInfo m_info;
    int m_border;
    Color m_fore;
    Color m_back;

    public LETreeLAF(LETreeGraphicsInfo lETreeGraphicsInfo) {
        this.m_info = lETreeGraphicsInfo;
    }

    public int getBorder() {
        return this.m_border;
    }

    public void setEnabled(boolean bl) {
    }

    public void drawItem(LETreeItem lETreeItem) {
        int n = lETreeItem.m_column * this.m_info.m_colOffset + this.m_info.m_maxBorder - this.m_border;
        int n2 = lETreeItem.m_row * (this.m_info.m_rowHeight + this.m_info.m_rowOffset) + this.m_info.m_maxBorder - this.m_border;
        int n3 = 2 * this.m_info.m_cellInset + 2 * this.m_border + this.m_info.m_maxImageWidth + this.m_info.m_imageBuffer + this.m_info.m_fm.stringWidth(lETreeItem.m_label);
        int n4 = this.m_info.m_rowHeight + 2 * this.m_border;
        this.m_info.m_gc.setColor(this.m_back);
        this.drawItemBackground(lETreeItem, n, n2, n3, n4);
        this.m_info.m_gc.setColor(this.m_fore);
        this.drawItemForeground(lETreeItem, n += this.m_border, n2 += this.m_border, n3 -= 2 * this.m_border, n4 -= 2 * this.m_border);
    }

    public void drawConnection(int n, int n2, LETreeItem lETreeItem) {
        int n3 = (lETreeItem.m_column - 1) * this.m_info.m_colOffset + this.m_info.m_maxBorder;
        int n4 = n2 * (this.m_info.m_rowHeight + this.m_info.m_rowOffset) + this.m_info.m_maxBorder + this.m_info.m_rowHeight;
        int n5 = this.m_info.m_colOffset;
        int n6 = lETreeItem.m_row * (this.m_info.m_rowHeight + this.m_info.m_rowOffset) + this.m_info.m_rowHeight + this.m_info.m_maxBorder - n4;
        switch (n) {
            case 1: {
                this.drawTConnection(lETreeItem, n3, n4, n5, n6);
                return;
            }
            case 2: {
                this.drawLConnection(lETreeItem, n3, n4, n5, n6);
                return;
            }
        }
    }

    void drawItemBackground(LETreeItem lETreeItem, int n, int n2, int n3, int n4) {
    }

    void drawItemForeground(LETreeItem lETreeItem, int n, int n2, int n3, int n4) {
        Image image;
        Image image2 = image = lETreeItem.m_collapsed ? lETreeItem.m_colImage : lETreeItem.m_expImage;
        if (image == null && lETreeItem.m_children != null) {
            image = lETreeItem.m_collapsed ? this.m_info.m_colImage : this.m_info.m_expImage;
        }
        n += this.m_info.m_cellInset;
        if (image != null) {
            int n5 = image.getHeight(this.m_info.m_observer);
            n5 = Math.min(n5, this.m_info.m_maxImageHeight);
            int n6 = n2 + (this.m_info.m_rowHeight - n5) / 2;
            this.m_info.m_gc.drawImage(image, n, n6, this.m_info.m_observer);
        }
        this.m_info.m_gc.drawString(lETreeItem.m_label, n += this.m_info.m_maxImageWidth + this.m_info.m_imageBuffer, n2 + this.m_info.m_fontAdj);
    }

    abstract void drawTConnection(LETreeItem var1, int var2, int var3, int var4, int var5);

    abstract void drawLConnection(LETreeItem var1, int var2, int var3, int var4, int var5);
}

