/*
 * Decompiled with CFR 0.152.
 */
package com.lucent.ra.nms.util;

import com.acme.crypto.BlockCipher;
import com.acme.crypto.CbcBlockCipher;
import com.acme.crypto.DesCipher;
import com.lucent.ra.nms.util.LEDebug;
import java.io.InputStream;
import java.io.OutputStream;

public class LEStreamEncoder {
    public static final int BLOCK_SIZE = 8;
    String m_password;
    CbcBlockCipher m_cbc;
    OutputStream m_os;
    InputStream m_is;
    byte[] m_civ = new byte[8];
    byte[] m_src = new byte[8];
    byte[] m_dst = new byte[8];

    public LEStreamEncoder(String string) {
        this.m_password = string;
        this.fillCipherIV();
    }

    public void setPassword(String string) {
        this.m_password = string;
        this.fillCipherIV();
    }

    public void startEncrypt(OutputStream outputStream) {
        this.m_os = outputStream;
        this.m_cbc = new CbcBlockCipher((BlockCipher)new DesCipher(this.m_password));
        this.m_cbc.setIv(this.m_civ);
    }

    public void stopEncrypt() {
        this.m_os = null;
    }

    public void encryptLine(String string) {
        byte[] byArray = string.getBytes();
        int n = (byArray.length + 7) / 8;
        try {
            this.encodeHeader(byArray.length, this.m_src);
            this.m_cbc.encrypt(this.m_src, this.m_dst);
            this.m_os.write(this.m_dst, 0, this.m_dst.length);
            int n2 = 0;
            while (n2 < n) {
                int n3 = n2 * 8;
                int n4 = Math.min(byArray.length - n3, 8);
                System.arraycopy(byArray, n3, this.m_src, 0, n4);
                int n5 = n4;
                while (n5 < 8) {
                    this.m_src[n5] = 0;
                    ++n5;
                }
                this.m_cbc.encrypt(this.m_src, this.m_dst);
                this.m_os.write(this.m_dst, 0, this.m_dst.length);
                ++n2;
            }
            return;
        }
        catch (Exception exception) {
            LEDebug.getLog().logln(20, exception);
            return;
        }
    }

    public void startDecrypt(InputStream inputStream) {
        this.m_is = inputStream;
        this.m_cbc = new CbcBlockCipher((BlockCipher)new DesCipher(this.m_password));
        this.m_cbc.setIv(this.m_civ);
    }

    public void stopDecrypt() {
        this.m_is = null;
    }

    public String decryptLine() {
        byte[] byArray = null;
        try {
            int n = this.m_is.read(this.m_src, 0, 8);
            if (n < 8) {
                return null;
            }
            this.m_cbc.decrypt(this.m_src, this.m_dst);
            int n2 = this.decodeHeader(this.m_dst);
            byArray = new byte[n2];
            int n3 = (n2 + 7) / 8;
            int n4 = 0;
            while (n4 < n3) {
                n = this.m_is.read(this.m_src, 0, 8);
                if (n == 8) {
                    this.m_cbc.decrypt(this.m_src, this.m_dst);
                    int n5 = n4 * 8;
                    int n6 = Math.min(n2 - n5, 8);
                    System.arraycopy(this.m_dst, 0, byArray, n5, n6);
                }
                ++n4;
            }
        }
        catch (Exception exception) {}
        if (byArray == null) {
            return null;
        }
        return new String(byArray);
    }

    void encodeHeader(int n, byte[] byArray) {
        int n2 = 0;
        while (n2 < byArray.length) {
            byArray[n2] = (byte)Math.min(n, 255);
            if (n > 255) {
                n -= 255;
            } else if (n > 0) {
                n = 0;
            }
            ++n2;
        }
    }

    int decodeHeader(byte[] byArray) {
        int n = 0;
        int n2 = 0;
        while (n2 < byArray.length) {
            n += byArray[n2];
            ++n2;
        }
        return n;
    }

    void fillCipherIV() {
        byte[] byArray = this.m_password.getBytes();
        int n = 0;
        while (n < byArray.length) {
            this.m_civ[n] = byArray[byArray.length - n - 1];
            ++n;
        }
        int n2 = byArray.length;
        while (n2 < 8) {
            this.m_civ[n2] = (byte)(8 - n2);
            ++n2;
        }
    }
}

