/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.lwAWT.lwText;

import java.awt.Adjustable;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.KeyEvent;
import java.awt.event.TextEvent;
import java.io.IOException;
import oracle.ewt.lwAWT.lwText.LWTextComponent;
import oracle.ewt.lwAWT.lwText.TextPosition;
import oracle.ewt.scrolling.ScrollableException;
import oracle.ewt.util.stringFilter.IdentityStringFilter;
import oracle.ewt.util.stringFilter.StringFilter;

public abstract class LWCommonText
extends LWTextComponent {
    public static final int ALIGNMENT_LEFT = 0;
    public static final int ALIGNMENT_RIGHT = 1;
    public static final int ALIGNMENT_CENTER = 2;
    private static final int _DEFAULT_COLUMNS = 20;
    private byte _alignment = 0;
    private StringFilter _valueFilter = IdentityStringFilter.getStringFilter();
    private int _maximumChars = Integer.MAX_VALUE;
    private int _columns;
    private Adjustable _hAdjustable;

    protected LWCommonText() {
        this(20);
    }

    protected LWCommonText(int n) {
        this._init(n);
    }

    public void setAlignment(int n) {
        if (this._alignment != n) {
            if (n != 0 && n != 1 && n != 2) {
                throw new IllegalArgumentException("improper alignment: " + n);
            }
            this._alignment = (byte)n;
            this.repaint();
        }
    }

    public int getAlignment() {
        return this._alignment;
    }

    public void setColumns(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("columns less than zero.");
        }
        if (this._columns != n) {
            this._columns = n;
            this.invalidate();
        }
    }

    public int getColumns() {
        return this._columns;
    }

    public void setMaximumChars(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("maximumChars must be >= 0");
        }
        if (this._maximumChars != n) {
            this._maximumChars = n;
            if (n < this.getTextLength()) {
                this.setText(this.getText().substring(0, n));
            }
        }
    }

    public int getMaximumChars() {
        return this._maximumChars;
    }

    public void setValueStringFilter(StringFilter stringFilter) {
        if (stringFilter == null) {
            stringFilter = IdentityStringFilter.getStringFilter();
        }
        if (this._valueFilter != stringFilter) {
            this._valueFilter = stringFilter;
            this.setText(this.getText());
        }
    }

    public StringFilter getValueStringFilter() {
        return this._valueFilter;
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public boolean isHScrollable() {
        return true;
    }

    public Adjustable getHAdjustable() {
        return this._hAdjustable;
    }

    public void attachHAdjustable(Adjustable adjustable) throws ScrollableException {
        if (!this.isHScrollable() || this._hAdjustable != null) {
            throw new ScrollableException();
        }
        this._hAdjustable = adjustable;
    }

    public void detachAdjustable(Adjustable adjustable) throws ScrollableException {
        if (adjustable == this._hAdjustable) {
            this._hAdjustable = null;
            return;
        }
        super.detachAdjustable(adjustable);
    }

    public boolean isOKToPaste(Transferable transferable) {
        if (super.isOKToPaste(transferable)) {
            try {
                String string = LWTextComponent.getPasteString(transferable);
                return this.getTextLength() + string.length() + this.getSelectionStart() - this.getSelectionEnd() <= this.getMaximumChars();
            }
            catch (UnsupportedFlavorException unsupportedFlavorException) {
            }
            catch (IOException iOException) {
            }
        }
        return false;
    }

    protected void processKeyEvent(KeyEvent keyEvent) {
        super.processKeyEvent(keyEvent);
        if (!keyEvent.isConsumed()) {
            int n = keyEvent.getID();
            if (n == 401) {
                int n2 = keyEvent.getKeyCode();
                switch (n2) {
                    case 35: 
                    case 36: {
                        int n3 = n2 == 36 ? 0 : this.getTextLength();
                        this._moveCursorAbsolute(this.getPosition(n3), keyEvent.isShiftDown());
                        break;
                    }
                    case 37: {
                        this._moveCursorXRelative(-1, keyEvent.isShiftDown());
                        break;
                    }
                    case 39: {
                        this._moveCursorXRelative(1, keyEvent.isShiftDown());
                        break;
                    }
                    case 8: 
                    case 127: {
                        boolean bl = this.deleteText(n2 == 8);
                        if (!bl) {
                            return;
                        }
                        this.processEvent(new TextEvent(this, 900));
                        break;
                    }
                    default: {
                        return;
                    }
                }
                keyEvent.consume();
                return;
            }
            if (n == 400) {
                char c = keyEvent.getKeyChar();
                if ((c = this.translateKeyChar(c)) != '\u0000') {
                    int n4 = this.getSelectionStart();
                    int n5 = this.getSelectionEnd();
                    if (c != '\u0000' && this.isEditable() && this.getMaximumChars() >= this.getTextLength() + 1 + (n4 - n5)) {
                        Rectangle rectangle = this.replaceRangeDamage(String.valueOf(c), n4, n5, true);
                        if (rectangle != null) {
                            this.paintText(rectangle, true);
                        }
                        this.deliverTextChangedIfNecessary(rectangle);
                        keyEvent.consume();
                        return;
                    }
                    Toolkit.getDefaultToolkit().beep();
                    return;
                }
            }
        }
    }

    protected String paramString() {
        int n;
        int n2;
        String string = super.paramString();
        string = String.valueOf(string) + ", " + this.getColumns() + " columns";
        StringFilter stringFilter = this.getValueStringFilter();
        if (stringFilter != this && stringFilter != IdentityStringFilter.getStringFilter()) {
            string = String.valueOf(string) + ", " + stringFilter.toString();
        }
        if ((n2 = this.getMaximumChars()) != Integer.MAX_VALUE) {
            string = String.valueOf(string) + ", " + n2 + " characters max";
        }
        if ((n = this.getAlignment()) != 0) {
            String string2 = n == 1 ? "right" : "center";
            string = String.valueOf(string) + string2 + " aligned";
        }
        return string;
    }

    static int findWordStart(char[] cArray, int n) {
        int n2 = cArray.length;
        if (n <= 0 || n2 == 0) {
            return 0;
        }
        if (n > n2) {
            n = n2;
        }
        --n;
        while (n >= 0 && Character.isLetterOrDigit(cArray[n])) {
            --n;
        }
        return n + 1;
    }

    /*
     * Unable to fully structure code
     */
    static int findWordEnd(char[] var0, int var1_1) {
        if (var1_1 < 0) {
            return 0;
        }
        var2_2 = var0.length;
        if (var1_1 < var2_2) ** GOTO lbl7
        return var2_2;
lbl-1000:
        // 1 sources

        {
            ++var1_1;
lbl7:
            // 2 sources

            ** while (var1_1 < var2_2 && Character.isLetterOrDigit((char)var0[var1_1]))
        }
lbl8:
        // 1 sources

        return var1_1;
    }

    char translateKeyChar(char c) {
        switch (c) {
            case '\b': 
            case '\u007f': {
                if (this.isEditable()) {
                    return '\u0000';
                }
                return c;
            }
            case '\u0003': 
            case '\u0016': 
            case '\u0018': {
                return '\u0000';
            }
        }
        if (c != '\n' && Character.isISOControl(c)) {
            return '\u0000';
        }
        return c;
    }

    synchronized void growSelection(TextPosition textPosition) {
        TextPosition textPosition2 = this.isSelectionAnchoredAtStart() ? this.getSelectionStartPos() : this.getSelectionEndPos();
        TextPosition textPosition3 = textPosition;
        TextPosition textPosition4 = textPosition2;
        if (textPosition4.getIndex() > textPosition3.getIndex()) {
            textPosition3 = textPosition4;
            textPosition4 = textPosition;
        }
        this.select(textPosition4, textPosition3, textPosition);
        if (textPosition2 != textPosition4) {
            this.setSelectionAnchoredAtStart(false);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    boolean deleteText(boolean bl) {
        Rectangle rectangle = null;
        LWCommonText lWCommonText = this;
        synchronized (lWCommonText) {
            int n = this.getTextLength();
            if (n == 0) return false;
            if (!this.isEditable()) return false;
            int n2 = this.getSelectionStart();
            int n3 = this.getSelectionEnd();
            int n4 = n2;
            int n5 = n3;
            if (n2 == n3) {
                if (!bl || n2 == 0) {
                    if (bl) return false;
                    if (n3 == n) return false;
                }
                if (bl) {
                    --n4;
                } else {
                    ++n5;
                }
            }
            rectangle = this.replaceRangeDamage(null, n4, n5, false);
        }
        if (rectangle == null) return true;
        this.paintText(rectangle, true);
        return true;
    }

    String replaceRangeFilter(String string, int n, int n2) {
        string = this.getValueStringFilter().convertString(string);
        int n3 = this.getMaximumChars();
        int n4 = this.getTextLength();
        int n5 = n4 + string.length() - (n2 - n);
        if (n5 > n3) {
            string = string.substring(0, n3 - n4);
        }
        return string;
    }

    private void _init(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("columns must be >= 0");
        }
        this._columns = n;
        this.enableEvents(12L);
    }

    private void _moveCursorAbsolute(TextPosition textPosition, boolean bl) {
        if (bl) {
            this.growSelection(textPosition);
            return;
        }
        this.setCaretPosition(textPosition);
    }

    private void _moveCursorXRelative(int n, boolean bl) {
        int n2;
        TextPosition textPosition = this.isSelectionAnchoredAtStart() ? this.getSelectionEndPos() : this.getSelectionStartPos();
        int n3 = textPosition.getIndex() + n;
        if (n3 < 0) {
            n3 = 0;
        }
        if (n3 > (n2 = this.getTextLength())) {
            n3 = n2;
        }
        this._moveCursorAbsolute(this.getPosition(n3), bl);
    }
}

