/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.splitter;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import oracle.ewt.EwtComponent;
import oracle.ewt.graphics.separator.RaisedSeparatorPainter;
import oracle.ewt.graphics.separator.Separator;
import oracle.ewt.graphics.separator.SeparatorPainter;
import oracle.ewt.lwAWT.LWComponent;

public class Splitter
extends EwtComponent {
    public static final int SPLITTER_NOT_VISIBLE = -1;
    private static MouseCheck _sMouseCheck;
    private Visible _visible;
    private PropertyChangeSupport _propertySupport;
    private boolean _horizontal;
    private Separator _separator;
    private boolean _resizing;
    private int _splitterPosition;
    private int _feedback;
    private Dimension _c1MinSize;
    private Dimension _c2MinSize;
    private int _size;

    public Splitter() {
        this(true);
    }

    public Splitter(boolean bl) {
        this(null, null, bl);
    }

    public Splitter(Component component, Component component2, boolean bl) {
        this._horizontal = bl;
        super.setLayout(null);
        if (component != null) {
            this.add(component);
        }
        if (component2 != null) {
            this.add(component2);
        }
        this._splitterPosition = -1;
        this._resizing = false;
        long l = 49L;
        this.enableEvents(l);
    }

    public boolean isHorizontal() {
        return this._horizontal;
    }

    public void setHorizontal(boolean bl) {
        if (bl != this.isHorizontal()) {
            this._horizontal = bl;
            this._firePropertyChanged("horizontal", new Boolean(!bl), new Boolean(bl));
            this.setSplitterPosition(-1);
            this.invalidateCanvas();
        }
    }

    public Separator getSeparator() {
        if (this._separator == null) {
            SeparatorPainter separatorPainter = RaisedSeparatorPainter.getSeparatorPainter();
            this._separator = new Separator(separatorPainter, SystemColor.control, 6);
        }
        return this._separator;
    }

    public void setSeparator(Separator separator) {
        Separator separator2 = this.getSeparator();
        if (separator2 != separator) {
            this._separator = separator;
            this._firePropertyChanged("separator", separator2, this._separator);
            this.invalidateCanvas();
        }
    }

    public int getSplitterPosition() {
        return this._splitterPosition;
    }

    public void setSplitterPosition(int n) {
        int n2;
        int n3 = this.getSplitterPosition();
        if (n3 != (n2 = this._checkSplitterPosition(n))) {
            this._splitterPosition = n2;
            this._firePropertyChanged("splitterPosition", new Integer(n3), new Integer(this._splitterPosition));
            this.invalidateCanvas();
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this._propertySupport == null) {
            this._propertySupport = new PropertyChangeSupport(this);
        }
        this._propertySupport.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this._propertySupport != null) {
            this._propertySupport.removePropertyChangeListener(propertyChangeListener);
        }
    }

    public Dimension getPreferredSize() {
        Dimension dimension;
        Dimension dimension2 = new Dimension();
        Component component = this._getFirstComponent();
        Component component2 = this._getSecondComponent();
        if (component != null) {
            dimension = component.getPreferredSize();
            dimension2.width += dimension.width;
            dimension2.height += dimension.height;
        }
        if (component2 != null) {
            dimension = component2.getPreferredSize();
            dimension2.width += dimension.width;
            dimension2.height += dimension.height;
        }
        if (dimension2.width == 0 || dimension2.height == 0) {
            dimension2 = super.getPreferredSize();
        }
        if (this.isHorizontal()) {
            dimension2.width += this.getSeparator().getSize();
        } else {
            dimension2.height += this.getSeparator().getSize();
        }
        return this.convertInnerToOuterSize(dimension2.width, dimension2.height);
    }

    public Dimension getMinimumSize() {
        Dimension dimension;
        Dimension dimension2 = new Dimension();
        Component component = this._getFirstComponent();
        Component component2 = this._getSecondComponent();
        if (component != null) {
            dimension = component.getMinimumSize();
            dimension2.width += dimension.width;
            dimension2.height += dimension.height;
        }
        if (component2 != null) {
            dimension = component2.getMinimumSize();
            dimension2.width += dimension.width;
            dimension2.height += dimension.height;
        }
        if (dimension2.width == 0 || dimension2.height == 0) {
            dimension2 = super.getMinimumSize();
        }
        if (this.isHorizontal()) {
            dimension2.width += this.getSeparator().getSize();
        } else {
            dimension2.height += this.getSeparator().getSize();
        }
        return this.convertInnerToOuterSize(dimension2.width, dimension2.height);
    }

    public Dimension getMaximumSize() {
        Dimension dimension;
        Dimension dimension2 = new Dimension();
        Component component = this._getFirstComponent();
        Component component2 = this._getSecondComponent();
        if (component != null) {
            dimension = component.getMaximumSize();
            dimension2.width += dimension.width;
            dimension2.height += dimension.height;
        }
        if (component2 != null) {
            dimension = component2.getMaximumSize();
            dimension2.width += dimension.width;
            dimension2.height += dimension.height;
        }
        if (dimension2.width == 0 || dimension2.height == 0) {
            dimension2 = super.getMaximumSize();
        }
        if (this.isHorizontal()) {
            dimension2.width += this.getSeparator().getSize();
        } else {
            dimension2.height += this.getSeparator().getSize();
        }
        return this.convertInnerToOuterSize(dimension2.width, dimension2.height);
    }

    public void setLayout(LayoutManager layoutManager) {
    }

    public void remove(int n) {
        Component component = this.getComponent(n);
        component.removeComponentListener(this._visible);
        super.remove(n);
        this.setSplitterPosition(-1);
        this.invalidateCanvas();
    }

    public void removeAll() {
        Component[] componentArray = this.getComponents();
        if (componentArray != null) {
            int n = 0;
            while (n < componentArray.length) {
                componentArray[n].removeComponentListener(this._visible);
                ++n;
            }
        }
        super.removeAll();
        this.setSplitterPosition(-1);
        this.invalidateCanvas();
    }

    public void setEnabled(boolean bl) {
        Component[] componentArray = this.getComponents();
        int n = 0;
        while (n < componentArray.length) {
            componentArray[n].setEnabled(bl);
            ++n;
        }
        this.repaintCanvas();
    }

    protected void addImpl(Component component, Object object, int n) {
        if (this.getComponentCount() == 2) {
            String string = "Only two components can be added to the splitter";
            throw new IllegalStateException(string);
        }
        if (this._visible == null) {
            this._visible = new Visible();
        }
        component.addComponentListener(this._visible);
        super.addImpl(component, object, n);
        this.setSplitterPosition(-1);
        this.invalidateCanvas();
    }

    protected void paintCanvasInterior(Graphics graphics) {
        int n = this.getSplitterPosition();
        if (n != -1) {
            Separator separator = this.getSeparator();
            n += separator.getSize() / 2;
            if (this.isHorizontal()) {
                separator.paint(graphics, 0, n, this.getBounds().width, n);
                return;
            }
            separator.paint(graphics, n, 0, n, this.getBounds().height);
        }
    }

    protected Dimension layoutCanvas() {
        Component component = this._getFirstComponent();
        Component component2 = this._getSecondComponent();
        Dimension dimension = this.getInnerSize();
        Point point = this.getInnerOrigin();
        if (component == null || component2 == null || !component.isVisible() || !component2.isVisible()) {
            this.setSplitterPosition(-1);
            if (component != null && component.isVisible()) {
                component.setBounds(point.x, point.y, dimension.width, dimension.height);
            } else if (component2 != null && component2.isVisible()) {
                component2.setBounds(point.x, point.y, dimension.width, dimension.height);
            }
            return dimension;
        }
        this._c1MinSize = component.getMinimumSize();
        this._c2MinSize = component2.getMinimumSize();
        int n = this.getSplitterPosition();
        if (n == -1) {
            n = this.isHorizontal() ? dimension.height / 2 : dimension.width / 2;
            this.setSplitterPosition(n);
            n = this.getSplitterPosition();
        }
        int n2 = n + this.getSeparator().getSize() + 1;
        if (this.isHorizontal()) {
            component.setBounds(point.x, point.y, dimension.width, n - 1);
            component2.setBounds(point.x, point.y + n2, dimension.width, dimension.height - n2);
        } else {
            component.setBounds(point.x, point.y, n - 1, dimension.height);
            component2.setBounds(point.x + n2, point.y, dimension.width - n2, dimension.height);
        }
        return dimension;
    }

    protected void processMouseEvent(MouseEvent mouseEvent) {
        super.processMouseEvent(mouseEvent);
        if (mouseEvent.isConsumed() || !this.isEnabled()) {
            return;
        }
        Point point = this.getInnerOrigin();
        mouseEvent.translatePoint(-point.x, -point.y);
        boolean bl = false;
        switch (mouseEvent.getID()) {
            case 501: {
                bl = this._processMousePressed(mouseEvent);
                break;
            }
            case 502: {
                bl = this._processMouseReleased(mouseEvent);
                break;
            }
            case 505: {
                this.setCursor(Cursor.getDefaultCursor());
                bl = true;
                break;
            }
        }
        if (bl) {
            mouseEvent.consume();
        }
    }

    protected void processMouseMotionEvent(MouseEvent mouseEvent) {
        super.processMouseMotionEvent(mouseEvent);
        if (mouseEvent.isConsumed() || !this.isEnabled()) {
            return;
        }
        Point point = this.getInnerOrigin();
        mouseEvent.translatePoint(-point.x, -point.y);
        boolean bl = false;
        switch (mouseEvent.getID()) {
            case 503: {
                bl = this._processMouseMoved(mouseEvent);
                break;
            }
            case 506: {
                bl = this._processMouseDragged(mouseEvent);
                break;
            }
        }
        if (bl) {
            mouseEvent.consume();
        }
    }

    protected void processComponentEvent(ComponentEvent componentEvent) {
        super.processComponentEvent(componentEvent);
        if (componentEvent.getID() == 101) {
            int n;
            Dimension dimension = this.getSize();
            int n2 = n = this.isHorizontal() ? dimension.height : dimension.width;
            if (n != this._size) {
                if (this._size != 0) {
                    int n3 = this.getSplitterPosition();
                    int n4 = n * n3 / this._size;
                    this.setSplitterPosition(n4);
                }
                if (this.getSplitterPosition() == -1) {
                    this._size = 0;
                    return;
                }
                this._size = n;
                this.invalidateCanvas();
            }
        }
    }

    boolean isResizing() {
        return this._resizing;
    }

    private boolean _processMousePressed(MouseEvent mouseEvent) {
        if ((mouseEvent.getModifiers() & 0x10) == 0) {
            this.setCursor(Cursor.getDefaultCursor());
            return false;
        }
        if (this._pointInSplitter(mouseEvent.getX(), mouseEvent.getY())) {
            this._resizing = true;
            Cursor cursor = this.isHorizontal() ? Cursor.getPredefinedCursor(9) : Cursor.getPredefinedCursor(11);
            this.setCursor(cursor);
            this._bugWorkAround(true);
        }
        return true;
    }

    private boolean _processMouseReleased(MouseEvent mouseEvent) {
        if (!this._resizing) {
            return false;
        }
        this._paintFeedback();
        this._resizing = false;
        this.setCursor(Cursor.getDefaultCursor());
        int n = this._checkMousePosition(mouseEvent);
        this.setSplitterPosition(n);
        this._bugWorkAround(false);
        this._feedback = -1;
        return true;
    }

    private boolean _processMouseMoved(MouseEvent mouseEvent) {
        Cursor cursor = this.isHorizontal() ? Cursor.getPredefinedCursor(9) : Cursor.getPredefinedCursor(11);
        if (this._pointInSplitter(mouseEvent.getX(), mouseEvent.getY())) {
            this.setCursor(cursor);
        } else {
            this.setCursor(Cursor.getDefaultCursor());
        }
        return true;
    }

    private boolean _processMouseDragged(MouseEvent mouseEvent) {
        if (!this._resizing) {
            return false;
        }
        int n = this._checkMousePosition(mouseEvent);
        if (n != this._feedback) {
            this._paintFeedback();
            this._feedback = n;
            this._paintFeedback();
        }
        return true;
    }

    private int _checkMousePosition(MouseEvent mouseEvent) {
        int n = this.isHorizontal() ? mouseEvent.getY() : mouseEvent.getX();
        Dimension dimension = this.getInnerSize();
        int n2 = this.getSeparator().getSize();
        if (this.isHorizontal()) {
            if (n < this._c1MinSize.height) {
                n = this._c1MinSize.height;
            } else if (n > dimension.height - this._c2MinSize.height - n2) {
                n = dimension.height - this._c2MinSize.height - n2;
            }
        } else if (n < this._c1MinSize.width) {
            n = this._c1MinSize.width;
        } else if (n > dimension.width - this._c2MinSize.width - n2) {
            n = dimension.width - this._c2MinSize.width - n2;
        }
        return n;
    }

    private boolean _pointInSplitter(int n, int n2) {
        int n3;
        int n4 = n3 = this.isHorizontal() ? n2 : n;
        if (!this._canResize(n3)) {
            return false;
        }
        int n5 = this.getSplitterPosition();
        int n6 = this.getSeparator().getSize();
        return n3 >= n5 && n3 <= n5 + n6;
    }

    private boolean _canResize(int n) {
        Component component = this._getFirstComponent();
        Component component2 = this._getSecondComponent();
        if (component == null || component2 == null) {
            return false;
        }
        Dimension dimension = this.getInnerSize();
        int n2 = this.getSeparator().getSize();
        boolean bl = this.isHorizontal() ? dimension.height > this._c1MinSize.height + this._c2MinSize.height + n2 : dimension.width > this._c1MinSize.width + this._c2MinSize.width + n2;
        return bl;
    }

    private int _checkSplitterPosition(int n) {
        int n2;
        int n3;
        int n4;
        if (n == -1) {
            return -1;
        }
        Component component = this._getFirstComponent();
        Component component2 = this._getSecondComponent();
        if (component == null || component2 == null) {
            return 0;
        }
        if (this._c1MinSize == null || this._c2MinSize == null) {
            return n;
        }
        Dimension dimension = this.getInnerSize();
        if (this.isHorizontal()) {
            n4 = this._c1MinSize.height;
            n3 = this._c2MinSize.height;
            n2 = dimension.height;
        } else {
            n4 = this._c1MinSize.width;
            n3 = this._c2MinSize.width;
            n2 = dimension.width;
        }
        int n5 = this.getSeparator().getSize();
        if (n2 < n4 + n3 + n5) {
            n = n2 * n4 / (n4 + n3);
        } else if (n < n4) {
            n = n4;
        } else if (n > n2 - n5 - n3) {
            n = n2 - n5 - n3;
        }
        return n;
    }

    private void _paintFeedback() {
        if (this._feedback == -1) {
            return;
        }
        int n = this.getSplitterPosition();
        int n2 = this.getSeparator().getSize();
        Point point = this.getInnerOrigin();
        if (this._feedback < n) {
            Component component = this._getFirstComponent();
            if (component instanceof Container) {
                this._paintContainerFeedback((Container)component, this._feedback, this.isHorizontal());
            }
            this._paintRegularFeedback(component, this._feedback, this.isHorizontal());
            return;
        }
        if (this._feedback > n + n2) {
            Component component = this._getSecondComponent();
            int n3 = this._feedback - n - n2;
            if (component instanceof Container) {
                this._paintContainerFeedback((Container)component, n3, this.isHorizontal());
            }
            this._paintRegularFeedback(component, n3, this.isHorizontal());
            return;
        }
        int n4 = this.isHorizontal() ? point.y : point.x;
        this._paintFeedback(this._feedback + n4, this.isHorizontal());
    }

    private void _paintContainerFeedback(Container container, int n, boolean bl) {
        if (container instanceof LWComponent) {
            return;
        }
        Component[] componentArray = container.getComponents();
        if (componentArray == null || componentArray.length == 0) {
            return;
        }
        int n2 = componentArray.length;
        boolean bl2 = false;
        int n3 = 0;
        int n4 = 0;
        while (n4 < n2) {
            Component component = componentArray[n4];
            Rectangle rectangle = component.getBounds();
            if (bl) {
                bl2 = rectangle.inside(rectangle.x, n);
                if (bl2) {
                    n3 = n - rectangle.y;
                }
            } else {
                bl2 = rectangle.inside(n, rectangle.y);
                if (bl2) {
                    n3 = n - rectangle.x;
                }
            }
            if (bl2) {
                if (component instanceof Container) {
                    this._paintContainerFeedback((Container)component, n3, bl);
                }
                this._paintRegularFeedback(component, n3, bl);
            }
            ++n4;
        }
    }

    private void _paintRegularFeedback(Component component, int n, boolean bl) {
        Graphics graphics = component.getGraphics();
        Dimension dimension = this.getInnerSize();
        LWComponent lWComponent = null;
        if (component instanceof LWComponent) {
            lWComponent = (LWComponent)component;
            lWComponent.freezeRepaints();
        }
        Color color = graphics.getColor();
        graphics.setColor(Color.black);
        graphics.setXORMode(Color.white);
        if (bl) {
            graphics.fillRect(0, n - 1, dimension.width, 3);
        } else {
            graphics.fillRect(n - 1, 0, 3, dimension.height);
        }
        graphics.setPaintMode();
        graphics.setColor(color);
        graphics.dispose();
        if (lWComponent != null) {
            lWComponent.unfreezeRepaints();
        }
    }

    private void _paintFeedback(int n, boolean bl) {
        Graphics graphics = this.getGraphics();
        Dimension dimension = this.getInnerSize();
        Color color = graphics.getColor();
        graphics.setColor(Color.black);
        graphics.setXORMode(Color.white);
        if (bl) {
            graphics.fillRect(this.getInnerOrigin().x, n - 1, dimension.width, 3);
        } else {
            graphics.fillRect(n - 1, this.getInnerOrigin().y, 3, dimension.height);
        }
        graphics.setPaintMode();
        graphics.setColor(color);
        graphics.dispose();
    }

    private void _firePropertyChanged(String string, Object object, Object object2) {
        if (this._propertySupport != null) {
            this._propertySupport.firePropertyChange(string, object, object2);
        }
    }

    private Component _getFirstComponent() {
        if (this.getComponentCount() > 0) {
            return this.getComponent(0);
        }
        return null;
    }

    private Component _getSecondComponent() {
        if (this.getComponentCount() > 1) {
            return this.getComponent(1);
        }
        return null;
    }

    private MouseCheck _getMouseCheck() {
        if (_sMouseCheck == null) {
            _sMouseCheck = new MouseCheck();
        }
        return _sMouseCheck;
    }

    private void _bugWorkAround(boolean bl) {
        Component component = this._getFirstComponent();
        if (component instanceof LWComponent) {
            if (bl) {
                component.addMouseListener(this._getMouseCheck());
                component.addMouseMotionListener(this._getMouseCheck());
            } else {
                component.removeMouseListener(this._getMouseCheck());
                component.removeMouseMotionListener(this._getMouseCheck());
            }
        }
        if ((component = this._getSecondComponent()) instanceof LWComponent) {
            if (bl) {
                component.addMouseListener(this._getMouseCheck());
                component.addMouseMotionListener(this._getMouseCheck());
                return;
            }
            component.removeMouseListener(this._getMouseCheck());
            component.removeMouseMotionListener(this._getMouseCheck());
        }
    }

    void bugWorkAround(MouseEvent mouseEvent) {
        int n;
        Object object = mouseEvent.getSource();
        if (object == this._getSecondComponent()) {
            n = this.getSplitterPosition();
            int n2 = this.getSeparator().getSize();
            int n3 = n + n2;
            if (this.isHorizontal()) {
                mouseEvent.translatePoint(0, n3);
            } else {
                mouseEvent.translatePoint(n3, 0);
            }
        }
        if ((n = mouseEvent.getID()) == 506) {
            if (this._processMouseDragged(mouseEvent)) {
                mouseEvent.consume();
                return;
            }
        } else if (n == 502 && this._processMouseReleased(mouseEvent)) {
            mouseEvent.consume();
        }
    }

    private class Visible
    extends ComponentAdapter {
        public void componentShown(ComponentEvent componentEvent) {
            Splitter.this.invalidateCanvas();
        }

        public void componentHidden(ComponentEvent componentEvent) {
            Splitter.this.invalidateCanvas();
        }

        Visible() {
            Splitter.this = Splitter.this;
        }
    }

    private class MouseCheck
    extends MouseAdapter
    implements MouseMotionListener {
        public void mouseDragged(MouseEvent mouseEvent) {
            Splitter.this.bugWorkAround(mouseEvent);
        }

        public void mouseMoved(MouseEvent mouseEvent) {
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            Splitter.this.bugWorkAround(mouseEvent);
        }

        MouseCheck() {
            Splitter.this = Splitter.this;
        }
    }
}

