/*
 * Decompiled with CFR 0.152.
 */
package com.lucent.ra.nms.netboot;

import com.lucent.ra.nms.util.LEAppInfo;
import com.lucent.ra.nms.util.LEDebug;
import com.lucent.ra.nms.util.LEObservable;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;

public class LEBootPDatabaseMgr
extends LEObservable {
    private static LEBootPDatabaseMgr s_singleton = null;
    private Hashtable m_database;
    private File m_inputFile;
    private String m_fileStr = LEAppInfo.createFullPath(LEAppInfo.getUserAppDir(), "bootp.cfg");

    public static LEBootPDatabaseMgr GetManager() {
        if (s_singleton == null) {
            s_singleton = new LEBootPDatabaseMgr();
        }
        return s_singleton;
    }

    private LEBootPDatabaseMgr() {
        try {
            this.m_inputFile = new File(this.m_fileStr);
            FileReader fileReader = new FileReader(this.m_inputFile);
            BufferedReader bufferedReader = new BufferedReader(fileReader);
            this.createDatabase(bufferedReader);
            return;
        }
        catch (FileNotFoundException fileNotFoundException) {
            LEDebug.getLog().logln(20, "File not found: " + this.m_fileStr);
            this.m_database = new Hashtable();
            return;
        }
    }

    public void createDatabase(BufferedReader bufferedReader) {
        this.m_database = new Hashtable();
        try {
            String string;
            while ((string = bufferedReader.readLine()) != null) {
                String string2;
                StringTokenizer stringTokenizer = new StringTokenizer(string);
                String string3 = stringTokenizer.nextToken();
                if (!LEBootPDatabaseMgr.VerifyMACAddress(string3) || !stringTokenizer.hasMoreElements() || !LEBootPDatabaseMgr.VerifyIPAddress(string2 = stringTokenizer.nextToken())) continue;
                String string4 = LEBootPDatabaseMgr.ToLowerCaseMAC(string3);
                this.m_database.put(string4, string2);
            }
            this.notifyObservers(this.m_database);
            return;
        }
        catch (Exception exception) {
            LEDebug.getLog().logln(20, "Exception when creating database");
            return;
        }
    }

    public Hashtable getDatabase() {
        return this.m_database;
    }

    public void add(String string, String string2) {
        if (LEBootPDatabaseMgr.VerifyMACAddress(string) && LEBootPDatabaseMgr.VerifyIPAddress(string2)) {
            String string3 = LEBootPDatabaseMgr.ToLowerCaseMAC(string);
            if (this.m_database.containsKey(string3)) {
                this.m_database.remove(string3);
                this.m_database.put(string3, string2);
            } else {
                this.m_database.put(string3, string2);
            }
            this.notifyObservers(this.m_database);
        }
    }

    public void delete(String string) {
        if (this.m_database.containsKey(string)) {
            this.m_database.remove(string);
        }
    }

    public void save() {
        this.m_inputFile.delete();
        this.save(this.m_fileStr);
    }

    public void save(String string) {
        try {
            FileWriter fileWriter = new FileWriter(new File(string));
            PrintWriter printWriter = new PrintWriter((Writer)fileWriter, false);
            Enumeration enumeration = this.m_database.keys();
            while (enumeration.hasMoreElements()) {
                String string2 = (String)enumeration.nextElement();
                String string3 = (String)this.m_database.get(string2);
                printWriter.println(String.valueOf(string2) + " " + string3);
            }
            printWriter.flush();
            printWriter.close();
            return;
        }
        catch (IOException iOException) {
            LEDebug.getLog().logln(20, "IOException when attempting to write to " + this.m_fileStr);
            return;
        }
    }

    public static boolean VerifyMACAddress(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ":");
        int n = string.length();
        if (n != 17 || stringTokenizer.countTokens() != 6) {
            return false;
        }
        char[] cArray = string.toCharArray();
        int n2 = Character.getNumericValue('g');
        int n3 = 0;
        while (n3 < n) {
            char c = cArray[n3];
            if (!Character.isDigit(c) && c != ':') {
                if (Character.isLetter(c)) {
                    int n4 = Character.getNumericValue(c = Character.toLowerCase(c));
                    if (n4 >= n2) {
                        return false;
                    }
                } else {
                    return false;
                }
            }
            ++n3;
        }
        return true;
    }

    private static String ToLowerCaseMAC(String string) {
        int n = string.length();
        char[] cArray = string.toCharArray();
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            if (Character.isLetter(c)) {
                c = Character.toLowerCase(c);
                stringBuffer.append(c);
            } else {
                stringBuffer.append(c);
            }
            ++n2;
        }
        return stringBuffer.toString();
    }

    public static boolean VerifyIPAddress(String string) {
        int n;
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        if (string.length() > 15 || stringTokenizer.countTokens() != 4) {
            return false;
        }
        int n2 = string.length();
        int n3 = 0;
        while (n3 < n2) {
            n = string.charAt(n3);
            if (n != 46 && !Character.isDigit((char)n)) {
                return false;
            }
            ++n3;
        }
        while (stringTokenizer.hasMoreTokens()) {
            n = Integer.parseInt(stringTokenizer.nextToken());
            if (n >= 0 && n <= 255) continue;
            return false;
        }
        return true;
    }
}

