/*
 * Decompiled with CFR 0.152.
 */
package com.lucent.ra.nms.netboot;

import com.lucent.ra.nms.netboot.LETFTPPacket;
import com.lucent.ra.nms.netboot.LETFTPServer;
import com.lucent.ra.nms.util.LEByteArray;
import com.lucent.ra.nms.util.LEDebug;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.net.DatagramPacket;

public class LETFTPReqPacket
extends LETFTPPacket {
    public static final byte UNKNOWN_MODE = 0;
    public static final byte NETASCII_MODE = 1;
    public static final byte OCTET_MODE = 2;
    public static final byte MAIL_MODE = 3;
    public static final String NETASCII_STR = "netascii";
    public static final String OCTET_STR = "octet";
    public static final String MAIL_STR = "mail";
    private static final int MAX_PACKET_SIZE = 256;
    private String m_filename;
    private String m_modestr;
    private byte m_mode;
    private byte[] m_data;
    private int m_length;

    public LETFTPReqPacket(DatagramPacket datagramPacket) {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(datagramPacket.getData());
        DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
        this.m_data = new byte[256];
        int n = 0;
        try {
            this.m_data[n++] = dataInputStream.readByte();
            this.m_data[n++] = dataInputStream.readByte();
            int n2 = n;
            while ((this.m_data[n++] = dataInputStream.readByte()) != 0) {
            }
            this.m_filename = new String(this.m_data, n2, n - 1 - n2);
            n2 = n;
            while ((this.m_data[n++] = dataInputStream.readByte()) != 0) {
            }
            this.m_modestr = new String(this.m_data, n2, n - 1 - n2);
            this.m_mode = this.m_modestr.equalsIgnoreCase(NETASCII_STR) ? (byte)1 : (this.m_modestr.equalsIgnoreCase(OCTET_STR) ? (byte)2 : (this.m_modestr.equalsIgnoreCase(MAIL_STR) ? (byte)3 : (byte)0));
            this.m_length = n;
            return;
        }
        catch (Exception exception) {
            LEDebug.getLog().logln(20, exception);
            LEDebug.getLog().logln(20, "Error reading input TFTP Request");
            return;
        }
    }

    public LETFTPReqPacket(short s, String string, String string2) {
        int n = 0;
        this.m_data = new byte[256];
        LEByteArray.CopyShort(s, this.m_data, n);
        LEByteArray.CopyBytes(string.getBytes(), this.m_data, n += 2, string.length());
        n += string.length();
        this.m_filename = string;
        this.m_data[n++] = 0;
        LEByteArray.CopyBytes(string2.getBytes(), this.m_data, n, string2.length());
        n += string2.length();
        this.m_data[n++] = 0;
        this.m_length = n;
    }

    public String getFileName() {
        return this.m_filename;
    }

    public byte getMode() {
        return this.m_mode;
    }

    public byte[] getBytes() {
        return this.m_data;
    }

    public int getSize() {
        return this.m_length;
    }

    public void printPacket() {
        LETFTPServer.GetServer().printMsg("Request packet", false);
        LETFTPServer.GetServer().printMsg(" Filename: " + this.m_filename, false);
        LETFTPServer.GetServer().printMsg(" Mode: " + this.m_modestr, false);
        LETFTPServer.GetServer().printMsg(" Contents: ", false);
        int n = 0;
        while (n < this.m_length) {
            LETFTPServer.GetServer().printMsg(Byte.toString(this.m_data[n]), false);
            ++n;
        }
    }
}

