/*
 * Decompiled with CFR 0.152.
 */
package COM.livingston.model;

import COM.livingston.amf.LEAMFactory;
import COM.livingston.amf.LEAMObserver;
import COM.livingston.backend.LEDebugFactory;
import COM.livingston.backend.LEDebugMessage;
import COM.livingston.backend.LEMonSessionsMessage;
import COM.livingston.backend.LEMonitorFactory;
import COM.livingston.backend.LEPMCommand;
import COM.livingston.model.LEDebugFacility;
import COM.livingston.model.LEDialerStatusMessage;
import COM.livingston.model.LEDialerUpdateMessage;
import COM.livingston.model.LELocation;
import COM.livingston.model.LELocations;
import COM.livingston.model.LEPortMaster;
import COM.livingston.util.LEDebug;
import COM.livingston.util.LEObservable;
import COM.livingston.util.LEVector;

public class LEDialer
extends LEObservable
implements LEAMObserver {
    private static final String IDLE = "IDLE";
    private static final String CONNECTING = "CONNECTING";
    private static final String ESTABLISHED = "ESTABLISHED";
    private static final int SESSION_MONITOR = 65536;
    private static final int MONITOR_TIME = 3000;
    private static final int DIAL_DEBUG = 17;
    LELocation m_location;
    boolean m_locexists = false;
    LEPortMaster m_pm;
    String m_port;
    String m_slot;
    String m_previous_state = "";
    int m_dial_count;
    long m_monitorID;
    boolean m_debug;

    public LEDialer(LEPortMaster lEPortMaster) {
        this.m_pm = lEPortMaster;
        this.m_dial_count = 0;
        this.m_port = "";
        this.m_slot = "";
        this.m_debug = false;
    }

    public void setDebug(boolean bl) {
        this.m_debug = bl;
    }

    public LEVector setLocation(LELocation lELocation) {
        LEVector lEVector = new LEVector();
        this.m_location = (LELocation)lELocation.clone();
        LELocations lELocations = (LELocations)this.m_pm.get("1703936");
        LEVector lEVector2 = lELocations.getKeys();
        if (lEVector2.contains(this.m_location.getName())) {
            this.m_locexists = true;
        } else {
            lELocations.set(this.m_location.getName(), this.m_location);
            lEVector = lELocations.saveChanges();
        }
        return lEVector;
    }

    public LEVector removeLocation() {
        LEVector lEVector = new LEVector();
        if (!this.m_locexists) {
            LELocations lELocations = (LELocations)this.m_pm.get("1703936");
            lEVector = lELocations.delete(this.m_location.getName());
        }
        return lEVector;
    }

    public void dialLocation() {
        Object object;
        int n = -1;
        String string = "dial " + this.m_location.getName();
        LEMonitorFactory.GetFactory().addObserver(this.m_pm.getHostname(), this);
        if (this.m_debug) {
            LEDebugFactory.GetFactory().addObserver(this.m_pm.getHostname(), this);
            LEDebugFacility lEDebugFacility = this.m_pm.getDebugFacility();
            if (lEDebugFacility != null) {
                lEDebugFacility.startDebug(393216, 17, -1);
            }
        }
        LEPMCommand lEPMCommand = this.m_pm.execute(string);
        String string2 = lEPMCommand.getResult();
        if (!lEPMCommand.getStatus() || string2.length() == 0) {
            this.sendFailMessage(string2);
            return;
        }
        int n2 = string2.indexOf("using");
        if (n2 > -1) {
            object = string2.substring(n2 + 6);
            this.m_port = (n2 = ((String)object).indexOf(" ")) > -1 ? ((String)object).substring(0, n2).trim() : ((String)object).trim();
        }
        if ((n2 = string2.indexOf("Slot")) > -1) {
            this.m_slot = string2.substring(n2 + 4).trim();
            n = Integer.parseInt(this.m_slot);
        }
        try {
            this.m_monitorID = n > -1 ? this.m_pm.getDSS().monitor(65536, 3000, n) : this.m_pm.getDSS().monitor(65536, 3000);
        }
        catch (Exception exception) {
            LEDebug.getLog().logln(20, exception);
            this.sendFailMessage(exception.getMessage());
            this.disconnect();
        }
        object = new LEDialerUpdateMessage();
        ((LEDialerUpdateMessage)object).setMessage(string2);
        this.notifyObservers(object);
    }

    public void cancelDial() {
        if (this.m_port != null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("reset ");
            stringBuffer.append(this.m_port);
            LEPMCommand lEPMCommand = this.m_pm.execute(stringBuffer.toString());
            if (!lEPMCommand.getStatus()) {
                StringBuffer stringBuffer2 = new StringBuffer();
                stringBuffer2.append("Could not reset port ");
                stringBuffer2.append(this.m_port);
                this.notifyObservers(stringBuffer2.toString());
                return;
            }
            StringBuffer stringBuffer3 = new StringBuffer();
            stringBuffer3.append("Reset port ");
            stringBuffer3.append(this.m_port);
            LEDialerUpdateMessage lEDialerUpdateMessage = new LEDialerUpdateMessage();
            lEDialerUpdateMessage.setMessage(stringBuffer3.toString());
            this.notifyObservers(lEDialerUpdateMessage);
        }
    }

    public void update(LEAMFactory lEAMFactory, String string, Object object) {
        if (object instanceof LEMonSessionsMessage) {
            LEMonSessionsMessage lEMonSessionsMessage = (LEMonSessionsMessage)object;
            if (!this.m_slot.equals("") && !lEMonSessionsMessage.getBoard().equals(this.m_slot)) {
                return;
            }
            if (!lEMonSessionsMessage.getPortName().equals(this.m_port)) {
                return;
            }
            String string2 = lEMonSessionsMessage.getStatus();
            if (this.m_dial_count < 10) {
                ++this.m_dial_count;
            } else {
                this.sendFailMessage(null);
                this.disconnect();
            }
            if (string2.equals(IDLE)) {
                if (this.m_previous_state.equals(CONNECTING)) {
                    this.sendFailMessage(null);
                    this.disconnect();
                }
                this.m_previous_state = string2;
                return;
            }
            if (string2.equals(CONNECTING)) {
                this.m_previous_state = string2;
                return;
            }
            if (string2.equals(ESTABLISHED)) {
                this.sendSuccessMessage();
                this.disconnect();
                return;
            }
        } else if (object instanceof LEDebugMessage) {
            LEDebugMessage lEDebugMessage = (LEDebugMessage)object;
            LEDialerUpdateMessage lEDialerUpdateMessage = new LEDialerUpdateMessage();
            lEDialerUpdateMessage.setMessage(lEDebugMessage.getData());
            this.notifyObservers(lEDialerUpdateMessage);
        }
    }

    protected void sendFailMessage(String string) {
        LEDialerStatusMessage lEDialerStatusMessage = new LEDialerStatusMessage();
        lEDialerStatusMessage.setSuccess(false);
        lEDialerStatusMessage.setPortName(this.m_port);
        lEDialerStatusMessage.setBoard(this.m_slot);
        lEDialerStatusMessage.setLocation(this.m_location.getName());
        lEDialerStatusMessage.setMessage(string);
        this.notifyObservers(lEDialerStatusMessage);
    }

    protected void sendSuccessMessage() {
        LEDialerStatusMessage lEDialerStatusMessage = new LEDialerStatusMessage();
        lEDialerStatusMessage.setSuccess(true);
        lEDialerStatusMessage.setPortName(this.m_port);
        lEDialerStatusMessage.setBoard(this.m_slot);
        lEDialerStatusMessage.setLocation(this.m_location.getName());
        this.notifyObservers(lEDialerStatusMessage);
    }

    protected void disconnect() {
        LEMonitorFactory.GetFactory().deleteObserver(this.m_pm.getHostname(), this);
        LEDebugFactory.GetFactory().deleteObserver(this.m_pm.getHostname(), this);
        try {
            this.m_pm.getDSS().killMonitor(this.m_monitorID);
            LEDebugFacility lEDebugFacility = this.m_pm.getDebugFacility();
            lEDebugFacility.stopDebug(393216, 17, -1);
            return;
        }
        catch (Exception exception) {
            LEDebug.getLog().logln(20, exception);
            return;
        }
    }
}

