/*
 * Decompiled with CFR 0.152.
 */
import COM.livingston.backend.LEDSSPMUpgrade;
import COM.livingston.backend.LEDSSPortMaster;
import COM.livingston.util.LEAppInfo;
import COM.livingston.util.LEDebug;
import COM.livingston.util.LEDebugLog;
import COM.livingston.util.LEObservable;
import COM.livingston.util.LEObserver;
import COM.livingston.util.LEStatusManager;
import COM.livingston.util.LEThreadStatus;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.DateFormat;
import java.util.Date;

public class PMUpgrade
extends CLUtil
implements Runnable,
LEObserver {
    private static final int DOT_MAX = 10;
    Thread m_thread = new Thread((Runnable)this, "PMUpgrade");
    long m_wait_time;
    int m_dotcount;
    LEDebugLog m_log = LEDebug.getLog();

    public static void main(String[] stringArray) {
        Object object;
        LEAppInfo.setFlag("-g", "20");
        LEAppInfo.setFlags(stringArray);
        LEAppInfo.setAppName("PMUpgrade");
        LEAppInfo.setAppVersion("4.1b1");
        LEAppInfo.setIsApplet(false);
        try {
            object = LEAppInfo.getUserAppDirPath("debuglog.txt");
            File file = new File((String)object);
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            LEDebug.initialize(fileOutputStream);
        }
        catch (IOException iOException) {
            LEDebug.initialize(System.out);
            LEDebug.getLog().logln(20, iOException);
        }
        LEDebug.getLog().logln(20, LEAppInfo.getAppTitle());
        LEDebug.getLog().loglnTime(20);
        LEDebug.getLog().logln(20);
        object = new PMUpgrade();
        ((PMUpgrade)object).processArgs(stringArray);
    }

    public void processArgs(String[] stringArray) {
        super.processArgs(stringArray);
        boolean bl = true;
        if (stringArray.length < 4) {
            this.checkArgs();
            return;
        }
        if (LEAppInfo.getFlag("-version") != null) {
            this.printAppInfo();
        }
        if (LEAppInfo.getFlag("-at") != null) {
            int n = -1;
            int n2 = 0;
            while (n2 < stringArray.length) {
                if (stringArray[n2].equals("-at")) {
                    n = n2;
                    break;
                }
                ++n2;
            }
            if (n > 0) {
                StringBuffer stringBuffer = new StringBuffer(50);
                int n3 = n + 1;
                while (n3 < stringArray.length) {
                    if (n3 > n + 1) {
                        stringBuffer.append(" ");
                    }
                    stringBuffer.append(stringArray[n3]);
                    ++n3;
                }
                if (stringBuffer.length() > 1) {
                    bl = this.processTime(stringBuffer.toString());
                } else {
                    this.printBadTimeMsg();
                    bl = false;
                }
            } else {
                this.printBadTimeMsg();
                bl = false;
            }
        }
        if (bl) {
            this.startUpgrade();
        }
    }

    public void startUpgrade() {
        this.m_thread.start();
    }

    public boolean processTime(String string) {
        DateFormat dateFormat = DateFormat.getDateTimeInstance(3, 3);
        Date date = null;
        try {
            date = dateFormat.parse(string);
        }
        catch (Exception exception) {
            System.out.println("Error in parsing upgrade time. (Example: \"3/4/7 12:00 AM\")");
            LEDebug.getLog().logln(20, exception);
            return false;
        }
        Date date2 = new Date();
        long l = date2.getTime();
        long l2 = date.getTime();
        if (l2 < l) {
            System.out.println("Upgrade time is earlier than the current time");
            return false;
        }
        this.m_wait_time = l2 - l;
        return true;
    }

    private void upgradePM() {
        LEDSSPortMaster lEDSSPortMaster = null;
        LEDSSPMUpgrade lEDSSPMUpgrade = null;
        String string = LEAppInfo.getFlag("-f");
        File file = new File(string);
        if (!file.exists()) {
            System.out.println("File not found: " + string);
            return;
        }
        this.connectToPortMaster();
        lEDSSPortMaster = this.m_pm.getDSS();
        try {
            lEDSSPMUpgrade = new LEDSSPMUpgrade(file, lEDSSPortMaster);
        }
        catch (Exception exception) {
            System.out.println("File not found: " + exception.getMessage());
            LEDebug.getLog().logln(20, exception);
            return;
        }
        try {
            LEStatusManager lEStatusManager = lEDSSPMUpgrade.getStatusManager();
            lEStatusManager.addObserver(this);
            lEDSSPMUpgrade.doUpgrade();
            System.out.println("");
            lEStatusManager.deleteObserver(this);
        }
        catch (Exception exception) {
            System.out.println("Error in upgrading, DO NOT REBOOT: " + exception.getMessage());
            LEDebug.getLog().logln(20, exception);
            return;
        }
        if (LEAppInfo.getFlag("-r") != null) {
            System.out.println("Rebooting PM, this may take up to a minute.");
            lEDSSPortMaster.execute("reboot");
            System.out.println("Upgrade successful.");
            return;
        }
        System.out.println("Upgrade successful, you need to reboot.");
    }

    public void printUsage() {
        super.printUsage();
        System.out.println("[-r] -f <filename> [-at \"mon/day/year hour:min AM/PM\"] ");
    }

    public void printHelpInfo() {
        super.printHelpInfo();
        System.out.println("[-r] : reboots the PortMaster after a sucessful upgrade.");
        System.out.println("-f <filename> : specifies the upgrade file.");
        System.out.println("[-at \"mon/day/year hour:min AM/PM\"] : specifies the time to start the upgrade.");
    }

    public void run() {
        try {
            Thread.sleep(this.m_wait_time);
            this.upgradePM();
        }
        catch (Exception exception) {}
        this.disconnect();
    }

    public void update(LEObservable lEObservable, Object object) {
        if (object instanceof LEThreadStatus) {
            ++this.m_dotcount;
            if (this.m_dotcount > 10) {
                this.m_dotcount = 0;
                System.out.print(".");
            }
        }
    }

    public void printBadTimeMsg() {
        System.out.println("The -at flag exists without an associated time. ");
        if (!LEAppInfo.isUnix()) {
            System.out.print("It is possible that the number of entered arguments ");
            System.out.print("exceeds the limit of your command prompt.");
            System.out.println("");
        }
    }
}

