/*
 * Decompiled with CFR 0.152.
 */
import COM.livingston.backend.LEDSSFlatFile;
import COM.livingston.util.LEAppInfo;
import COM.livingston.util.LEDebug;
import COM.livingston.util.LEDebugLog;
import COM.livingston.util.LEVector;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;

public class PMBackup
extends CLUtil {
    LEDebugLog m_log = LEDebug.getLog();

    public static void main(String[] args) {
        LEAppInfo.setFlag("-g", "20");
        LEAppInfo.setFlags(args);
        LEAppInfo.setAppName("pmbackup");
        LEAppInfo.setAppVersion("4.0");
        LEAppInfo.setIsApplet(false);
        try {
            String path = LEAppInfo.getUserAppDirPath("debuglog.txt");
            File debugFile = new File(path);
            FileOutputStream fostream = new FileOutputStream(debugFile);
            LEDebug.initialize(fostream);
        }
        catch (IOException e) {
            LEDebug.initialize(System.out);
            LEDebug.getLog().logln(20, e);
        }
        LEDebug.getLog().setLogLevel(20);
        LEDebug.getLog().logln(20, LEAppInfo.getAppTitle());
        LEDebug.getLog().loglnTime(20);
        LEDebug.getLog().logln(20);
        PMBackup backup = new PMBackup();
        backup.processArgs(args);
        System.exit(0);
    }

    public void processArgs(String[] args) {
        super.processArgs(args);
        if (args.length < 2) {
            this.checkArgs();
        } else {
            if (LEAppInfo.getFlag("-version") != null) {
                this.printAppInfo();
            }
            this.backupPM();
        }
    }

    public void backupPM() {
        String outFile = LEAppInfo.getFlag("-f");
        this.connectToPortMaster();
        LEVector cmds = new LEVector(100);
        boolean status = this.m_pm.getCommands(cmds);
        LEDSSFlatFile ff = new LEDSSFlatFile(outFile, 1);
        try {
            ff.connect();
            ff.writeConfig(cmds);
            ff.disconnect();
        }
        catch (Exception e) {
            System.out.println("Error while backup up: " + e.getMessage());
            LEDebug.getLog().logln(20, e);
            this.disconnect();
        }
        this.disconnect();
    }

    public void printHelpInfo() {
        super.printHelpInfo();
        System.out.println("[-f <filename>] : specifies a backup file, otherwise stdout.");
    }

    public void printUsage() {
        super.printUsage();
        System.out.println("[-f <filename>]");
    }
}

