/*
 * Decompiled with CFR 0.152.
 */
import COM.livingston.backend.LEDSSFlatFile;
import COM.livingston.backend.LEPMCommand;
import COM.livingston.util.LEAppInfo;
import COM.livingston.util.LEDebug;
import COM.livingston.util.LEDebugLog;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;

public class PMCommand
extends CLUtil {
    LEDebugLog m_log = LEDebug.getLog();

    public static void main(String[] args) {
        LEAppInfo.setFlag("-g", "20");
        LEAppInfo.setFlags(args);
        LEAppInfo.setAppName("pmcommand");
        LEAppInfo.setAppVersion("4.0");
        LEAppInfo.setIsApplet(false);
        try {
            String path = LEAppInfo.getUserAppDirPath("debuglog.txt");
            File debugFile = new File(path);
            FileOutputStream fostream = new FileOutputStream(debugFile);
            LEDebug.initialize(fostream);
        }
        catch (IOException e) {
            LEDebug.initialize(System.out);
            LEDebug.getLog().logln(20, e);
        }
        LEDebug.getLog().logln(20, LEAppInfo.getAppTitle());
        LEDebug.getLog().loglnTime(20);
        LEDebug.getLog().logln(20);
        PMCommand command = new PMCommand();
        command.processArgs(args);
        System.exit(0);
    }

    public void processArgs(String[] args) {
        super.processArgs(args);
        boolean host = false;
        boolean pass = false;
        boolean file = false;
        boolean user = false;
        int offset = 0;
        if (args.length < 2) {
            this.checkArgs();
            return;
        }
        if (LEAppInfo.getFlag("-h") != null) {
            host = true;
            offset += 2;
        }
        if (LEAppInfo.getFlag("-p") != null) {
            pass = true;
            offset += 2;
        }
        if (LEAppInfo.getFlag("-u") != null) {
            user = true;
            offset += 2;
        }
        if (LEAppInfo.getFlag("-f") != null) {
            file = true;
            offset += 2;
        }
        if (LEAppInfo.getFlag("-version") != null) {
            ++offset;
        }
        if (LEAppInfo.getFlag("-v") != null) {
            ++offset;
        }
        if (args.length == 2 && host && pass) {
            this.interactiveCommands();
            return;
        }
        if (LEAppInfo.getFlag("-v") != null && !file) {
            System.out.println("The -v flag is only valid when using a file.");
            return;
        }
        if (LEAppInfo.getFlag("-nostop") != null && !file) {
            System.out.println("The -nostop flag is only valid when using a file.");
            return;
        }
        if (LEAppInfo.getFlag("-noreboot") != null && !file) {
            System.out.println("The -noreboot flag is only valid when using a file.");
            return;
        }
        if (LEAppInfo.getFlag("-prompt") != null && !file) {
            System.out.println("The -prompt flag is only valid when using a file.");
            return;
        }
        if (LEAppInfo.getFlag("-version") != null) {
            this.printAppInfo();
        }
        if (args.length == 3) {
            if (LEAppInfo.getFlag("-version") != null) {
                this.interactiveCommands();
            } else {
                this.sendCommand(args[args.length - 1]);
            }
            return;
        }
        StringBuffer cmds_to_send = new StringBuffer(100);
        if (args.length > 3 && file) {
            this.sendCommand("");
            return;
        }
        if (offset != args.length) {
            int i = offset;
            while (i < args.length) {
                if (i != offset) {
                    cmds_to_send.append(" ");
                }
                cmds_to_send.append(args[i]);
                ++i;
            }
            this.sendCommand(cmds_to_send.toString());
            return;
        }
        this.interactiveCommands();
    }

    /*
     * Unable to fully structure code
     */
    public void sendCommand(String cmd) {
        block24: {
            block21: {
                dff = null;
                cmds = null;
                useFile = true;
                nostop = false;
                if (LEAppInfo.getFlag("-nostop") != null) {
                    nostop = true;
                }
                if ((inFile = LEAppInfo.getFlag("-f")) != null) ** GOTO lbl13
                if (cmd != null) {
                    useFile = false;
                } else {
                    System.out.println("Error: No command to send");
                    return;
lbl13:
                    // 1 sources

                    dff = new LEDSSFlatFile(inFile, 0);
                    try {
                        dff.connect();
                    }
                    catch (Exception e) {
                        System.out.println("Error reading file: " + e.getMessage());
                        LEDebug.getLog().logln(20, e);
                        return;
                    }
                    cmds = dff.getCommands();
                    try {
                        dff.disconnect();
                    }
                    catch (Exception e) {
                        System.out.println("Error closing file: " + e.getMessage());
                        LEDebug.getLog().logln(20, e);
                        this.disconnect();
                    }
                }
                this.connectToPortMaster();
                reader = null;
                response = null;
                try {
                    reader = new BufferedReader(new InputStreamReader(System.in));
                }
                catch (Exception e) {
                    LEDebug.getLog().logln(20, e);
                }
                if (!useFile) break block21;
                cmdlen = cmds.size();
                i = 0;
                while (i < cmdlen) {
                    block23: {
                        block22: {
                            cmd = (String)cmds.elementAt(i);
                            if (LEAppInfo.getFlag("-v") != null) {
                                System.out.println(cmd);
                            }
                            if (!LEPMCommand.IsReboot(cmd)) break block22;
                            if (LEAppInfo.getFlag("-noreboot") != null) break block23;
                            if (LEAppInfo.getFlag("-prompt") == null) break block22;
                            if (!(reader instanceof BufferedReader)) break block23;
                            System.out.println("");
                            System.out.print("A reboot has been encountered.");
                            System.out.println("  Do you wish to reboot your PortMaster?");
                            try {
                                response = reader.readLine().toLowerCase();
                            }
                            catch (Exception e) {
                                LEDebug.getLog().logln(20, e);
                            }
                            if (response != null && !response.startsWith("y")) break block23;
                        }
                        if (!(pmcommand = this.m_pm.execute(cmd)).getStatus()) {
                            System.out.println("Error in executing command - " + cmd + " : " + pmcommand.getResult());
                            if (!nostop) {
                                this.disconnect();
                            }
                        }
                        System.out.println(pmcommand.getResult());
                    }
                    ++i;
                }
                break block24;
            }
            pmcommand = this.m_pm.execute(cmd);
            if (!pmcommand.getStatus()) {
                System.out.println("Error in executing command - " + cmd + " : " + pmcommand.getResult());
            } else {
                System.out.println(pmcommand.getResult());
            }
        }
        this.disconnect();
    }

    public void interactiveCommands() {
        this.connectToPortMaster();
        if (this.m_pm == null) {
            this.disconnect();
        }
        System.out.println("Interactive mode:");
        try {
            InputStreamReader input = new InputStreamReader(System.in);
            BufferedReader reader = new BufferedReader(input);
            while (true) {
                System.out.print("Command> ");
                String cmd = reader.readLine();
                String lower = cmd.toLowerCase();
                if (lower.equals("exit") || lower.equals("quit")) {
                    System.out.println("\n Command Processor Exiting\n");
                    this.disconnect();
                }
                LEPMCommand pmcommand = this.m_pm.execute(cmd);
                System.out.println(pmcommand.getResult());
            }
        }
        catch (Exception e) {
            System.out.println("Error in reading command, exiting.");
            LEDebug.getLog().logln(20, e);
            this.disconnect();
            return;
        }
    }

    public void printHelpInfo() {
        super.printHelpInfo();
        System.out.println("[-f <filename>] : specifies a file listing commands to send to the PortMaster.");
        System.out.println("[-v] : specifies verbose output.  Valid only with -f.");
        System.out.println("[-nostop] : specifies that command errors do not stop execution.  Valid only with -f");
        System.out.println("[-noreboot] : specifies that reboot commands are ignored. Valid only with -f");
        System.out.println("[-prompt] : specifies that reboots will be prompted. Valid only with -f");
        System.out.println("[\"command\"] : specifies a single command to send to the PortMaster.");
        System.out.println("If neither a filename or command is specified, then an interactive shell is used.");
    }

    public void printUsage() {
        super.printUsage();
        System.out.println("[[-f <filename>] [-v] [-nostop] [-noreboot] [-prompt]] [\"command\"]");
    }

    void connectToPortMaster() {
        super.connectToPortMaster();
        if (this.m_pm != null) {
            if (!this.m_pm.getDSS().supportsEntities()) {
                System.out.println("This version of the ComOS does not provide suitable output.");
            } else {
                return;
            }
        }
    }
}

