/*
 * Decompiled with CFR 0.152.
 */
import COM.livingston.backend.LEDSSFlatFile;
import COM.livingston.model.LEFilter;
import COM.livingston.model.LEFilters;
import COM.livingston.util.LEAppInfo;
import COM.livingston.util.LEDebug;
import COM.livingston.util.LEDebugLog;
import COM.livingston.util.LEVector;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.StringTokenizer;

public class PMDumpFilter
extends CLUtil {
    private static final String TOC_FLAG = "-toc";
    private static final String FILTER_FLAG = "-filter";
    LEDebugLog m_log = LEDebug.getLog();
    LEFilters m_filters;
    LEVector m_names;
    LEVector m_selected = new LEVector();

    public static void main(String[] args) {
        LEAppInfo.setFlag("-g", "20");
        LEAppInfo.setFlags(args);
        LEAppInfo.setAppName("pmdumpfilter");
        LEAppInfo.setAppVersion("4.0");
        LEAppInfo.setIsApplet(false);
        try {
            String path = LEAppInfo.getUserAppDirPath("debuglog.txt");
            File debugFile = new File(path);
            FileOutputStream fostream = new FileOutputStream(debugFile);
            LEDebug.initialize(fostream);
        }
        catch (IOException e) {
            LEDebug.initialize(System.out);
            LEDebug.getLog().logln(20, e);
        }
        LEDebug.getLog().setLogLevel(20);
        LEDebug.getLog().logln(20, LEAppInfo.getAppTitle());
        LEDebug.getLog().loglnTime(20);
        LEDebug.getLog().logln(20);
        PMDumpFilter dump = new PMDumpFilter();
        dump.processArgs(args);
        System.exit(0);
    }

    public void processArgs(String[] args) {
        super.processArgs(args);
        if (args.length < 2) {
            this.checkArgs();
        } else {
            if (LEAppInfo.getFlag("-version") != null) {
                this.printAppInfo();
            }
            this.dumpFilters();
        }
    }

    public void dumpFilters() {
        this.connectToPortMaster();
        String filename = LEAppInfo.getFlag("-f");
        this.getFilters();
        if (LEAppInfo.getFlag(FILTER_FLAG) != null) {
            this.parseFilterSelection();
        }
        LEDSSFlatFile ff = new LEDSSFlatFile(filename, 1);
        int len = this.m_names.size();
        LEVector cmds = new LEVector();
        if (LEAppInfo.getFlag(TOC_FLAG) != null) {
            System.out.println("");
            System.out.println("Filter Table of Contents");
            System.out.println("");
            int i = 0;
            while (i < len) {
                System.out.println((String)this.m_names.elementAt(i));
                ++i;
            }
            System.out.println("");
        } else {
            try {
                ff.connect();
                if (this.m_selected.size() > 0) {
                    int selected_len = this.m_selected.size();
                    int i = 0;
                    while (i < selected_len) {
                        String selection = (String)this.m_selected.elementAt(i);
                        int j = 0;
                        while (j < len) {
                            LEFilter filter;
                            cmds.removeAllElements();
                            String name = (String)this.m_names.elementAt(j);
                            if (name.equals(selection) && (filter = (LEFilter)this.m_filters.get(name)) instanceof LEFilter && filter.getCommands(cmds)) {
                                ff.writeConfig(cmds);
                            }
                            ++j;
                        }
                        ++i;
                    }
                } else if (this.m_filters.getCommands(cmds)) {
                    ff.writeConfig(cmds);
                } else {
                    System.out.println("Error in dumping filters.");
                }
                ff.disconnect();
            }
            catch (Exception e) {
                System.out.println("Error while dumping filters " + e.getMessage());
                LEDebug.getLog().logln(20, e);
                return;
            }
        }
    }

    public void printUsage() {
        super.printUsage();
        System.out.println("[-f <file_name>] [-toc] [-filter \"filters\"] ");
    }

    public void printHelpInfo() {
        super.printHelpInfo();
        System.out.println("[-f <file_name>] : specifies a filename to save the output.");
        System.out.println("[-toc] : specifies to print the table of contents.");
        System.out.println("[-filter \"filters\"] : specifies the filters to write out.");
        System.out.println("The filters are specified as a comma separated list (\"filter1,filter2\")");
        System.out.println("If the -filter flag is not specified, then all filters are written out.");
    }

    private void getFilters() {
        this.m_filters = (LEFilters)this.m_pm.get("filter");
        if (this.m_filters instanceof LEFilters) {
            this.m_names = this.m_filters.getKeys();
        }
    }

    private void parseFilterSelection() {
        String filter_sel = LEAppInfo.getFlag(FILTER_FLAG);
        StringTokenizer comma_tokenizer = new StringTokenizer(filter_sel, ",");
        while (comma_tokenizer.hasMoreTokens()) {
            String filter = comma_tokenizer.nextToken();
            this.m_selected.add(filter);
        }
    }
}

