/*
 * Decompiled with CFR 0.152.
 */
import COM.livingston.backend.LEDSSPMUpgrade;
import COM.livingston.backend.LEDSSPortMaster;
import COM.livingston.util.LEAppInfo;
import COM.livingston.util.LEDebug;
import COM.livingston.util.LEDebugLog;
import COM.livingston.util.LEObservable;
import COM.livingston.util.LEObserver;
import COM.livingston.util.LEStatusManager;
import COM.livingston.util.LEThreadStatus;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.DateFormat;
import java.util.Date;

public class PMUpgrade
extends CLUtil
implements Runnable,
LEObserver {
    private static final int DOT_MAX = 10;
    Thread m_thread = new Thread((Runnable)this, "PMUpgrade");
    long m_wait_time;
    int m_dotcount;
    LEDebugLog m_log = LEDebug.getLog();

    public static void main(String[] args) {
        LEAppInfo.setFlag("-g", "20");
        LEAppInfo.setFlags(args);
        LEAppInfo.setAppName("PMUpgrade");
        LEAppInfo.setAppVersion("4.0");
        LEAppInfo.setIsApplet(false);
        try {
            String path = LEAppInfo.getUserAppDirPath("debuglog.txt");
            File debugFile = new File(path);
            FileOutputStream fostream = new FileOutputStream(debugFile);
            LEDebug.initialize(fostream);
        }
        catch (IOException e) {
            LEDebug.initialize(System.out);
            LEDebug.getLog().logln(20, e);
        }
        LEDebug.getLog().logln(20, LEAppInfo.getAppTitle());
        LEDebug.getLog().loglnTime(20);
        LEDebug.getLog().logln(20);
        PMUpgrade upgrade = new PMUpgrade();
        upgrade.processArgs(args);
    }

    public void processArgs(String[] args) {
        super.processArgs(args);
        boolean do_upgrade = true;
        if (args.length < 4) {
            this.checkArgs();
        } else {
            if (LEAppInfo.getFlag("-version") != null) {
                this.printAppInfo();
            }
            if (LEAppInfo.getFlag("-at") != null) {
                int pos = -1;
                int i = 0;
                while (i < args.length) {
                    if (args[i].equals("-at")) {
                        pos = i;
                        break;
                    }
                    ++i;
                }
                if (pos > 0) {
                    StringBuffer starttime = new StringBuffer(50);
                    int j = pos + 1;
                    while (j < args.length) {
                        if (j > pos + 1) {
                            starttime.append(" ");
                        }
                        starttime.append(args[j]);
                        ++j;
                    }
                    if (starttime.length() > 1) {
                        do_upgrade = this.processTime(starttime.toString());
                    } else {
                        this.printBadTimeMsg();
                        do_upgrade = false;
                    }
                } else {
                    this.printBadTimeMsg();
                    do_upgrade = false;
                }
            }
            if (do_upgrade) {
                this.startUpgrade();
            }
        }
    }

    public void startUpgrade() {
        this.m_thread.start();
    }

    public boolean processTime(String time) {
        int pos = -1;
        DateFormat dateformat = DateFormat.getDateTimeInstance(3, 3);
        Date startdate = null;
        try {
            startdate = dateformat.parse(time);
        }
        catch (Exception e) {
            System.out.println("Error in parsing upgrade time. (Example: \"3/4/7 12:00 AM\")");
            LEDebug.getLog().logln(20, e);
            return false;
        }
        Date currentdate = new Date();
        long currenttime = currentdate.getTime();
        long starttime = startdate.getTime();
        if (starttime < currenttime) {
            System.out.println("Upgrade time is earlier than the current time");
            return false;
        }
        this.m_wait_time = starttime - currenttime;
        return true;
    }

    private void upgradePM() {
        LEDSSPortMaster dss = null;
        LEDSSPMUpgrade pmupgrade = null;
        String inFile = LEAppInfo.getFlag("-f");
        File upgradeFile = new File(inFile);
        if (!upgradeFile.exists()) {
            System.out.println("File not found: " + inFile);
            return;
        }
        this.connectToPortMaster();
        dss = this.m_pm.getDSS();
        try {
            pmupgrade = new LEDSSPMUpgrade(upgradeFile, dss);
        }
        catch (Exception e) {
            System.out.println("File not found: " + e.getMessage());
            LEDebug.getLog().logln(20, e);
            return;
        }
        try {
            LEStatusManager status = pmupgrade.getStatusManager();
            status.addObserver(this);
            pmupgrade.doUpgrade();
            System.out.println("");
            status.deleteObserver(this);
        }
        catch (Exception e) {
            System.out.println("Error in upgrading, DO NOT REBOOT: " + e.getMessage());
            LEDebug.getLog().logln(20, e);
            return;
        }
        if (LEAppInfo.getFlag("-r") != null) {
            System.out.println("Rebooting PM, this may take up to a minute.");
            dss.execute("reboot");
            System.out.println("Upgrade successful.");
        } else {
            System.out.println("Upgrade successful, you need to reboot.");
        }
    }

    public void printUsage() {
        super.printUsage();
        System.out.println("[-r] -f <filename> [-at \"mon/day/year hour:min AM/PM\"] ");
    }

    public void printHelpInfo() {
        super.printHelpInfo();
        System.out.println("[-r] : reboots the PortMaster after a sucessful upgrade.");
        System.out.println("-f <filename> : specifies the upgrade file.");
        System.out.println("[-at \"mon/day/year hour:min AM/PM\"] : specifies the time to start the upgrade.");
    }

    public void run() {
        try {
            Thread.sleep(this.m_wait_time);
            this.upgradePM();
        }
        catch (Exception exception) {}
        this.disconnect();
    }

    public void update(LEObservable obs, Object arg) {
        if (arg instanceof LEThreadStatus) {
            ++this.m_dotcount;
            if (this.m_dotcount > 10) {
                this.m_dotcount = 0;
                System.out.print(".");
            }
        }
    }

    public void printBadTimeMsg() {
        System.out.println("The -at flag exists without an associated time. ");
        if (!LEAppInfo.isUnix()) {
            System.out.print("It is possible that the number of entered arguments ");
            System.out.print("exceeds the limit of your command prompt.");
            System.out.println("");
        }
    }
}

