/*
 * Decompiled with CFR 0.152.
 */
package com.lucent.ra.nms.backend;

import com.lucent.ra.nms.backend.LEDSSException;
import com.lucent.ra.nms.backend.LEDSSPortMaster_I;
import com.lucent.ra.nms.backend.LEMonitorFacility_R;
import com.lucent.ra.nms.backend.LEMonitorSetting;
import com.lucent.ra.nms.util.LEDebug;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.Enumeration;
import java.util.Hashtable;

public class LEMonitorFacility_RI
extends UnicastRemoteObject
implements LEMonitorFacility_R {
    LEDSSPortMaster_I m_dss;
    Hashtable m_monitors = new Hashtable();
    Hashtable m_deltas = new Hashtable();

    public static int GetMonitorTime(int n) {
        int n2 = 0;
        switch (n) {
            case 0x330000: {
                n2 = 5000;
                break;
            }
            case 0x120000: {
                n2 = 30000;
                break;
            }
            case 0x360000: {
                n2 = 30000;
                break;
            }
            case 0x370000: {
                n2 = 30000;
                break;
            }
            case 131072: {
                n2 = 30000;
                break;
            }
            case 0x2D0000: {
                n2 = 5000;
                break;
            }
            case 0x2C0000: {
                n2 = 5000;
                break;
            }
            case 196608: {
                n2 = 30000;
                break;
            }
            case 0x340000: {
                n2 = 30000;
                break;
            }
            case 983040: {
                n2 = 30000;
                break;
            }
            case 0x2E0000: {
                n2 = 5000;
                break;
            }
            case 65536: {
                n2 = 30000;
                break;
            }
            default: {
                n2 = 30000;
            }
        }
        return n2;
    }

    public static int GetDeltaTime(int n) {
        int n2 = 0;
        switch (n) {
            case 0x120000: {
                n2 = 1000;
                break;
            }
            case 131072: {
                n2 = 1000;
                break;
            }
            case 196608: {
                n2 = 1000;
                break;
            }
            case 65536: {
                n2 = 1000;
                break;
            }
        }
        return n2;
    }

    public LEMonitorFacility_RI(LEDSSPortMaster_I lEDSSPortMaster_I) throws RemoteException {
        this.m_dss = lEDSSPortMaster_I;
    }

    public synchronized boolean startMonitor(int n, int n2) throws RemoteException {
        LEMonitorSetting lEMonitorSetting;
        boolean bl = true;
        Integer n3 = new Integer(n);
        Integer n4 = new Integer(n2);
        Hashtable<Integer, LEMonitorSetting> hashtable = (Hashtable<Integer, LEMonitorSetting>)this.m_monitors.get(n3);
        if (hashtable == null) {
            hashtable = new Hashtable<Integer, LEMonitorSetting>();
            this.m_monitors.put(n3, hashtable);
        }
        if ((lEMonitorSetting = (LEMonitorSetting)hashtable.get(n4)) == null) {
            int n5 = LEMonitorFacility_RI.GetMonitorTime(n);
            if (n5 > 0) {
                try {
                    long l = n2 == -1 ? this.m_dss.monitor(n, n5) : this.m_dss.monitor(n, n5, n2);
                    lEMonitorSetting = new LEMonitorSetting(l);
                    hashtable.put(n4, lEMonitorSetting);
                }
                catch (LEDSSException lEDSSException) {
                    bl = false;
                }
                catch (Exception exception) {
                    LEDebug.getLog().logln(20, exception);
                    bl = false;
                }
            }
        } else {
            lEMonitorSetting.increment();
        }
        return bl;
    }

    public synchronized boolean startMonitor(int n, String string) throws RemoteException {
        LEMonitorSetting lEMonitorSetting;
        boolean bl = true;
        Integer n2 = new Integer(n);
        Hashtable<String, LEMonitorSetting> hashtable = (Hashtable<String, LEMonitorSetting>)this.m_monitors.get(n2);
        if (hashtable == null) {
            hashtable = new Hashtable<String, LEMonitorSetting>();
            this.m_monitors.put(n2, hashtable);
        }
        if ((lEMonitorSetting = (LEMonitorSetting)hashtable.get(string)) == null) {
            int n3 = LEMonitorFacility_RI.GetMonitorTime(n);
            if (n3 > 0) {
                try {
                    long l = string == "" ? this.m_dss.monitor(n, n3) : this.m_dss.monitor(n, n3, string);
                    lEMonitorSetting = new LEMonitorSetting(l);
                    hashtable.put(string, lEMonitorSetting);
                }
                catch (LEDSSException lEDSSException) {
                    bl = false;
                }
                catch (Exception exception) {
                    LEDebug.getLog().logln(20, exception);
                    bl = false;
                }
            }
        } else {
            lEMonitorSetting.increment();
        }
        return bl;
    }

    public synchronized boolean startDelta(int n, int n2) throws RemoteException {
        LEMonitorSetting lEMonitorSetting;
        boolean bl = true;
        Integer n3 = new Integer(n);
        Integer n4 = new Integer(n2);
        Hashtable<Integer, LEMonitorSetting> hashtable = (Hashtable<Integer, LEMonitorSetting>)this.m_deltas.get(n3);
        if (hashtable == null) {
            hashtable = new Hashtable<Integer, LEMonitorSetting>();
            this.m_deltas.put(n3, hashtable);
        }
        if ((lEMonitorSetting = (LEMonitorSetting)hashtable.get(n4)) == null) {
            int n5 = LEMonitorFacility_RI.GetDeltaTime(n);
            if (n5 > 0) {
                try {
                    long l = n2 == -1 ? this.m_dss.delta(n, n5) : this.m_dss.delta(n, n5, n2);
                    lEMonitorSetting = new LEMonitorSetting(l);
                    hashtable.put(n4, lEMonitorSetting);
                }
                catch (LEDSSException lEDSSException) {
                    bl = false;
                }
                catch (Exception exception) {
                    LEDebug.getLog().logln(20, exception);
                    bl = false;
                }
            }
        } else {
            lEMonitorSetting.increment();
        }
        return bl;
    }

    public synchronized void stopMonitor(int n, int n2) throws RemoteException {
        Integer n3 = new Integer(n);
        Integer n4 = new Integer(n2);
        Hashtable hashtable = (Hashtable)this.m_monitors.get(n3);
        if (hashtable == null) {
            return;
        }
        LEMonitorSetting lEMonitorSetting = (LEMonitorSetting)hashtable.get(n4);
        if (lEMonitorSetting == null) {
            return;
        }
        if (lEMonitorSetting.decrement() == 0) {
            this.stopMonitor(lEMonitorSetting);
            hashtable.remove(n4);
        }
    }

    public synchronized void stopMonitor(int n, String string) throws RemoteException {
        Integer n2 = new Integer(n);
        Hashtable hashtable = (Hashtable)this.m_monitors.get(n2);
        if (hashtable == null) {
            return;
        }
        LEMonitorSetting lEMonitorSetting = (LEMonitorSetting)hashtable.get(string);
        if (lEMonitorSetting == null) {
            return;
        }
        if (lEMonitorSetting.decrement() == 0) {
            this.stopMonitor(lEMonitorSetting);
            hashtable.remove(string);
        }
    }

    public synchronized void stopDelta(int n, int n2) throws RemoteException {
        Integer n3 = new Integer(n);
        Integer n4 = new Integer(n2);
        Hashtable hashtable = (Hashtable)this.m_deltas.get(n3);
        if (hashtable == null) {
            return;
        }
        LEMonitorSetting lEMonitorSetting = (LEMonitorSetting)hashtable.get(n4);
        if (lEMonitorSetting == null) {
            return;
        }
        if (lEMonitorSetting.decrement() == 0) {
            this.stopDelta(lEMonitorSetting);
            hashtable.remove(n4);
        }
    }

    synchronized void shutdown() {
        LEMonitorSetting lEMonitorSetting;
        Enumeration enumeration;
        Hashtable hashtable;
        Enumeration enumeration2 = this.m_monitors.elements();
        while (enumeration2.hasMoreElements()) {
            hashtable = (Hashtable)enumeration2.nextElement();
            enumeration = hashtable.elements();
            while (enumeration.hasMoreElements()) {
                lEMonitorSetting = (LEMonitorSetting)enumeration.nextElement();
                this.stopMonitor(lEMonitorSetting);
            }
            hashtable.clear();
        }
        this.m_monitors.clear();
        enumeration2 = this.m_deltas.elements();
        while (enumeration2.hasMoreElements()) {
            hashtable = (Hashtable)enumeration2.nextElement();
            enumeration = hashtable.elements();
            while (enumeration.hasMoreElements()) {
                lEMonitorSetting = (LEMonitorSetting)enumeration.nextElement();
                this.stopDelta(lEMonitorSetting);
            }
            hashtable.clear();
        }
        this.m_deltas.clear();
    }

    void stopMonitor(LEMonitorSetting lEMonitorSetting) {
        long l = lEMonitorSetting.getRequestID();
        try {
            if (this.m_dss.isConnected()) {
                this.m_dss.killMonitor(l);
                return;
            }
        }
        catch (LEDSSException lEDSSException) {
            return;
        }
        catch (Exception exception) {
            LEDebug.getLog().logln(20, exception);
        }
    }

    void stopDelta(LEMonitorSetting lEMonitorSetting) {
        long l = lEMonitorSetting.getRequestID();
        try {
            if (this.m_dss.isConnected()) {
                this.m_dss.killDelta(l);
                return;
            }
        }
        catch (LEDSSException lEDSSException) {
            return;
        }
        catch (Exception exception) {
            LEDebug.getLog().logln(20, exception);
        }
    }
}

