/*
 * Decompiled with CFR 0.152.
 */
package com.lucent.ra.nms.model;

import com.lucent.ra.nms.amf.LEAMFactory;
import com.lucent.ra.nms.amf.LEAMManager_RI;
import com.lucent.ra.nms.amf.LEAMObserver;
import com.lucent.ra.nms.backend.LEAlarmFacility_R;
import com.lucent.ra.nms.backend.LEConnectionManager;
import com.lucent.ra.nms.backend.LEDSS;
import com.lucent.ra.nms.backend.LEDSSException;
import com.lucent.ra.nms.backend.LEDSSPortMaster;
import com.lucent.ra.nms.backend.LEDebugFacility_R;
import com.lucent.ra.nms.backend.LEMonitorFacility_R;
import com.lucent.ra.nms.backend.LEPMCommand;
import com.lucent.ra.nms.backend.LEStatusFactory;
import com.lucent.ra.nms.backend.LEStatusMessage;
import com.lucent.ra.nms.model.LEBoard;
import com.lucent.ra.nms.model.LEBoards;
import com.lucent.ra.nms.model.LEConfig;
import com.lucent.ra.nms.model.LEConnectionFacade;
import com.lucent.ra.nms.model.LEPMEntityParser;
import com.lucent.ra.nms.model.LEPMOldParser;
import com.lucent.ra.nms.model.LEPortMaster;
import com.lucent.ra.nms.util.LEDebug;
import com.lucent.ra.nms.util.LEStatusManager;
import com.lucent.ra.nms.util.LEVector;
import java.rmi.RemoteException;

public class LEPMConnectionFacade
implements LEConnectionFacade,
LEAMObserver,
Runnable {
    public static final int NO_BOARD = -1;
    LEConnectionManager m_cm;
    LEDSSPortMaster m_dss;
    LEPortMaster m_pm;
    Thread m_thread;
    LEVector m_toc;
    String m_host;
    String m_user;
    String m_pw;
    String m_id;

    public LEPMConnectionFacade(LEConnectionManager lEConnectionManager, LEDSSPortMaster lEDSSPortMaster, LEPortMaster lEPortMaster) {
        this.m_cm = lEConnectionManager;
        this.m_dss = lEDSSPortMaster;
        this.m_pm = lEPortMaster;
        this.m_host = this.m_dss.getHostname();
        this.m_user = this.m_dss.getUsername();
        this.m_pw = this.m_dss.getPassword();
        this.m_id = this.m_dss.getResourceID();
        LEStatusFactory.GetFactory().addObserver(lEConnectionManager.getResourceID(), this);
    }

    public void update(LEAMFactory lEAMFactory, String string, Object object) {
        if (object instanceof LEStatusMessage) {
            LEStatusMessage lEStatusMessage = (LEStatusMessage)object;
            int n = lEStatusMessage.getStatus();
            if (n == 1) {
                this.m_cm = (LEConnectionManager)lEStatusMessage.getData();
                try {
                    this.m_dss = this.m_cm.connectToPM(this.m_host, this.m_user, this.m_pw);
                    return;
                }
                catch (Exception exception) {
                    LEDebug.getLog().logln(20, exception);
                    return;
                }
            }
            if (n == 2) {
                this.m_dss = null;
            }
        }
    }

    public LEDSS getDSS() {
        return this.m_dss;
    }

    public String getResourceID() {
        return this.m_id;
    }

    public String getDescription() {
        return this.m_host;
    }

    public String getHostname() {
        return this.m_host;
    }

    public String getUsername() {
        return this.m_user;
    }

    public String getPassword() {
        return this.m_pw;
    }

    public boolean getConfig(String string) {
        return this.getConfig(string, null);
    }

    public boolean getConfig(String string, String string2) {
        if (this.m_dss == null) {
            return false;
        }
        boolean bl = false;
        if (string2 == null) {
            if (this.m_dss.supportsEntities() && (!string.equals("2162688") || this.globalEntityOkay())) {
                bl = LEPMEntityParser.Parse(string, this.m_dss, this.m_pm);
            }
            if (!bl) {
                bl = LEPMOldParser.Parse(string, this.m_dss, this.m_pm);
            }
        } else if (this.m_dss.supportsEntities()) {
            bl = LEPMEntityParser.Parse(string, string2, this.m_dss, this.m_pm);
        }
        return bl;
    }

    public LEVector getTOC(int n) {
        if (this.m_dss == null) {
            return null;
        }
        return this.m_dss.getTOC(n);
    }

    public boolean getUserPasswords() {
        if (this.m_dss == null) {
            return false;
        }
        if (!this.supports(0x310000)) {
            return false;
        }
        LEConfig lEConfig = (LEConfig)this.m_pm.get("1835008");
        if (lEConfig == null) {
            return true;
        }
        String string = Integer.toString(0x310000);
        return LEPMEntityParser.Parse(this.m_dss, lEConfig, string, string);
    }

    public boolean getSecrets() {
        if (this.m_dss == null) {
            return false;
        }
        if (!this.supports(0x320000)) {
            return false;
        }
        this.m_pm.get("2228224");
        this.m_pm.get("1507328");
        String string = Integer.toString(0x320000);
        return LEPMEntityParser.Parse(this.m_dss, this.m_pm, string, string);
    }

    public boolean supportsEntities() {
        if (this.m_dss == null) {
            return false;
        }
        return this.m_dss.supportsEntities();
    }

    public boolean supports(int n) {
        if (this.isConnected()) {
            if (this.m_toc == null) {
                this.m_toc = this.getTOC(0x1D0000);
            }
            if (this.m_toc != null && this.m_toc.contains(Integer.toString(n))) {
                return true;
            }
        }
        return false;
    }

    public boolean isUpgrading() {
        if (this.m_dss == null) {
            return false;
        }
        return this.m_dss.upgrading();
    }

    public boolean isEstablished() {
        return this.m_cm.isConnected();
    }

    public boolean isConnected() {
        return this.m_cm.isConnected() && this.m_dss != null && this.m_dss.isConnected();
    }

    public void disconnect() {
        if (this.m_dss != null) {
            LEStatusFactory.GetFactory().deleteObserver(this.m_cm.getResourceID(), this);
            this.m_cm.disconnectFrom(this.m_dss);
            this.m_dss = null;
        }
    }

    public synchronized boolean reconnect() {
        if (this.m_dss == null) {
            LEStatusFactory.GetFactory().addObserver(this.m_cm.getResourceID(), this);
            try {
                this.m_dss = this.m_cm.connectToPM(this.m_host, this.m_user, this.m_pw);
            }
            catch (LEDSSException lEDSSException) {
            }
            catch (Exception exception) {
                LEDebug.getLog().logln(20, exception);
            }
        } else if (!this.m_dss.isConnected()) {
            LEAMManager_RI.GetManager().addID(this.m_cm.getAMRouter(), this.m_id);
            if (!this.m_dss.reconnect()) {
                this.m_dss = null;
                LEAMManager_RI.GetManager().removeID(this.m_cm.getAMRouter(), this.m_id);
            }
        }
        return this.m_dss != null;
    }

    public LEPMCommand execute(String string) {
        String string2;
        if (this.m_dss == null) {
            return null;
        }
        LEStatusManager.SetStatus(string);
        LEPMCommand lEPMCommand = this.m_dss.execute(string);
        if (this.m_dss != null) {
            this.m_pw = this.m_dss.getPassword();
        }
        if (LEPMCommand.IsReboot(string) && (string2 = this.m_pm.getHardwareType()) != null && (string2.equals("PM-4") || string2.equals("1000"))) {
            this.checkForBoards();
        }
        if (LEPMCommand.IsPowerOff(string)) {
            try {
                Thread.currentThread();
                Thread.sleep(1000L);
            }
            catch (Exception exception) {
                LEDebug.getLog().logln(20, exception);
            }
        }
        if (LEPMCommand.IsPowerOn(string) && this.m_thread == null) {
            this.m_thread = new Thread(this);
            this.m_thread.start();
        }
        return lEPMCommand;
    }

    public boolean startMonitor(int n, int n2) {
        if (this.m_dss == null) {
            return false;
        }
        boolean bl = false;
        try {
            LEMonitorFacility_R lEMonitorFacility_R = this.m_dss.getMonitorFacility();
            if (lEMonitorFacility_R != null) {
                bl = lEMonitorFacility_R.startMonitor(n, n2);
            }
        }
        catch (RemoteException remoteException) {
            this.handleRemoteException(remoteException);
        }
        return bl;
    }

    public boolean startMonitor(int n, String string) {
        if (this.m_dss == null) {
            return false;
        }
        boolean bl = false;
        try {
            LEMonitorFacility_R lEMonitorFacility_R = this.m_dss.getMonitorFacility();
            if (lEMonitorFacility_R != null) {
                bl = lEMonitorFacility_R.startMonitor(n, string);
            }
        }
        catch (RemoteException remoteException) {
            this.handleRemoteException(remoteException);
        }
        return bl;
    }

    public void stopMonitor(int n, int n2) {
        if (this.m_dss == null) {
            return;
        }
        try {
            LEMonitorFacility_R lEMonitorFacility_R = this.m_dss.getMonitorFacility();
            if (lEMonitorFacility_R != null) {
                lEMonitorFacility_R.stopMonitor(n, n2);
                return;
            }
        }
        catch (RemoteException remoteException) {
            this.handleRemoteException(remoteException);
        }
    }

    public void stopMonitor(int n, String string) {
        if (this.m_dss == null) {
            return;
        }
        try {
            LEMonitorFacility_R lEMonitorFacility_R = this.m_dss.getMonitorFacility();
            if (lEMonitorFacility_R != null) {
                lEMonitorFacility_R.stopMonitor(n, string);
                return;
            }
        }
        catch (RemoteException remoteException) {
            this.handleRemoteException(remoteException);
        }
    }

    public boolean startDelta(int n, int n2) {
        if (this.m_dss == null) {
            return false;
        }
        boolean bl = false;
        try {
            LEMonitorFacility_R lEMonitorFacility_R = this.m_dss.getMonitorFacility();
            if (lEMonitorFacility_R != null) {
                bl = lEMonitorFacility_R.startDelta(n, n2);
            }
        }
        catch (RemoteException remoteException) {
            this.handleRemoteException(remoteException);
        }
        return bl;
    }

    public void stopDelta(int n, int n2) {
        if (this.m_dss == null) {
            return;
        }
        try {
            LEMonitorFacility_R lEMonitorFacility_R = this.m_dss.getMonitorFacility();
            if (lEMonitorFacility_R != null) {
                lEMonitorFacility_R.stopDelta(n, n2);
                return;
            }
        }
        catch (RemoteException remoteException) {
            this.handleRemoteException(remoteException);
        }
    }

    public boolean startDebug(int n, int n2, int n3) {
        if (this.m_dss == null) {
            return false;
        }
        boolean bl = false;
        try {
            LEDebugFacility_R lEDebugFacility_R = this.m_dss.getDebugFacility();
            if (lEDebugFacility_R != null) {
                bl = lEDebugFacility_R.startDebug(n, n2, n3);
            }
        }
        catch (RemoteException remoteException) {
            this.handleRemoteException(remoteException);
        }
        return bl;
    }

    public void stopDebug(int n, int n2, int n3) {
        if (this.m_dss == null) {
            return;
        }
        try {
            LEDebugFacility_R lEDebugFacility_R = this.m_dss.getDebugFacility();
            if (lEDebugFacility_R != null) {
                lEDebugFacility_R.stopDebug(n, n2, n3);
                return;
            }
        }
        catch (RemoteException remoteException) {
            this.handleRemoteException(remoteException);
        }
    }

    public LEVector getAlarms() {
        if (this.m_dss == null) {
            return null;
        }
        LEVector lEVector = null;
        try {
            LEAlarmFacility_R lEAlarmFacility_R = this.m_dss.getAlarmFacility();
            if (lEAlarmFacility_R != null) {
                lEVector = lEAlarmFacility_R.getAlarms();
            }
        }
        catch (RemoteException remoteException) {
            this.handleRemoteException(remoteException);
        }
        return lEVector;
    }

    public boolean clearAlarm(String string) {
        if (this.m_dss == null) {
            return false;
        }
        boolean bl = false;
        try {
            LEAlarmFacility_R lEAlarmFacility_R = this.m_dss.getAlarmFacility();
            if (lEAlarmFacility_R != null) {
                bl = lEAlarmFacility_R.clearAlarm(string);
            }
        }
        catch (RemoteException remoteException) {
            this.handleRemoteException(remoteException);
        }
        return bl;
    }

    public void run() {
        try {
            this.checkForBoards();
        }
        catch (Exception exception) {
            LEDebug.getLog().logln(20, exception);
        }
        this.m_thread = null;
    }

    void checkForBoards() {
        LEBoards lEBoards = (LEBoards)this.m_pm.get("2555904");
        if (lEBoards == null) {
            return;
        }
        LEVector lEVector = lEBoards.getKeys();
        int n = lEVector.size();
        boolean bl = true;
        while (bl) {
            lEBoards.refresh();
            bl = false;
            int n2 = 0;
            while (!bl && n2 < n) {
                LEBoard lEBoard = (LEBoard)lEBoards.get((String)lEVector.elementAt(n2));
                if (lEBoard != null && lEBoard.isPoweringUp()) {
                    bl = true;
                }
                ++n2;
            }
            if (!bl) continue;
            try {
                Thread.currentThread();
                Thread.sleep(5000L);
            }
            catch (Exception exception) {
                LEDebug.getLog().logln(20, exception);
            }
        }
    }

    boolean globalEntityOkay() {
        boolean bl;
        block4: {
            bl = true;
            String string = this.m_pm.getSoftwareVersion();
            if (!string.startsWith("3.8b")) break block4;
            String string2 = string.substring(4);
            int n = string2.indexOf(47);
            if (n > -1) {
                string2 = string2.substring(0, n);
            }
            try {
                int n2 = Integer.parseInt(string2);
                if (n2 < 18) {
                    bl = false;
                }
            }
            catch (NumberFormatException numberFormatException) {
                LEDebug.getLog().logln(20, numberFormatException);
            }
        }
        return bl;
    }

    void handleRemoteException(RemoteException remoteException) {
        LEDebug.getLog().logln(20, remoteException);
        this.m_dss = null;
        LEStatusMessage lEStatusMessage = new LEStatusMessage(2);
        LEAMManager_RI.Process(this.m_cm.getResourceID(), "STATUS", lEStatusMessage);
    }
}

