/*
 * Decompiled with CFR 0.152.
 */
import COM.livingston.model.LEPortMaster;
import COM.livingston.util.LEAppInfo;
import COM.livingston.util.LEDebug;

public abstract class CLUtil {
    static final String HELP_FLAG = "-help";
    static final String BUILD_FLAG = "-version";
    LEPortMaster m_pm;
    boolean m_done = false;

    void printAppInfo() {
        System.out.print(LEAppInfo.getAppName());
        System.out.print(" version: " + LEAppInfo.getAppVersion());
        System.out.println("  build date: " + LEAppInfo.GetBuildDate());
        this.m_done = true;
    }

    void printUsage() {
        System.out.println("");
        System.out.print("usage: " + LEAppInfo.getAppName() + " <host> <password> [-u <username>] [-version] [-help] ");
        this.m_done = true;
    }

    void printHelpInfo() {
        this.printUsage();
        System.out.println("");
        System.out.println("<hostname> : specifies the PortMaster.");
        System.out.println("<password> : specifies the administrator password for the PortMaster.");
        System.out.println("[-u <username>] : specifies a username other than !root.");
        System.out.println("[-version] : prints out the version number and build date.");
        System.out.println("[-help] : prints out this help message.");
        this.m_done = true;
    }

    void processArgs(String[] stringArray) {
        if (stringArray.length > 1) {
            String string = LEAppInfo.getFlag("-h");
            String string2 = LEAppInfo.getFlag("-p");
            if (string == null && string2 == null) {
                String string3 = stringArray[0];
                if (!string3.startsWith("-")) {
                    LEAppInfo.setFlag("-h", stringArray[0]);
                    LEAppInfo.setFlag("-p", stringArray[1]);
                    return;
                }
            } else {
                if (string != null && string2 != null) {
                    return;
                }
                System.out.print("The host and password arguments must either ");
                System.out.print("have both the -h and -p flags or not have ");
                System.out.println("either of them.");
                System.exit(0);
            }
        }
    }

    void checkArgs() {
        if (LEAppInfo.getFlag(BUILD_FLAG) != null) {
            this.printAppInfo();
            return;
        }
        if (LEAppInfo.getFlag(HELP_FLAG) != null) {
            this.printHelpInfo();
            return;
        }
        this.printUsage();
    }

    String getHost() {
        return LEAppInfo.getFlag("-h");
    }

    String getPassword() {
        return LEAppInfo.getFlag("-p");
    }

    String getUsername() {
        String string = LEAppInfo.getFlag("-u");
        if (string == null) {
            string = new String("!root");
        }
        return string;
    }

    void connectToPortMaster() {
        try {
            this.m_pm = new LEPortMaster(this.getHost(), this.getUsername(), this.getPassword());
        }
        catch (Exception exception) {
            System.out.println("Connect failed: " + exception.getMessage());
            LEDebug.getLog().logln(20, exception);
        }
        if (this.m_pm == null) {
            System.out.println("Could not connect to " + this.getHost());
            this.disconnect();
        }
    }

    void disconnect() {
        this.disconnect(0);
    }

    void disconnect(int n) {
        if (this.m_pm != null) {
            this.m_pm.disconnect();
        }
        System.exit(n);
    }
}

