/*
 * Decompiled with CFR 0.152.
 */
import COM.livingston.model.LERadiusConverter;
import COM.livingston.model.LEUsers;
import COM.livingston.util.LEAppInfo;
import COM.livingston.util.LEDebug;
import COM.livingston.util.LEDebugLog;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;

public class PMRadiusRec
extends CLUtil {
    private static final String NOPASSWORD_FLAG = "-nopass";
    LEDebugLog m_log = LEDebug.getLog();
    boolean m_secrets;

    public static void main(String[] stringArray) {
        Object object;
        LEAppInfo.setFlag("-g", "20");
        LEAppInfo.setFlags(stringArray);
        LEAppInfo.setAppName("pmradiusrec");
        LEAppInfo.setAppVersion("4.1a2");
        LEAppInfo.setIsApplet(false);
        try {
            object = LEAppInfo.getUserAppDirPath("debuglog.txt");
            File file = new File((String)object);
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            LEDebug.initialize(fileOutputStream);
        }
        catch (IOException iOException) {
            LEDebug.initialize(System.out);
            LEDebug.getLog().logln(20, iOException);
        }
        LEDebug.getLog().setLogLevel(20);
        LEDebug.getLog().logln(20, LEAppInfo.getAppTitle());
        LEDebug.getLog().loglnTime(20);
        LEDebug.getLog().logln(20);
        object = new PMRadiusRec();
        ((PMRadiusRec)object).processArgs(stringArray);
        System.exit(0);
    }

    public void processArgs(String[] stringArray) {
        super.processArgs(stringArray);
        if (stringArray.length < 4) {
            this.checkArgs();
            return;
        }
        this.readPass();
    }

    public void readPass() {
        this.connectToPortMaster();
        LEUsers lEUsers = (LEUsers)this.m_pm.get("1835008");
        String string = LEAppInfo.getFlag(NOPASSWORD_FLAG);
        if (string == null && this.m_pm.supports(0x320000)) {
            this.m_secrets = true;
            this.m_pm.getUserPasswords();
        } else {
            this.m_secrets = false;
        }
        if (!this.m_secrets && this.m_pm.supports(0x320000)) {
            System.out.print("WARNING - Cannot retrieve user passwords.  ");
            System.out.println("Saving rest of user information.");
        }
        String string2 = LEAppInfo.getFlag("-f");
        try {
            File file = new File(string2);
            FileWriter fileWriter = new FileWriter(file);
            BufferedWriter bufferedWriter = new BufferedWriter(fileWriter);
            PrintWriter printWriter = new PrintWriter((Writer)bufferedWriter, true);
            LERadiusConverter lERadiusConverter = new LERadiusConverter(this.m_pm.getHostname(), this.m_secrets);
            lERadiusConverter.writeUsers(lEUsers, printWriter);
        }
        catch (Exception exception) {
            LEDebug.getLog().logln(20, exception);
        }
        this.disconnect();
    }

    public void printUsage() {
        super.printUsage();
        System.out.print("-f <filename> ");
        System.out.println("[-nopass]");
    }

    public void printHelpInfo() {
        super.printHelpInfo();
        System.out.println("-f <filename> : specifies the output file.");
        System.out.println("[-nopass] : specifies not to retrieve passwords.");
    }
}

