/*
 * Decompiled with CFR 0.152.
 */
package com.lucent.ra.nms.backend;

import com.lucent.ra.nms.amf.LEAMRouter_RI;
import com.lucent.ra.nms.backend.LEAlarmFacility_R;
import com.lucent.ra.nms.backend.LEAlarmFacility_RI;
import com.lucent.ra.nms.backend.LEAsyncCmdFacility_R;
import com.lucent.ra.nms.backend.LEAsyncCmdFacility_RI;
import com.lucent.ra.nms.backend.LEDSSException;
import com.lucent.ra.nms.backend.LEDSSPMAuthFailureException;
import com.lucent.ra.nms.backend.LEDSSPMOpFailureException;
import com.lucent.ra.nms.backend.LEDSSPortMaster_R;
import com.lucent.ra.nms.backend.LEDebugFacility_R;
import com.lucent.ra.nms.backend.LEDebugFacility_RI;
import com.lucent.ra.nms.backend.LELogFacility_R;
import com.lucent.ra.nms.backend.LELogFacility_RI;
import com.lucent.ra.nms.backend.LEMonitorFacility_R;
import com.lucent.ra.nms.backend.LEMonitorFacility_RI;
import com.lucent.ra.nms.backend.LEPMCommand;
import com.lucent.ra.nms.backend.LEPMListen;
import com.lucent.ra.nms.backend.LESendBuf;
import com.lucent.ra.nms.backend.LESendResponse;
import com.lucent.ra.nms.backend.LEStatusMessage;
import com.lucent.ra.nms.backend.LEUserAuthenticationMessage;
import com.lucent.ra.nms.util.LEAppInfo;
import com.lucent.ra.nms.util.LEDebug;
import com.lucent.ra.nms.util.LEObservable;
import com.lucent.ra.nms.util.LEObserver;
import com.lucent.ra.nms.util.LEQueue;
import com.lucent.ra.nms.util.LEResourceID;
import com.lucent.ra.nms.util.LETokenizer;
import com.lucent.ra.nms.util.LEVector;
import com.lucent.ra.nms.util.MD5;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.Socket;
import java.net.UnknownHostException;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;

public class LEDSSPortMaster_RI
extends UnicastRemoteObject
implements LEDSSPortMaster_R,
LEObserver {
    public static final String REQ_TIMEOUT = "Request timedout";
    public static final String UNEXPLAINED = "Unexplained error";
    protected static final String TEST_COMMAND = "version";
    protected static final String NC_MORE = "-- Press Return for More -- ";
    protected static FileWriter s_dbgFile;
    protected static PrintWriter s_pw;
    protected static int TIMEOUT_MILLIS;
    String m_id;
    LEAMRouter_RI m_router;
    long m_idle;
    LEAlarmFacility_RI m_alarm;
    LEDebugFacility_RI m_debug;
    LEMonitorFacility_RI m_monitor;
    LEAsyncCmdFacility_RI m_async;
    LELogFacility_RI m_log;
    protected String m_hostname;
    protected String m_username;
    protected String m_password;
    protected boolean m_oneTimePass;
    protected Socket m_pmfd;
    protected LEPMListen m_listener;
    protected OutputStream m_outStream;
    protected LESendBuf m_sbOut;
    protected boolean m_newCommand = false;
    protected boolean m_rebooting = false;
    protected boolean m_reconnecting = false;
    protected boolean m_upgrading = false;
    protected boolean m_error = false;
    protected boolean m_noalarm = false;
    protected LEQueue m_threads = new LEQueue();
    protected LEQueue m_sbInQ;

    public LEDSSPortMaster_RI(String hostname, String username, String password) throws IOException, LEDSSException, RemoteException {
        this.initialize(hostname, username, password);
        this.connectUser();
    }

    public LEDSSPortMaster_RI(String hostname, String password, boolean oneTimePass) throws IOException, LEDSSException, RemoteException {
        this.initialize(hostname, null, password);
        this.m_oneTimePass = oneTimePass;
        if (this.m_oneTimePass) {
            this.connectOTP();
        } else {
            this.connect();
        }
    }

    public LEDSSPortMaster_RI(String hostname, String password) throws IOException, LEDSSException, RemoteException {
        this.initialize(hostname, null, password);
        this.connect();
    }

    public LEDSSPortMaster_RI() throws RemoteException {
        this.initialize();
    }

    public String getResourceID() throws RemoteException {
        return this.m_id;
    }

    public String getHostname() throws RemoteException {
        return this.m_hostname;
    }

    public String getUsername() throws RemoteException {
        return this.m_username;
    }

    public String getPassword() throws RemoteException {
        return this.m_password;
    }

    public boolean supportsEntities() throws RemoteException {
        return this.m_newCommand;
    }

    public void setPassword(String password) throws RemoteException {
        this.m_password = password;
    }

    public boolean isConnected() throws RemoteException {
        if (this.m_rebooting) {
            return false;
        }
        return this.m_pmfd != null;
    }

    public void disconnect() throws RemoteException {
        this.disconnect(2);
    }

    public boolean reconnecting() throws RemoteException {
        return this.m_reconnecting;
    }

    public boolean reconnect() throws IOException, LEDSSException, RemoteException {
        if (this.isConnected()) {
            return true;
        }
        this.m_reconnecting = true;
        try {
            if (this.m_oneTimePass) {
                this.connectOTP();
            } else if (this.m_username != null) {
                this.connectUser();
            } else {
                this.connect();
            }
        }
        catch (IOException e) {
            this.m_reconnecting = false;
            throw e;
        }
        catch (LEDSSException e) {
            this.m_reconnecting = false;
            throw e;
        }
        this.m_reconnecting = false;
        return this.isConnected();
    }

    public void startUpgrade() throws RemoteException {
        this.m_upgrading = true;
        LEStatusMessage msg = new LEStatusMessage(5);
        this.m_router.distribute(this.m_id, "STATUS", msg);
    }

    public void stopUpgrade() throws RemoteException {
        this.m_upgrading = false;
        if (this.isConnected()) {
            LEStatusMessage msg = new LEStatusMessage(6);
            this.m_router.distribute(this.m_id, "STATUS", msg);
        }
    }

    public boolean upgrading() throws RemoteException {
        return this.m_upgrading;
    }

    public LEAlarmFacility_R getAlarmFacility() throws RemoteException {
        block2: {
            if (this.m_alarm != null || !this.m_newCommand || this.m_noalarm) break block2;
            try {
                this.m_alarm = new LEAlarmFacility_RI(this);
            }
            catch (RemoteException e) {
                LEDebug.getLog().logln(10, e);
            }
        }
        return this.m_alarm;
    }

    public LEDebugFacility_R getDebugFacility() throws RemoteException {
        block2: {
            if (this.m_debug != null || !this.m_newCommand) break block2;
            try {
                this.m_debug = new LEDebugFacility_RI(this);
            }
            catch (RemoteException e) {
                LEDebug.getLog().logln(10, e);
            }
        }
        return this.m_debug;
    }

    public LEMonitorFacility_R getMonitorFacility() throws RemoteException {
        block2: {
            if (this.m_monitor != null || !this.m_newCommand) break block2;
            try {
                this.m_monitor = new LEMonitorFacility_RI(this);
            }
            catch (RemoteException e) {
                LEDebug.getLog().logln(10, e);
            }
        }
        return this.m_monitor;
    }

    public LEAsyncCmdFacility_R getAsyncFacility() throws RemoteException {
        block2: {
            if (this.m_async != null || !this.m_newCommand) break block2;
            try {
                this.m_async = new LEAsyncCmdFacility_RI(this);
            }
            catch (RemoteException e) {
                LEDebug.getLog().logln(10, e);
            }
        }
        return this.m_async;
    }

    public LELogFacility_R getLogFacility() throws RemoteException {
        block2: {
            if (this.m_log != null || !this.m_newCommand) break block2;
            try {
                this.m_log = new LELogFacility_RI(this);
            }
            catch (RemoteException e) {
                LEDebug.getLog().logln(10, e);
            }
        }
        return this.m_log;
    }

    public LEPMCommand execute(String command) throws RemoteException {
        return this.execute(command, TIMEOUT_MILLIS);
    }

    public LEPMCommand execute(String command, int timeout) throws RemoteException {
        LEPMCommand cmd = new LEPMCommand(command);
        int len = 0;
        if (command != null) {
            len = command.length();
        }
        if (len == 0) {
            cmd.setStatus(false);
            return cmd;
        }
        LEDebug.getLog().logln(40, "Executing: " + command);
        if (LEPMCommand.IsReboot(command)) {
            return this.reboot(cmd);
        }
        return this.execute(cmd, timeout);
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public LEVector getTOC(int entity) throws RemoteException {
        toc = null;
        cmd = Integer.toString(entity);
        resp = this.send((byte)22, (short)cmd.length(), cmd, true);
        success = resp.successful();
        if (success) {
            toc = new LEVector();
            tok = resp.getStreamTok();
            more = true;
            try lbl-1000:
            // 8 sources

            {
                block8: while (success && more) {
                    attribute = tok.getNextInt();
                    switch (attribute) {
                        case 0x1D0000: {
                            tok.getNextQuotedString();
                            ** break;
                        }
                        case 12: {
                            tok.getNextQuotedString();
                            ** break;
                        }
                        case 10: {
                            toc.addElement(tok.getNextQuotedString());
                            ** break;
                        }
                        case 65535: {
                            if (tok.getNextInt() == 1) {
                                resp = this.recv(true);
                                success = resp.successful();
                                if (!success) continue block8;
                                tok = resp.getStreamTok();
                                ** break;
                            }
                            more = false;
                            ** break;
                        }
                    }
                    LEDebug.getLog().logln(30, "Bad TOC attribute: " + attribute + ", " + tok.getNextQuotedString());
                }
            }
            catch (Exception e) {
                LEDebug.getLog().logln(20, e);
            }
        }
        this.done();
        return toc;
    }

    public long debug(int entity, int context) throws LEDSSException, RemoteException {
        StringBuffer buf = new StringBuffer();
        buf.append(entity);
        buf.append(' ');
        buf.append(context);
        buf.append(" 1");
        String command = new String(buf);
        LESendResponse resp = this.send((byte)24, (short)command.length(), command, false);
        if (!resp.successful()) {
            throw this.getLEDSSException(resp);
        }
        try {
            resp.getStreamTok().getNextString();
            long req = resp.getStreamTok().getNextLong();
            return req;
        }
        catch (IOException xc) {
            throw new LEDSSPMOpFailureException(xc.getMessage());
        }
    }

    public long debug(int entity, int context, int board) throws LEDSSException, RemoteException {
        StringBuffer buf = new StringBuffer();
        buf.append(277);
        buf.append(' ');
        buf.append(entity);
        buf.append(' ');
        buf.append(459);
        buf.append(' ');
        buf.append(context);
        buf.append(' ');
        buf.append(275);
        buf.append(' ');
        buf.append(board);
        buf.append(' ');
        buf.append(460);
        buf.append(' ');
        buf.append(" 1");
        String command = new String(buf);
        LESendResponse resp = this.send((byte)24, (short)command.length(), command, false);
        if (!resp.successful()) {
            throw this.getLEDSSException(resp);
        }
        try {
            resp.getStreamTok().getNextString();
            long req = resp.getStreamTok().getNextLong();
            return req;
        }
        catch (IOException xc) {
            throw new LEDSSPMOpFailureException(xc.getMessage());
        }
    }

    public long diag(int entity, int context) throws LEDSSException, RemoteException {
        StringBuffer buf = new StringBuffer();
        buf.append(576);
        buf.append(' ');
        buf.append(entity);
        buf.append(' ');
        buf.append(577);
        buf.append(' ');
        buf.append(context);
        buf.append(' ');
        buf.append(578);
        buf.append(" 100000");
        String command = new String(buf);
        LESendResponse resp = this.send((byte)42, (short)command.length(), command, false);
        if (!resp.successful()) {
            throw this.getLEDSSException(resp);
        }
        try {
            resp.getStreamTok().getNextString();
            long req = resp.getStreamTok().getNextLong();
            return req;
        }
        catch (IOException xc) {
            throw new LEDSSPMOpFailureException(xc.getMessage());
        }
    }

    public void killDebug(long req) throws LEDSSException, RemoteException {
        String command = new String(String.valueOf(Long.toString(req)) + " 0");
        LESendResponse resp = this.send((byte)24, (short)command.length(), command, false);
        if (!resp.successful()) {
            throw this.getLEDSSException(resp);
        }
    }

    public void killDiag(long req) throws LEDSSException, RemoteException {
        String command = new String(String.valueOf(Long.toString(579L)) + " " + Long.toString(req));
        LESendResponse resp = this.send((byte)43, (short)command.length(), command, false);
        if (!resp.successful()) {
            throw this.getLEDSSException(resp);
        }
    }

    public long delta(int entity, int interval) throws LEDSSException, RemoteException {
        StringBuffer buf = new StringBuffer();
        buf.append(entity);
        buf.append(' ');
        buf.append(interval);
        String command = new String(buf);
        try {
            LESendResponse resp = this.send((byte)25, (short)command.length(), command, false);
            if (!resp.successful()) {
                throw this.getLEDSSException(resp);
            }
            resp.getStreamTok().getNextString();
            long req = resp.getStreamTok().getNextLong();
            return req;
        }
        catch (IOException xc) {
            throw new LEDSSPMOpFailureException(xc.getMessage());
        }
    }

    public long delta(int entity, int interval, int board) throws LEDSSException, RemoteException {
        StringBuffer buf = new StringBuffer();
        buf.append(277);
        buf.append(" ");
        buf.append(entity);
        buf.append(" ");
        buf.append(275);
        buf.append(" ");
        buf.append(board);
        buf.append(" ");
        buf.append(278);
        buf.append(" ");
        buf.append(interval);
        String command = new String(buf);
        try {
            LESendResponse resp = this.send((byte)25, (short)command.length(), command, false);
            if (!resp.successful()) {
                throw this.getLEDSSException(resp);
            }
            resp.getStreamTok().getNextString();
            long req = resp.getStreamTok().getNextLong();
            return req;
        }
        catch (IOException xc) {
            throw new LEDSSPMOpFailureException(xc.getMessage());
        }
    }

    public void killDelta(long req) throws LEDSSException, RemoteException {
        String command = new String(String.valueOf(Long.toString(req)) + " 0");
        LESendResponse resp = this.send((byte)25, (short)command.length(), command, false);
        if (!resp.successful()) {
            throw this.getLEDSSException(resp);
        }
    }

    public long alarm(int entity) throws LEDSSException, RemoteException {
        StringBuffer buf = new StringBuffer();
        buf.append(entity);
        buf.append(" 1");
        String command = new String(buf);
        LESendResponse resp = this.send((byte)29, (short)command.length(), command, false);
        if (!resp.successful()) {
            throw this.getLEDSSException(resp);
        }
        try {
            resp.getStreamTok().getNextString();
            long req = resp.getStreamTok().getNextLong();
            return req;
        }
        catch (IOException xc) {
            throw new LEDSSPMOpFailureException(xc.getMessage());
        }
    }

    public void clearAlarm(long req) throws LEDSSException, RemoteException {
        String command = new String(String.valueOf(Long.toString(req)) + " 2");
        LESendResponse resp = this.send((byte)29, (short)command.length(), command, false);
        if (!resp.successful()) {
            throw this.getLEDSSException(resp);
        }
    }

    public void killAlarm(long req) throws LEDSSException, RemoteException {
        String command = new String(String.valueOf(Long.toString(req)) + " 0");
        LESendResponse resp = this.send((byte)29, (short)command.length(), command, false);
        if (!resp.successful()) {
            throw this.getLEDSSException(resp);
        }
    }

    public long monitor(int entity, int interval) throws LEDSSException, RemoteException {
        StringBuffer buf = new StringBuffer();
        buf.append(entity);
        buf.append(' ');
        buf.append(interval);
        String command = new String(buf);
        LESendResponse resp = this.send((byte)23, (short)command.length(), command, false);
        if (!resp.successful()) {
            throw this.getLEDSSException(resp);
        }
        try {
            resp.getStreamTok().getNextString();
            long req = resp.getStreamTok().getNextLong();
            return req;
        }
        catch (IOException xc) {
            throw new LEDSSPMOpFailureException(xc.getMessage());
        }
    }

    public long monitor(int entity, int interval, int board) throws LEDSSException, RemoteException {
        StringBuffer buf = new StringBuffer();
        buf.append(277);
        buf.append(" ");
        buf.append(entity);
        buf.append(" ");
        buf.append(275);
        buf.append(" ");
        buf.append(board);
        buf.append(" ");
        buf.append(278);
        buf.append(" ");
        buf.append(interval);
        String command = new String(buf);
        LESendResponse resp = this.send((byte)23, (short)command.length(), command, false);
        if (!resp.successful()) {
            throw this.getLEDSSException(resp);
        }
        try {
            resp.getStreamTok().getNextString();
            long req = resp.getStreamTok().getNextLong();
            return req;
        }
        catch (IOException xc) {
            throw new LEDSSPMOpFailureException(xc.getMessage());
        }
    }

    public long monitor(int entity, int interval, String adminGroup) throws LEDSSException, RemoteException {
        StringBuffer buf = new StringBuffer();
        buf.append(277);
        buf.append(" ");
        buf.append(entity);
        buf.append(" ");
        buf.append(553);
        buf.append(" ");
        buf.append(adminGroup);
        buf.append(" ");
        buf.append(278);
        buf.append(" ");
        buf.append(interval);
        String command = new String(buf);
        LESendResponse resp = this.send((byte)23, (short)command.length(), command, false);
        if (!resp.successful()) {
            throw this.getLEDSSException(resp);
        }
        try {
            resp.getStreamTok().getNextString();
            long req = resp.getStreamTok().getNextLong();
            return req;
        }
        catch (IOException xc) {
            throw new LEDSSPMOpFailureException(xc.getMessage());
        }
    }

    public long monitor(int entity, int interval, int board, String start, String end) throws LEDSSException, RemoteException {
        StringBuffer buf = new StringBuffer();
        buf.append(277);
        buf.append(" ");
        buf.append(entity);
        buf.append(" ");
        buf.append(275);
        buf.append(" ");
        buf.append(board);
        buf.append(" ");
        buf.append(560);
        buf.append(" ");
        buf.append(start);
        buf.append(" ");
        buf.append(561);
        buf.append(" ");
        buf.append(end);
        buf.append(" ");
        buf.append(278);
        buf.append(" ");
        buf.append(interval);
        String command = new String(buf);
        LESendResponse resp = this.send((byte)23, (short)command.length(), command, false);
        if (!resp.successful()) {
            throw this.getLEDSSException(resp);
        }
        try {
            resp.getStreamTok().getNextString();
            long req = resp.getStreamTok().getNextLong();
            return req;
        }
        catch (IOException xc) {
            throw new LEDSSPMOpFailureException(xc.getMessage());
        }
    }

    public void killMonitor(long req) throws LEDSSException, RemoteException {
        String command = new String(String.valueOf(Long.toString(req)) + " 0");
        LESendResponse resp = this.send((byte)23, (short)command.length(), command, false);
        if (!resp.successful()) {
            throw this.getLEDSSException(resp);
        }
    }

    public long async(int entity, int board, String async_cmd) throws LEDSSException, RemoteException {
        StringBuffer buf = new StringBuffer();
        buf.append(277);
        buf.append(" ");
        buf.append(entity);
        buf.append(" ");
        buf.append(89);
        buf.append(" ");
        buf.append(async_cmd);
        String command = new String(buf);
        LESendResponse resp = this.send((byte)36, (short)command.length(), command, false);
        if (!resp.successful()) {
            throw this.getLEDSSException(resp);
        }
        try {
            resp.getStreamTok().getNextString();
            long req = resp.getStreamTok().getNextLong();
            return req;
        }
        catch (IOException xc) {
            throw new LEDSSPMOpFailureException(xc.getMessage());
        }
    }

    public void killAsync(long req) throws LEDSSException, RemoteException {
        StringBuffer buf = new StringBuffer();
        buf.append(88);
        buf.append(" ");
        buf.append(Long.toString(req));
        LESendResponse resp = this.send((byte)36, (short)buf.length(), buf.toString(), false);
        if (!resp.successful()) {
            throw this.getLEDSSException(resp);
        }
    }

    public long log(int entity) throws LEDSSException, RemoteException {
        StringBuffer buf = new StringBuffer();
        buf.append(277);
        buf.append(" ");
        buf.append(entity);
        String command = new String(buf);
        LESendResponse resp = this.send((byte)38, (short)command.length(), command, false);
        if (!resp.successful()) {
            throw this.getLEDSSException(resp);
        }
        try {
            resp.getStreamTok().getNextString();
            long req = resp.getStreamTok().getNextLong();
            return req;
        }
        catch (IOException xc) {
            throw new LEDSSPMOpFailureException(xc.getMessage());
        }
    }

    public void killLog(long req) throws LEDSSException, RemoteException {
        String command = new String(String.valueOf(Long.toString(req)) + " 0");
        LESendResponse resp = this.send((byte)38, (short)command.length(), command, false);
        if (!resp.successful()) {
            throw this.getLEDSSException(resp);
        }
    }

    public LEUserAuthenticationMessage userAuthenticate(String username, String password) throws RemoteException {
        StringBuffer buf = new StringBuffer();
        buf.append(2);
        buf.append(" ");
        buf.append(username);
        buf.append(" ");
        buf.append(300);
        buf.append(" ");
        buf.append(password);
        String command = new String(buf);
        LESendResponse resp = this.send((byte)35, (short)command.length(), command, false);
        if (!resp.successful()) {
            LEDebug.getLog().logln(40, "Authenticate FAILED for user " + username);
            return null;
        }
        String respUsername = "";
        String adminGroup = "";
        int type = -1;
        boolean more = true;
        while (more) {
            try {
                int attr = resp.getStreamTok().getNextInt();
                switch (attr) {
                    case 2: {
                        respUsername = resp.getStreamTok().getNextQuotedString();
                        break;
                    }
                    case 552: {
                        type = Integer.parseInt(resp.getStreamTok().getNextQuotedString());
                        break;
                    }
                    case 553: {
                        adminGroup = resp.getStreamTok().getNextQuotedString();
                        break;
                    }
                    default: {
                        LEDebug.getLog().logln(30, "Bad Authenticate attribute: " + attr + ", " + resp.getStreamTok().getNextQuotedString());
                        break;
                    }
                }
            }
            catch (IOException iOException) {
                more = false;
            }
            catch (Exception e) {
                LEDebug.getLog().logln(20, e);
                more = false;
            }
        }
        if (!username.equals(respUsername)) {
            LEDebug.getLog().logln(40, "Authenticate Failed for " + username + "; username mismatch");
            return null;
        }
        LEUserAuthenticationMessage msg = new LEUserAuthenticationMessage(username, adminGroup, type);
        return msg;
    }

    public LESendResponse send(byte opCode, short length, String data, boolean multiPacket) throws RemoteException {
        return this.send(opCode, length, data, multiPacket, TIMEOUT_MILLIS);
    }

    public LESendResponse send(byte opCode, short length, String data, boolean multiPacket, int timeout) throws RemoteException {
        byte[] tmp = data.getBytes();
        byte[] dst = new byte[length + 1];
        System.arraycopy(tmp, 0, dst, 0, length);
        short s = length;
        length = (short)(s + 1);
        dst[s] = 0;
        return this.send(opCode, length, dst, multiPacket, timeout);
    }

    public LESendResponse send(byte opCode, short length, byte[] data, boolean multiPacket) throws RemoteException {
        return this.send(opCode, length, data, multiPacket, TIMEOUT_MILLIS);
    }

    public LESendResponse send(byte opCode, short length, byte[] data, boolean multiPacket, int timeout) throws RemoteException {
        this.send(opCode, length, data);
        LESendResponse resp = this.recv(multiPacket, timeout);
        if (resp.timedout() && LEDebug.getLog().shouldLog(40)) {
            String msg = " PACKET: " + LEDSSPortMaster_RI.GetOpCodeString(opCode) + " " + Integer.toString(length) + " " + new String(data);
            LEDebug.getLog().logln(40, msg);
        }
        return resp;
    }

    public synchronized void send(byte opCode, short length, byte[] data) throws RemoteException {
        Thread thread = Thread.currentThread();
        this.m_threads.add(thread);
        while (thread != (Thread)this.m_threads.peek()) {
            try {
                this.wait();
            }
            catch (Exception xc) {
                LEDebug.getLog().logln(20, xc);
            }
        }
        this.m_idle = System.currentTimeMillis();
        this.m_sbInQ.clear();
        this.m_sbOut.reset();
        this.m_sbOut.m_idByte = (byte)101;
        this.m_sbOut.m_opCode = opCode;
        this.m_sbOut.m_sendLength = length;
        System.arraycopy(data, 0, this.m_sbOut.m_data, 0, length);
        try {
            if (this.m_outStream != null) {
                this.m_outStream.write(this.m_sbOut.getBytes(), 0, length + 4);
                this.m_outStream.flush();
                this.dumpLogV("Sent: " + LEDSSPortMaster_RI.GetOpCodeString(this.m_sbOut.m_opCode));
                LEDSSPortMaster_RI.dumpSRMsg("Sent: " + LEDSSPortMaster_RI.GetOpCodeString(this.m_sbOut.m_opCode));
                LEDSSPortMaster_RI.dumpSRMsg(this.m_sbOut.toString());
                LEDSSPortMaster_RI.dumpSRMsg("End send");
                LEDSSPortMaster_RI.dumpSRMsg("");
            } else {
                this.update(null, null);
            }
        }
        catch (Exception xc) {
            LEDebug.getLog().logln(20, xc);
            this.update(null, xc);
        }
    }

    public LESendResponse recv(boolean multiPacket) throws RemoteException {
        return this.recv(multiPacket, TIMEOUT_MILLIS);
    }

    public synchronized LESendResponse recv(boolean multiPacket, int timeout) throws RemoteException {
        long millis = System.currentTimeMillis();
        long diff = 0L;
        boolean timedout = false;
        while (!timedout && this.m_sbInQ.size() == 0) {
            diff = System.currentTimeMillis() - millis;
            try {
                this.wait((long)timeout - diff);
            }
            catch (Exception xc) {
                LEDebug.getLog().logln(20, xc);
            }
            if (System.currentTimeMillis() - millis < (long)timeout) continue;
            timedout = true;
        }
        LESendResponse resp = null;
        if (this.m_sbInQ.size() > 0) {
            Object obj = this.m_sbInQ.next();
            if (obj instanceof LESendResponse) {
                resp = (LESendResponse)obj;
            } else if (obj instanceof Exception) {
                resp = new LESendResponse((Exception)obj);
            } else {
                resp = new LESendResponse();
                resp.setTimeout(true);
            }
        } else {
            resp = new LESendResponse();
            resp.setTimeout(true);
        }
        resp.checkSuccess();
        if (resp.successful()) {
            this.dumpLogV("Received: " + LEDSSPortMaster_RI.GetOpCodeString(resp.m_opCode));
            LEDSSPortMaster_RI.dumpSRMsg("Received: " + LEDSSPortMaster_RI.GetOpCodeString(resp.m_opCode));
            LEDSSPortMaster_RI.dumpSRMsg(resp.toString());
            LEDSSPortMaster_RI.dumpSRMsg("End Receive");
            LEDSSPortMaster_RI.dumpSRMsg("");
        } else if (resp.timedout()) {
            this.dumpLogV("Received: TIMEOUT");
            LEDSSPortMaster_RI.dumpSRMsg("Received: TIMEOUT");
            this.m_error = true;
            this.disconnect();
        } else if (resp.getException() != null) {
            this.dumpLogV("Received: EXCEPTION " + resp.getException().toString());
            LEDSSPortMaster_RI.dumpSRMsg("Received: EXCEPTION " + resp.getException().toString());
        }
        if (!multiPacket) {
            this.done();
        }
        return resp;
    }

    public synchronized void done() throws RemoteException {
        Thread cur = Thread.currentThread();
        if (this.m_threads.size() > 0) {
            if (cur == (Thread)this.m_threads.peek()) {
                this.m_threads.next();
            } else {
                this.m_threads.next();
                LEDebug.getLog().logln(10, "LEDSSPortMaster_RI: done called by wrong thread: " + cur.getName() + ", " + this.m_threads.toString());
                LEDebug.getLog().logStack(10);
            }
        } else {
            LEDebug.getLog().logln(10, "LEDSSPortMaster_RI: done called on empty queue: " + cur.getName() + ", " + this.m_threads.toString());
        }
        this.notifyAll();
    }

    public synchronized void update(LEObservable obs, Object obj) {
        this.m_sbInQ.add(obj);
        this.notifyAll();
        if (obj instanceof IOException) {
            this.m_error = true;
            try {
                this.disconnect();
            }
            catch (RemoteException remoteException) {}
            Exception xc = (Exception)obj;
            LEStatusMessage stat = new LEStatusMessage(3, xc);
            this.m_router.distribute(this.m_id, "STATUS", stat);
        } else if (obj instanceof Exception) {
            this.m_error = true;
            try {
                this.disconnect();
            }
            catch (RemoteException remoteException) {}
            Exception e = (Exception)obj;
            LEDSSException xc = new LEDSSException(e.getMessage());
            LEStatusMessage stat = new LEStatusMessage(3, xc);
            this.m_router.distribute(this.m_id, "STATUS", stat);
        }
    }

    public long getIdleTime() {
        return System.currentTimeMillis() - this.m_idle;
    }

    public void finalize() {
        try {
            this.disconnect();
        }
        catch (RemoteException remoteException) {}
    }

    void connectUser() throws IOException, LEDSSException {
        this.preConnect();
        try {
            if (this.m_username.equals("!root")) {
                this.connect();
                return;
            }
            byte[] buf = new byte[this.m_password.length() + 65];
            byte[] tmp = this.m_username.getBytes();
            System.arraycopy(tmp, 0, buf, 0, tmp.length);
            tmp = this.m_password.getBytes();
            System.arraycopy(tmp, 0, buf, 64, tmp.length);
            LESendResponse resp = this.send((byte)20, (short)buf.length, buf, false);
            if (!resp.successful()) {
                this.disconnect();
                throw new LEDSSPMAuthFailureException("");
            }
            this.postConnect();
        }
        catch (UnknownHostException unknownHostException) {
            String msg = "Unknown host: " + this.m_hostname;
            this.disconnect();
            throw new UnknownHostException(msg);
        }
        catch (LEDSSPMOpFailureException xc) {
            String msg = xc.getMessage();
            this.disconnect();
            throw new LEDSSPMAuthFailureException(msg);
        }
    }

    void connectOTP() throws IOException, LEDSSException {
        this.preConnect();
        LESendResponse resp = this.send((byte)2, (short)this.m_password.length(), this.m_password, false);
        if (!resp.successful()) {
            this.disconnect();
            throw new LEDSSPMAuthFailureException("");
        }
        this.postConnect();
    }

    void connect() throws IOException, LEDSSException {
        this.preConnect();
        byte[] data = new byte[]{0};
        LESendResponse resp = this.send((byte)18, (short)1, data, false);
        if (!resp.successful()) {
            this.connectOTP();
            return;
        }
        MD5 md5 = new MD5();
        byte[] buf = new byte[50];
        LETokenizer _streamTok = resp.getStreamTok();
        _streamTok.getNextRawBytes(1);
        byte[] digest = _streamTok.getNextRawBytes(16);
        md5.update(this.m_password);
        md5.update(digest);
        md5.update("Command> ");
        digest = md5.digest();
        resp = this.send((byte)19, (short)16, digest, false);
        if (!resp.successful()) {
            this.disconnect();
            throw new LEDSSPMAuthFailureException("");
        }
        this.postConnect();
    }

    LEPMCommand reboot(LEPMCommand cmd) {
        LEDebug.getLog().logln(40, "** REBOOTING **");
        this.m_rebooting = true;
        boolean fail = false;
        try {
            cmd = this.execute(cmd);
            if (!cmd.getStatus()) {
                LEDebug.getLog().logln(40, "REBOOT FAILED");
                this.m_rebooting = false;
                return cmd;
            }
        }
        catch (RemoteException remoteException) {
            LEDebug.getLog().logln(40, "REBOOT FAILED: REMOTE EXCEPTION");
            this.m_rebooting = false;
            cmd.setStatus(false);
            return cmd;
        }
        this.disconnect(4);
        if (!this.waitAndReconnect() && !this.waitAndReconnect()) {
            fail = true;
        }
        if (fail) {
            LEStatusMessage stat = new LEStatusMessage(2, this.m_id);
            this.m_router.distribute(this.m_id, "STATUS", stat);
        }
        return cmd;
    }

    boolean waitAndReconnect() {
        boolean success = false;
        try {
            Thread.currentThread();
            Thread.sleep(20000L);
            success = this.reconnect();
        }
        catch (LEDSSException lEDSSException) {
        }
        catch (Exception e) {
            LEDebug.getLog().logln(20, e);
        }
        return success;
    }

    boolean safeDisconnect() {
        return !this.m_error && !this.m_rebooting;
    }

    void disconnect(int status) {
        boolean genstatus = false;
        try {
            if (this.m_alarm != null) {
                if (this.safeDisconnect()) {
                    this.m_alarm.stopAlarms();
                }
                this.m_alarm.shutdown();
                this.m_alarm = null;
            }
            if (this.m_debug != null) {
                if (this.safeDisconnect()) {
                    this.m_debug.shutdown();
                }
                this.m_debug = null;
            }
            if (this.m_monitor != null) {
                if (this.safeDisconnect()) {
                    this.m_monitor.shutdown();
                }
                this.m_monitor = null;
            }
            if (this.m_async != null) {
                if (this.safeDisconnect()) {
                    this.m_async.shutdown();
                }
                this.m_async = null;
            }
            if (this.m_log != null) {
                if (this.safeDisconnect()) {
                    this.m_log.shutdown();
                }
                this.m_log = null;
            }
            if (this.m_pmfd != null) {
                genstatus = true;
                if (this.m_listener != null) {
                    this.m_listener.shutdown();
                }
                this.m_listener = null;
                this.m_outStream.close();
                this.m_pmfd.close();
            }
        }
        catch (Exception xc) {
            LEDebug.getLog().logln(20, xc);
        }
        this.m_outStream = null;
        this.m_pmfd = null;
        this.m_rebooting = false;
        this.m_error = false;
        if (genstatus) {
            LEStatusMessage stat = new LEStatusMessage(status, this.m_id);
            this.m_router.distribute(this.m_id, "STATUS", stat);
        }
    }

    protected void postConnect() throws LEDSSException {
        this.testNewCommand();
        LEStatusMessage stat = new LEStatusMessage(1);
        this.m_router.distribute(this.m_id, "STATUS", stat);
    }

    protected void testNewCommand() {
        try {
            LESendResponse resp = this.send((byte)33, (short)TEST_COMMAND.length(), TEST_COMMAND, true);
            if (resp.successful()) {
                this.recv(true);
                this.m_newCommand = true;
                String result = resp.toString();
                if (result.indexOf("ComOS 3.8") > -1) {
                    this.m_noalarm = true;
                }
            } else {
                this.m_newCommand = false;
            }
            this.done();
        }
        catch (Exception e) {
            LEDebug.getLog().logln(20, e);
        }
    }

    protected LEPMCommand execute(LEPMCommand command) throws RemoteException {
        return this.execute(command, TIMEOUT_MILLIS);
    }

    protected LEPMCommand execute(LEPMCommand command, int timeout) throws RemoteException {
        LESendResponse resp;
        boolean failure = false;
        String cmd = command.getCommand();
        StringBuffer result = new StringBuffer();
        if (this.m_newCommand) {
            resp = this.send((byte)33, (short)cmd.length(), cmd, true, timeout);
            if (resp.successful()) {
                while (!failure && resp.m_opCode != 9) {
                    String data = new String(resp.m_data, 0, (int)resp.m_sendLength);
                    int index = data.indexOf(NC_MORE);
                    if (index > -1) {
                        data = data.substring(0, index);
                    }
                    result.append(data);
                    resp = this.recv(true, timeout);
                    if (resp.successful()) continue;
                    failure = true;
                }
            } else {
                failure = true;
            }
            this.done();
        } else {
            resp = this.send((byte)4, (short)cmd.length(), cmd, false, timeout);
            if (!resp.successful()) {
                failure = true;
            }
        }
        if (resp.timedout()) {
            command.setResult("Connection lost");
        } else if (resp.getException() != null) {
            command.setResult("Connection lost");
        } else {
            command.setResult(new String(result));
        }
        if (failure) {
            command.setStatus(false);
        } else {
            String pwd = LEPMCommand.IsSetPassword(cmd);
            if (pwd != null) {
                this.setPassword(pwd);
            }
        }
        return command;
    }

    private void preConnect() throws IOException {
        if (this.m_pmfd == null) {
            try {
                this.m_pmfd = new Socket(this.m_hostname, 1643);
            }
            catch (UnknownHostException unknownHostException) {
                String msg = "Unknown host: " + this.m_hostname;
                this.disconnect();
                throw new UnknownHostException(msg);
            }
            this.m_listener = new LEPMListen(new DataInputStream(this.m_pmfd.getInputStream()), this.m_id);
            this.m_listener.addObserver(this);
            this.m_listener.start();
            this.m_outStream = this.m_pmfd.getOutputStream();
        }
    }

    protected static String GetOpCodeString(int opCode) {
        String opcode;
        switch (opCode) {
            case 2: {
                opcode = "NC_INIT";
                break;
            }
            case 3: {
                opcode = "NC_DISC";
                break;
            }
            case 4: {
                opcode = "NC_COMMAND";
                break;
            }
            case 5: {
                opcode = "NC_DOWNLOAD";
                break;
            }
            case 6: {
                opcode = "NC_DOWNDATA";
                break;
            }
            case 7: {
                opcode = "NC_RENAME";
                break;
            }
            case 8: {
                opcode = "NC_STATUS";
                break;
            }
            case 9: {
                opcode = "NC_REPLY";
                break;
            }
            case 10: {
                opcode = "NC_RAW_WRITE";
                break;
            }
            case 11: {
                opcode = "NC_IOSTAT";
                break;
            }
            case 12: {
                opcode = "NC_UPLOAD";
                break;
            }
            case 13: {
                opcode = "NC_UPDATA";
                break;
            }
            case 14: {
                opcode = "NC_CDATA";
                break;
            }
            case 15: {
                opcode = "NC_RESET";
                break;
            }
            case 16: {
                opcode = "NC_NETSTATUS";
                break;
            }
            case 17: {
                opcode = "NC_TABLE";
                break;
            }
            case 18: {
                opcode = "NC_CHALLENGE";
                break;
            }
            case 19: {
                opcode = "NC_MD5_PASS";
                break;
            }
            case 20: {
                opcode = "NC_USER_PASS";
                break;
            }
            case 21: {
                opcode = "NC_BK";
                break;
            }
            case 22: {
                opcode = "NC_TOC";
                break;
            }
            case 23: {
                opcode = "NC_MONITOR";
                break;
            }
            case 25: {
                opcode = "NC_DELTA";
                break;
            }
            case 29: {
                opcode = "NC_ALARMS";
                break;
            }
            case 30: {
                opcode = "NC_ALARMMSG";
                break;
            }
            case 24: {
                opcode = "NC_DEBUG";
                break;
            }
            case 26: {
                opcode = "NC_MONMESSAGE";
                break;
            }
            case 27: {
                opcode = "NC_DBGMESSAGE";
                break;
            }
            case 28: {
                opcode = "NC_DELTAMSG";
                break;
            }
            case 31: {
                opcode = "NC_ENTITY";
                break;
            }
            case 32: {
                opcode = "NC_ENTITYMSG";
                break;
            }
            case 33: {
                opcode = "NC_NEWCOMMAND";
                break;
            }
            case 34: {
                opcode = "NC_NEWCMDMSG";
                break;
            }
            case 35: {
                opcode = "NC_AUTHENTICATE";
                break;
            }
            case 36: {
                opcode = "NC_ASYNC";
                break;
            }
            case 37: {
                opcode = "NC_ASYNCMSG";
                break;
            }
            case 38: {
                opcode = "NC_LOG";
                break;
            }
            case 39: {
                opcode = "NC_LOGMSG";
                break;
            }
            case 40: {
                opcode = "NC_RESPONSE";
                break;
            }
            case 41: {
                opcode = "NC_USER_LOGIN";
                break;
            }
            case 42: {
                opcode = "NC_DIAG_START";
                break;
            }
            case 43: {
                opcode = "NC_DIAG_STOP";
                break;
            }
            case 44: {
                opcode = "NC_DIAGMSG";
                break;
            }
            case 45: {
                opcode = "NC_MON_START";
                break;
            }
            case 46: {
                opcode = "NC_MON_STOP";
                break;
            }
            case 47: {
                opcode = "NC_MONITORMSG";
                break;
            }
            case 48: {
                opcode = "NC_RENEW_LEASE";
                break;
            }
            case 49: {
                opcode = "NC_NEW_TOC";
                break;
            }
            case 50: {
                opcode = "NC_METAINFO";
                break;
            }
            case 51: {
                opcode = "NC_DATA";
                break;
            }
            default: {
                opcode = "Unknown";
            }
        }
        return opcode;
    }

    protected void dumpLogV(String msg) {
        LEDebug.getLog().logln(40, msg);
    }

    protected void dumpLog(int level, String msg) {
        LEDebug.getLog().logln(level, msg);
    }

    public static void dumpSRMsg(String str) {
        block2: {
            if (s_pw == null || !LEDebug.getLog().shouldLog(30)) break block2;
            try {
                s_pw.println(str);
            }
            catch (Exception xc) {
                LEDebug.getLog().logln(20, xc);
            }
        }
    }

    protected synchronized void initialize() {
        block2: {
            this.m_router = LEAMRouter_RI.GetAMRouter();
            String user = this.m_username == null ? "!root" : this.m_username;
            this.m_id = LEResourceID.CreatePM_ID(this.m_hostname, user);
            this.m_idle = System.currentTimeMillis();
            this.m_sbOut = new LESendBuf();
            this.m_sbOut.setSize(2048);
            this.m_sbInQ = new LEQueue(100);
            if (s_dbgFile != null) break block2;
            try {
                String path = LEAppInfo.getUserAppDirPath("sendrecv.txt");
                File file = new File(path);
                s_dbgFile = new FileWriter(file);
                s_pw = new PrintWriter((Writer)s_dbgFile, true);
            }
            catch (Exception exception) {
                s_dbgFile = null;
                s_pw = null;
            }
        }
    }

    protected synchronized void initialize(String hostname, String username, String password) {
        this.m_hostname = hostname;
        this.m_username = username;
        this.m_password = password;
        this.initialize();
    }

    LEDSSException getLEDSSException(LESendResponse resp) {
        if (resp.timedout()) {
            return new LEDSSPMOpFailureException(REQ_TIMEOUT);
        }
        Exception xc = resp.getException();
        if (xc != null) {
            return new LEDSSPMOpFailureException(xc.getMessage());
        }
        return new LEDSSPMOpFailureException(UNEXPLAINED);
    }

    static {
        TIMEOUT_MILLIS = 60000;
    }
}

