/*
 * Decompiled with CFR 0.152.
 */
package com.lucent.ra.nms.backend;

import com.lucent.ra.nms.backend.LEEntityMessage;
import com.lucent.ra.nms.util.LEDebug;
import com.lucent.ra.nms.util.LEUpTimeCompare;
import java.io.Serializable;
import java.util.Date;

public class LELogUserLoginMessage
extends LEEntityMessage
implements Serializable {
    String m_portName;
    String m_calledNo;
    String m_user;
    int m_time;
    String m_ftime;
    String m_desc;
    Date m_date = new Date(System.currentTimeMillis());

    public LELogUserLoginMessage(String id, int request, String name) {
        super(id, request, name);
        this.m_messageType = "LOG";
    }

    public String getPortName() {
        return this.m_portName;
    }

    public String getCalledNo() {
        return this.m_calledNo;
    }

    public String getUsername() {
        return this.m_user;
    }

    public int getMinutes() {
        return this.m_time;
    }

    public String getFormatedTime() {
        if (this.m_ftime == null) {
            this.m_ftime = LEUpTimeCompare.FormatTime(this.m_time);
        }
        return this.m_ftime;
    }

    public String getDescription() {
        return this.m_desc;
    }

    public Date getDate() {
        return this.m_date;
    }

    public void setAttribute(int attribute, String value) {
        try {
            switch (attribute) {
                case 275: {
                    this.setBoard(value);
                    break;
                }
                case 553: {
                    this.setAdminGroup(value);
                    break;
                }
                case 555: {
                    this.extractTime(value);
                    break;
                }
                case 554: {
                    this.m_desc = value;
                    break;
                }
                case 1: {
                    this.m_portName = value;
                    break;
                }
                case 493: {
                    this.m_calledNo = value;
                    break;
                }
                case 2: {
                    this.m_user = value;
                    break;
                }
                default: {
                    return;
                }
            }
        }
        catch (Exception e) {
            LEDebug.getLog().logln(20, e);
        }
    }

    void extractTime(String time) {
        try {
            int ptr = time.indexOf(58);
            if (ptr > -1) {
                int hours = Integer.parseInt(time.substring(0, ptr));
                int minutes = Integer.parseInt(time.substring(ptr + 1));
                this.m_time = hours * 60 + minutes;
            } else {
                ptr = time.indexOf("days");
                if (ptr > -1) {
                    int days = Integer.parseInt(time.substring(0, ptr));
                    this.m_time = days * 1440;
                } else {
                    this.m_time = Integer.parseInt(time);
                }
            }
        }
        catch (Exception e) {
            LEDebug.getLog().logln(20, e);
        }
    }
}

