/*
 * Decompiled with CFR 0.152.
 */
package com.lucent.ra.nms.model;

import com.lucent.ra.nms.model.LEDataSpec;
import com.lucent.ra.nms.util.LEDebug;
import com.lucent.ra.nms.util.LEResource;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import java.util.Stack;
import java.util.Vector;

public class LEDataSpecFactory {
    public static final String SPEC_FILE = "pmspec.cfg";
    public static final String SPEC_SUFFIX = "spec.cfg";
    public static final String DEP_STRING = "#";
    public static final String BLANK = "";
    protected static final char s_TOKEN_SEP = ',';
    protected static final char s_COMMENT = '#';
    protected static final char s_DEF_START = '{';
    protected static final char s_DEF_END = '}';
    protected static final char s_VALUE_SEP = '=';
    protected static final char s_ENUM_SEP = '|';
    protected static final char s_DEPENDENCY = '#';
    protected Hashtable m_specs = new Hashtable();
    static LEDataSpecFactory s_factory = null;

    public static LEDataSpecFactory GetFactory() {
        if (s_factory == null) {
            s_factory = new LEDataSpecFactory();
        }
        return s_factory;
    }

    public static synchronized LEDataSpec GetPortMasterSpec() throws IOException {
        return LEDataSpecFactory.GetFactory().getPortMasterSpec();
    }

    public static synchronized LEDataSpec GetSpec(String platformKey) throws IOException {
        return LEDataSpecFactory.GetFactory().getSpec(platformKey);
    }

    public synchronized LEDataSpec getPortMasterSpec() throws IOException {
        LEDataSpec spec = (LEDataSpec)this.m_specs.get(SPEC_FILE);
        if (spec == null) {
            BufferedReader reader = LEResource.GetText(SPEC_FILE);
            if (reader == null) {
                throw new IOException("Missing file: pmspec.cfg");
            }
            spec = LEDataSpecFactory.createFrom(reader);
            this.m_specs.put(SPEC_FILE, spec);
        }
        return spec;
    }

    public synchronized LEDataSpec getSpec(String platformKey) throws IOException {
        String specfile = String.valueOf(platformKey) + SPEC_SUFFIX;
        LEDataSpec spec = (LEDataSpec)this.m_specs.get(specfile);
        if (spec == null) {
            BufferedReader reader = LEResource.GetText(specfile);
            if (reader == null) {
                throw new IOException("Missing file: " + specfile);
            }
            spec = LEDataSpecFactory.createFrom(reader);
            this.m_specs.put(specfile, spec);
        }
        return spec;
    }

    public static synchronized LEDataSpec createFrom(BufferedReader reader) throws IOException {
        LEDataSpec root;
        LEDataSpec current = root = new LEDataSpec(BLANK, "PortMaster", "LEConfig", null);
        Vector tokens = null;
        Stack<LEDataSpec> specStack = new Stack<LEDataSpec>();
        String line = reader.readLine();
        while (line != null) {
            int len = line.length();
            if (len == 0) {
                line = reader.readLine();
                continue;
            }
            int ptr = LEDataSpecFactory.eatSpace(line, 0);
            if (ptr >= len) {
                line = reader.readLine();
                continue;
            }
            switch (line.charAt(ptr)) {
                case '{': {
                    specStack.push(current);
                    if (tokens == null) break;
                    LEDataSpec spec = LEDataSpecFactory.createSpec(tokens, true);
                    tokens = null;
                    if (spec == null) break;
                    current.addSpec(spec);
                    current = spec;
                    break;
                }
                case '}': {
                    LEDataSpec spec;
                    if (tokens != null) {
                        spec = LEDataSpecFactory.createSpec(tokens, false);
                        tokens = null;
                        if (spec != null) {
                            current.addSpec(spec);
                        }
                    }
                    current = (LEDataSpec)specStack.pop();
                    break;
                }
                default: {
                    LEDataSpec spec;
                    if (tokens != null && (spec = LEDataSpecFactory.createSpec(tokens, false)) != null) {
                        current.addSpec(spec);
                    }
                    if ((tokens = LEDataSpecFactory.tokenize(line)) != null && tokens.size() >= 3) break;
                    LEDebug.getLog().logln(20, "Bad spec: " + line);
                    tokens = null;
                }
                case '#': 
            }
            line = reader.readLine();
        }
        return root;
    }

    protected static LEDataSpec createSpec(Vector tokens, boolean composite) {
        LEDataSpec spec = null;
        try {
            String tag = (String)tokens.elementAt(0);
            String description = (String)tokens.elementAt(1);
            String type = (String)tokens.elementAt(2);
            Hashtable attributes = LEDataSpecFactory.extractAttributes(tokens, 3);
            spec = new LEDataSpec(tag, description, type, attributes);
        }
        catch (NoSuchElementException e) {
            LEDebug.getLog().logln(20, e);
            spec = null;
        }
        return spec;
    }

    protected static Vector tokenize(String str) {
        Vector<String> tokens = null;
        int ptr = 0;
        int len = str.length();
        while (ptr < len) {
            String token;
            int tok_ptr = (ptr = LEDataSpecFactory.eatSpace(str, ptr)) < len ? str.indexOf(44, ptr) : -1;
            if (tok_ptr > -1) {
                token = str.substring(ptr, tok_ptr);
                ptr = tok_ptr + 1;
            } else if (ptr < len) {
                token = str.substring(ptr, len);
                ptr = len;
            } else {
                token = null;
            }
            if (token == null) continue;
            if (tokens == null) {
                tokens = new Vector<String>();
            }
            tokens.addElement(token);
        }
        return tokens;
    }

    protected static int eatSpace(String str, int ptr) {
        int ret = ptr;
        while (ret < str.length() && Character.isWhitespace(str.charAt(ret))) {
            ++ret;
        }
        return ret;
    }

    protected static Hashtable extractAttributes(Vector tokens, int index) {
        Hashtable<String, String> attrs = null;
        try {
            int size = tokens.size();
            while (size > index) {
                Object value;
                String name;
                String token = (String)tokens.elementAt(index++);
                int len = token.length();
                int val_sep = token.indexOf(61);
                if (val_sep > -1) {
                    name = token.substring(0, val_sep);
                    value = token.substring(val_sep + 1, len);
                    if (token.indexOf(124, val_sep) > -1 || name.charAt(0) == '#') {
                        value = LEDataSpecFactory.extractEnumValues((String)value);
                    }
                } else {
                    name = token;
                    value = BLANK;
                }
                if (attrs == null) {
                    attrs = new Hashtable<String, String>();
                }
                attrs.put(name, (String)value);
                if (name.charAt(0) != '#') continue;
                attrs.put(DEP_STRING, DEP_STRING);
            }
        }
        catch (IndexOutOfBoundsException e) {
            LEDebug.getLog().logln(20, e);
        }
        return attrs;
    }

    protected static Vector extractEnumValues(String value) {
        Vector<String> enums = new Vector<String>();
        int ptr = 0;
        int len = value.length();
        while (ptr < len) {
            String string;
            int sep = value.indexOf(124, ptr);
            if (sep > -1) {
                string = value.substring(ptr, sep);
                ptr = sep + 1;
            } else {
                string = value.substring(ptr, len);
                ptr = len;
            }
            enums.addElement(string);
        }
        return enums;
    }
}

