/*
 * Decompiled with CFR 0.152.
 */
package com.lucent.ra.nms.model;

import com.lucent.ra.nms.model.LEConfig;
import com.lucent.ra.nms.model.LEConnectionFacade;
import com.lucent.ra.nms.util.LEVector;

public class LEIPRange
extends LEConfig {
    public static final String GATEWAY = "522";
    public static final String POOL_SIZE = "165";
    public static final String NETMASK = "15";
    public static final int KEY_COUNT = 3;
    static String[] s_keys = null;
    String m_pool;
    String m_address;
    String m_tag;
    boolean m_reboot;

    public static String[] GetAllPossibleKeys() {
        if (s_keys == null) {
            s_keys = new String[3];
            int i = 0;
            LEIPRange.s_keys[i++] = GATEWAY;
            LEIPRange.s_keys[i++] = POOL_SIZE;
            LEIPRange.s_keys[i++] = NETMASK;
        }
        return s_keys;
    }

    public LEIPRange(LEConnectionFacade facade, String pool, String address) {
        super(facade);
        this.m_pool = pool;
        this.m_address = address;
    }

    public Object clone() {
        LEIPRange config = new LEIPRange(this.m_facade, this.m_pool, this.m_address);
        config.copy(this);
        return config;
    }

    public String getPool() {
        return this.m_pool;
    }

    public boolean requiresReset(String key) {
        return key.equals(GATEWAY) || key.equals(POOL_SIZE) || key.equals(NETMASK);
    }

    boolean getAllCommands(LEVector cmds) {
        boolean ret = super.getAllCommands(cmds);
        if (ret && this.m_reboot) {
            cmds.addElement("save all");
            cmds.addElement("reset ippool");
            this.m_reboot = false;
        }
        return ret;
    }

    boolean getChangedCommands(LEVector cmds) {
        boolean ret = super.getChangedCommands(cmds);
        if (ret && this.m_reboot) {
            cmds.addElement("save all");
            cmds.addElement("reset ippool");
            this.m_reboot = false;
        }
        return ret;
    }

    boolean generateCommands(LEVector keys, LEVector cmds) {
        boolean allCmds = keys == null;
        int start = cmds.size();
        StringBuffer buf = new StringBuffer();
        buf.append("set ");
        buf.append("ippool ");
        buf.append(this.m_pool);
        buf.append(" address-range ");
        buf.append(this.m_address);
        buf.append("/");
        buf.append((String)this.get(NETMASK));
        String gateway = (String)this.get(GATEWAY);
        if (!gateway.equals("")) {
            buf.append(" ");
            buf.append(gateway);
        }
        cmds.addElement(buf.toString());
        this.m_reboot = true;
        return cmds.size() > start;
    }
}

