/*
 * Decompiled with CFR 0.152.
 */
package com.lucent.ra.nms.model;

import com.lucent.ra.nms.model.LEDLCITable;
import com.lucent.ra.nms.model.LEDialScript;
import com.lucent.ra.nms.model.LELocation;
import com.lucent.ra.nms.model.LELocations;
import com.lucent.ra.nms.util.LEDebug;
import com.lucent.ra.nms.util.LEVector;
import com.oroinc.text.regex.MalformedPatternException;
import com.oroinc.text.regex.MatchResult;
import com.oroinc.text.regex.Pattern;
import com.oroinc.text.regex.Perl5Compiler;
import com.oroinc.text.regex.Perl5Matcher;
import com.oroinc.text.regex.Perl5Pattern;
import java.io.PrintStream;
import java.util.StringTokenizer;

public class LELocationFileParser {
    private static final String ANALOG_STRING = "set\\s+loc\\w*\\s+(\\S+)\\s+an\\w*\\s+(\\w+)";
    private static final String CHAP_STRING = "set loc\\w* (\\S+) ch\\w* (\\w+)";
    private static final String COMPRESSION_STRING = "set loc\\w* (\\S+) com\\w* (\\w+)";
    private static final String DESTINATION_STRING = "set loc\\w* (\\S+) de\\w* (\\d{1,3}).(\\d{1,3}).(\\d{1,3}).(\\d{1,3})";
    private static final String GROUP_STRING = "set loc\\w* (\\S+) gr\\w* (\\d+)";
    private static final String HIGHWATER_STRING = "set loc\\w* (\\S+) hi\\w* (\\d+)";
    private static final String IDLETIMEOUT_STRING = "set loc\\w* (\\S+) id\\w* (\\d+) (\\w*)";
    private static final String INPUTFILTER_STRING = "set loc\\w* (\\S+) if\\w* (\\S+)";
    private static final String IPSEC_ACTIVE_PROF_STRING = "set loc\\w* (\\S+) ipsec a\\w*p\\w* (\\S+)";
    private static final String IPSEC_LOG_CONSOLE_STRING = "set loc\\w* (\\S+) ipsec log cons\\w* (\\w*)";
    private static final String IPSEC_LOG_SYSLOG_STRING = "set loc\\w* (\\S+) ipsec log s\\w*l\\w* (\\w*)";
    private static final String IPSEC_LOG_SUCCESS_STRING = "set loc\\w* (\\S+) ipsec log sas\\w* (\\w*)";
    private static final String IPSEC_LOG_FAIL_STRING = "set loc\\w* (\\S+) ipsec log saf\\w* (\\w*)";
    private static final String IPSEC_OUTSRC_PROF_STRING = "set loc\\w* (\\S+) ipsec o\\w*p\\w* (\\S+)";
    private static final String IPSEC_PASSIVE_PROF_STRING = "set loc\\w* (\\S+) ipsec p\\w*p\\w* (\\S+)";
    private static final String IPSEC_PDA_STRING = "set loc\\w* (\\S+) ipsec p\\w*d\\w*a\\w* (\\S+)";
    private static final String IPXNETWORK_STRING = "set loc\\w* (\\S+) ipx\\w* (\\w+)";
    private static final String LOCALADDR_STRING = "set loc\\w* (\\S+) lo\\S* (\\d{1,3}).(\\d{1,3}).(\\d{1,3}).(\\d{1,3})";
    private static final String MAP_STRING = "set loc\\w* (\\S+) map\\w* (\\S+)";
    private static final String MAXPORTS_STRING = "set loc\\w* (\\S+) max\\w* (\\d+)";
    private static final String MTU_STRING = "set loc\\w* (\\S+) mt\\w* (\\d+)";
    private static final String MULTILINK_STRING = "set loc\\w* (\\S+) mu\\w* (\\w+)";
    private static final String NAT_INMAP_STRING = "set loc\\w* (\\S+) nat i\\w*map (\\w*)\\s*(\\w*)";
    private static final String NAT_PROXY_INMAP_STRING = "set loc\\w* (\\S+) nat i\\w*map (\\w*) outs\\w*";
    private static final String NAT_OUTMAP_STRING = "set loc\\w* (\\S+) nat o\\w*map (\\w*)\\s*(\\w*)";
    private static final String NAT_PROXY_OUTMAP_STRING = "set loc\\w* (\\S+) nat o\\w*map (\\w*) outs\\w*";
    private static final String NAT_LOG_CONSOLE_STRING = "set loc\\w* (\\S+) nat log cons\\w* (\\w*)";
    private static final String NAT_LOG_SYSLOG_STRING = "set loc\\w* (\\S+) nat log s\\w*l\\w* (\\w*)";
    private static final String NAT_LOG_SUCCESS_STRING = "set loc\\w* (\\S+) nat log ss\\w* (\\w*)";
    private static final String NAT_LOG_SUCCESS_STRING2 = "set loc\\w* (\\S+) nat log sessions\\w* (\\w*)";
    private static final String NAT_LOG_FAIL_STRING = "set loc\\w* (\\S+) nat log sf\\w* (\\w*)";
    private static final String NAT_LOG_FAIL_STRING2 = "set loc\\w* (\\S+) nat log sessionf\\w* (\\w*)";
    private static final String NAT_TIMEOUT_STRING = "set loc\\w* (\\S+) nat s\\w*t\\w*o\\w* (\\w+) (\\d{1,5}) (\\w*)";
    private static final String NAT_FAILURE_STRING = "set loc\\w* (\\S+) nat s\\w*d\\w*f\\w*a\\w* (\\w+)";
    private static final String NETMASK_STRING = "set loc\\w* (\\S+) ne\\w* (\\d{1,3}).(\\d{1,3}).(\\d{1,3}).(\\d{1,3})";
    private static final String OUTPUTFILTER_STRING = "set loc\\w* (\\S+) of\\w* (\\S+)";
    private static final String OSPF_STRING = "set loc\\w* (\\S+) os\\w*\\s*.";
    private static final String PASSWORD_STRING = "set loc\\w* (\\S+) pa\\w* (\\S+)";
    private static final String PHONE_STRING = "set loc\\w* (\\S+) ph\\w* (\\S+)";
    private static final String PROTOCOL_STRING = "set loc\\w* (\\S+) pr\\w* (\\S+)";
    private static final String REVDIAL_STRING = "set loc\\w* (\\S+) re\\S* (\\S+)";
    private static final String RIP_STRING = "set loc\\w* (\\S+) ri\\w* (\\w+)";
    private static final String RIPCOST_STRING = "set loc\\w* (\\S+) ri\\w* co\\w* (\\d+)";
    private static final String RIPV2_STRING = "set loc\\w* (\\S+) rip v2 (\\w+)";
    private static final String SCRIPT_STRING = "set loc\\w* (\\S+) sc\\w* (\\d+)\\s*(\\S*)\\s*(\\S*)";
    private static final String TELEPHONE_STRING = "set loc\\w* (\\S+) te\\w* (\\S+)";
    private static final String USERNAME_STRING = "set loc\\w* (\\S+) us\\w* (\\S+)";
    private static final String VOICE_STRING = "set loc\\w* (\\S+) vo\\w* (\\w+)";
    private static final String V25BIS_STRING = "set loc\\w* (\\S+) v25\\w* (\\d+)\\s*(\\S*)\\s*(\\S*)";
    LELocations m_locations = new LELocations(null);
    LELocation m_location;
    String m_locname = "";
    Perl5Matcher m_matcher = new Perl5Matcher();
    MatchResult m_result;
    Perl5Pattern m_analogPattern;
    Perl5Pattern m_chapPattern;
    Perl5Pattern m_compressionPattern;
    Perl5Pattern m_destinationPattern;
    Perl5Pattern m_groupPattern;
    Perl5Pattern m_highPattern;
    Perl5Pattern m_idlePattern;
    Perl5Pattern m_ifilterPattern;
    Perl5Pattern m_ipsecactprofPattern;
    Perl5Pattern m_ipseclogsysPattern;
    Perl5Pattern m_ipseclogconPattern;
    Perl5Pattern m_ipseclogssPattern;
    Perl5Pattern m_ipseclogsfPattern;
    Perl5Pattern m_ipsecoutsrcprofPattern;
    Perl5Pattern m_ipsecpassiveprofPattern;
    Perl5Pattern m_ipsecpdaPattern;
    Perl5Pattern m_ipxnetPattern;
    Perl5Pattern m_localPattern;
    Perl5Pattern m_mapPattern;
    Perl5Pattern m_maxPattern;
    Perl5Pattern m_mtuPattern;
    Perl5Pattern m_multiPattern;
    Perl5Pattern m_natimapPattern;
    Perl5Pattern m_natimapproxyPattern;
    Perl5Pattern m_natomapPattern;
    Perl5Pattern m_natomapproxyPattern;
    Perl5Pattern m_natlogsysPattern;
    Perl5Pattern m_natlogconPattern;
    Perl5Pattern m_natlogssPattern;
    Perl5Pattern m_natlogssPattern2;
    Perl5Pattern m_natlogsfPattern;
    Perl5Pattern m_natlogsfPattern2;
    Perl5Pattern m_natfailPattern;
    Perl5Pattern m_nattimeoutPattern;
    Perl5Pattern m_netmaskPattern;
    Perl5Pattern m_ofilterPattern;
    Perl5Pattern m_ospfPattern;
    Perl5Pattern m_passwordPattern;
    Perl5Pattern m_phonePattern;
    Perl5Pattern m_protocolPattern;
    Perl5Pattern m_revdialPattern;
    Perl5Pattern m_ripPattern;
    Perl5Pattern m_ripCostPattern;
    Perl5Pattern m_ripv2Pattern;
    Perl5Pattern m_scriptPattern;
    Perl5Pattern m_telePattern;
    Perl5Pattern m_userPattern;
    Perl5Pattern m_voicePattern;
    Perl5Pattern m_v25bisPattern;

    public boolean createPatterns() {
        Perl5Compiler compiler = new Perl5Compiler();
        try {
            this.m_analogPattern = (Perl5Pattern)compiler.compile(ANALOG_STRING, 1);
            this.m_chapPattern = (Perl5Pattern)compiler.compile(CHAP_STRING, 1);
            this.m_compressionPattern = (Perl5Pattern)compiler.compile(COMPRESSION_STRING, 1);
            this.m_destinationPattern = (Perl5Pattern)compiler.compile(DESTINATION_STRING, 1);
            this.m_groupPattern = (Perl5Pattern)compiler.compile(GROUP_STRING, 1);
            this.m_highPattern = (Perl5Pattern)compiler.compile(HIGHWATER_STRING, 1);
            this.m_idlePattern = (Perl5Pattern)compiler.compile(IDLETIMEOUT_STRING, 1);
            this.m_ifilterPattern = (Perl5Pattern)compiler.compile(INPUTFILTER_STRING, 1);
            this.m_ipsecactprofPattern = (Perl5Pattern)compiler.compile(IPSEC_ACTIVE_PROF_STRING, 1);
            this.m_ipseclogsysPattern = (Perl5Pattern)compiler.compile(IPSEC_LOG_SYSLOG_STRING, 1);
            this.m_ipseclogconPattern = (Perl5Pattern)compiler.compile(IPSEC_LOG_CONSOLE_STRING, 1);
            this.m_ipseclogssPattern = (Perl5Pattern)compiler.compile(IPSEC_LOG_SUCCESS_STRING, 1);
            this.m_ipseclogsfPattern = (Perl5Pattern)compiler.compile(IPSEC_LOG_FAIL_STRING, 1);
            this.m_ipsecpassiveprofPattern = (Perl5Pattern)compiler.compile(IPSEC_PASSIVE_PROF_STRING, 1);
            this.m_ipsecoutsrcprofPattern = (Perl5Pattern)compiler.compile(IPSEC_OUTSRC_PROF_STRING, 1);
            this.m_ipsecpdaPattern = (Perl5Pattern)compiler.compile(IPSEC_PDA_STRING, 1);
            this.m_ipxnetPattern = (Perl5Pattern)compiler.compile(IPXNETWORK_STRING, 1);
            this.m_localPattern = (Perl5Pattern)compiler.compile(LOCALADDR_STRING, 1);
            this.m_mapPattern = (Perl5Pattern)compiler.compile(MAP_STRING, 1);
            this.m_maxPattern = (Perl5Pattern)compiler.compile(MAXPORTS_STRING, 1);
            this.m_mtuPattern = (Perl5Pattern)compiler.compile(MTU_STRING, 1);
            this.m_multiPattern = (Perl5Pattern)compiler.compile(MULTILINK_STRING, 1);
            this.m_natimapPattern = (Perl5Pattern)compiler.compile(NAT_INMAP_STRING, 1);
            this.m_natimapproxyPattern = (Perl5Pattern)compiler.compile(NAT_PROXY_INMAP_STRING, 1);
            this.m_natomapPattern = (Perl5Pattern)compiler.compile(NAT_OUTMAP_STRING, 1);
            this.m_natomapproxyPattern = (Perl5Pattern)compiler.compile(NAT_PROXY_OUTMAP_STRING, 1);
            this.m_natlogsysPattern = (Perl5Pattern)compiler.compile(NAT_LOG_SYSLOG_STRING, 1);
            this.m_natlogconPattern = (Perl5Pattern)compiler.compile(NAT_LOG_CONSOLE_STRING, 1);
            this.m_natlogssPattern = (Perl5Pattern)compiler.compile(NAT_LOG_SUCCESS_STRING, 1);
            this.m_natlogssPattern2 = (Perl5Pattern)compiler.compile(NAT_LOG_SUCCESS_STRING2, 1);
            this.m_natlogsfPattern = (Perl5Pattern)compiler.compile(NAT_LOG_FAIL_STRING, 1);
            this.m_natlogsfPattern2 = (Perl5Pattern)compiler.compile(NAT_LOG_FAIL_STRING2, 1);
            this.m_natfailPattern = (Perl5Pattern)compiler.compile(NAT_FAILURE_STRING, 1);
            this.m_nattimeoutPattern = (Perl5Pattern)compiler.compile(NAT_TIMEOUT_STRING, 1);
            this.m_netmaskPattern = (Perl5Pattern)compiler.compile(NETMASK_STRING, 1);
            this.m_ofilterPattern = (Perl5Pattern)compiler.compile(OUTPUTFILTER_STRING, 1);
            this.m_ospfPattern = (Perl5Pattern)compiler.compile(OSPF_STRING, 1);
            this.m_passwordPattern = (Perl5Pattern)compiler.compile(PASSWORD_STRING, 1);
            this.m_phonePattern = (Perl5Pattern)compiler.compile(PHONE_STRING, 1);
            this.m_protocolPattern = (Perl5Pattern)compiler.compile(PROTOCOL_STRING, 1);
            this.m_revdialPattern = (Perl5Pattern)compiler.compile(REVDIAL_STRING, 1);
            this.m_ripPattern = (Perl5Pattern)compiler.compile(RIP_STRING, 1);
            this.m_ripCostPattern = (Perl5Pattern)compiler.compile(RIPCOST_STRING, 1);
            this.m_ripv2Pattern = (Perl5Pattern)compiler.compile(RIPV2_STRING, 1);
            this.m_scriptPattern = (Perl5Pattern)compiler.compile(SCRIPT_STRING, 1);
            this.m_telePattern = (Perl5Pattern)compiler.compile(TELEPHONE_STRING, 1);
            this.m_userPattern = (Perl5Pattern)compiler.compile(USERNAME_STRING, 1);
            this.m_voicePattern = (Perl5Pattern)compiler.compile(VOICE_STRING, 1);
            this.m_v25bisPattern = (Perl5Pattern)compiler.compile(V25BIS_STRING, 1);
        }
        catch (MalformedPatternException e) {
            LEDebug.getLog().logln(20, e);
            return false;
        }
        return true;
    }

    public void readLocations(LEVector cmds) {
        int len = cmds.size();
        try {
            int i = 0;
            while (i < len) {
                String line = (String)cmds.elementAt(i);
                if (!line.startsWith("#") && line.length() >= 3 && !line.equals("save all")) {
                    int strlen = line.length();
                    String begin = line.substring(3, strlen).toLowerCase();
                    if (line.regionMatches(true, 0, "add ", 0, 4)) {
                        if (line.indexOf("dlci") > -1) {
                            this.addDLCITable(line);
                        } else if (line.indexOf("loc") > -1 && !this.addLocation(line)) {
                            break;
                        }
                    } else if (line.regionMatches(true, 0, "set ", 0, 4)) {
                        this.parseLocation(line);
                    }
                }
                ++i;
            }
        }
        catch (Exception e) {
            LEDebug.getLog().logln(20, e);
        }
    }

    public LELocations getLocations() {
        return this.m_locations;
    }

    public void writeLocations(PrintStream stream) {
        LEVector cmds = new LEVector();
        this.m_locations.getCommands(cmds);
        int len = cmds.size() - 1;
        int i = 0;
        while (i < len) {
            String command = (String)cmds.elementAt(i);
            stream.println(command);
            ++i;
        }
    }

    protected boolean addLocation(String line) {
        StringTokenizer tokenizer = new StringTokenizer(line);
        tokenizer.nextToken();
        tokenizer.nextToken();
        if (!tokenizer.hasMoreTokens()) {
            return false;
        }
        String locname = tokenizer.nextToken();
        LELocation location = new LELocation(null, locname);
        location.initialize();
        this.m_locations.setField(locname, location);
        this.m_locname = locname;
        this.m_location = location;
        return true;
    }

    protected void addDLCITable(String line) {
        StringTokenizer tokenizer = new StringTokenizer(line);
        tokenizer.nextToken();
        String dlcitype = tokenizer.nextToken().toLowerCase();
        String locname = tokenizer.nextToken();
        LELocation location = (LELocation)this.m_locations.getConfig(locname);
        LEDLCITable dlcitable = null;
        if (dlcitype.startsWith("dlc") || dlcitype.startsWith("ipd")) {
            dlcitable = (LEDLCITable)location.getConfig("ipdlci");
        } else if (dlcitype.startsWith("ipxd")) {
            dlcitable = (LEDLCITable)location.getConfig("ipxdlci");
        }
        String num = tokenizer.nextToken();
        String address = tokenizer.nextToken();
        if (dlcitable != null) {
            dlcitable.setField(num, address);
        }
    }

    protected void parseLocation(String locparam) {
        try {
            if (this.m_matcher.contains(locparam, (Pattern)this.m_analogPattern)) {
                this.setParameter("292", this.m_matcher.getMatch());
            } else if (this.m_matcher.contains(locparam, (Pattern)this.m_chapPattern)) {
                this.setParameter("170", this.m_matcher.getMatch());
            } else if (this.m_matcher.contains(locparam, (Pattern)this.m_compressionPattern)) {
                this.setParameter("290", this.m_matcher.getMatch());
            } else if (this.m_matcher.contains(locparam, (Pattern)this.m_destinationPattern)) {
                String address = this.setAddressParameter("9", this.m_matcher.getMatch());
                if (address.equals("255.255.255.255")) {
                    this.m_location.setField("74", "negotiated");
                } else {
                    this.m_location.setField("74", "specified");
                }
            } else if (this.m_matcher.contains(locparam, (Pattern)this.m_groupPattern)) {
                this.setParameter("129", this.m_matcher.getMatch());
            } else if (this.m_matcher.contains(locparam, (Pattern)this.m_highPattern)) {
                this.setParameter("298", this.m_matcher.getMatch());
            } else if (this.m_matcher.contains(locparam, (Pattern)this.m_idlePattern)) {
                MatchResult result = this.m_matcher.getMatch();
                String idletime = result.group(2);
                String scale = result.group(3);
                StringBuffer buffer = new StringBuffer(idletime);
                buffer.append(" ");
                if (scale != null) {
                    buffer.append(scale);
                } else {
                    buffer.append("minutes");
                }
                this.setLocation(result);
                this.m_location.setField("297", buffer.toString());
            } else if (this.m_matcher.contains(locparam, (Pattern)this.m_ifilterPattern)) {
                this.setParameter("193", this.m_matcher.getMatch());
            } else if (this.m_matcher.contains(locparam, (Pattern)this.m_ipsecactprofPattern)) {
                this.setIPSecParameter("501", this.m_matcher.getMatch());
            } else if (this.m_matcher.contains(locparam, (Pattern)this.m_ipseclogsysPattern)) {
                this.setIPSecParameter("498", this.m_matcher.getMatch());
            } else if (this.m_matcher.contains(locparam, (Pattern)this.m_ipseclogconPattern)) {
                this.setIPSecParameter("499", this.m_matcher.getMatch());
            } else if (this.m_matcher.contains(locparam, (Pattern)this.m_ipseclogssPattern)) {
                this.setIPSecParameter("497", this.m_matcher.getMatch());
            } else if (this.m_matcher.contains(locparam, (Pattern)this.m_ipseclogsfPattern)) {
                this.setIPSecParameter("496", this.m_matcher.getMatch());
            } else if (this.m_matcher.contains(locparam, (Pattern)this.m_ipsecoutsrcprofPattern)) {
                this.setIPSecParameter("500", this.m_matcher.getMatch());
            } else if (this.m_matcher.contains(locparam, (Pattern)this.m_ipsecpassiveprofPattern)) {
                this.setIPSecParameter("502", this.m_matcher.getMatch());
            } else if (this.m_matcher.contains(locparam, (Pattern)this.m_ipsecpdaPattern)) {
                this.setIPSecParameter("503", this.m_matcher.getMatch());
            } else if (this.m_matcher.contains(locparam, (Pattern)this.m_ipxnetPattern)) {
                this.setParameter("189", this.m_matcher.getMatch());
            } else if (this.m_matcher.contains(locparam, (Pattern)this.m_localPattern)) {
                this.setAddressParameter("177", this.m_matcher.getMatch());
            } else if (this.m_matcher.contains(locparam, (Pattern)this.m_mapPattern)) {
                this.setParameter("299", this.m_matcher.getMatch());
            } else if (this.m_matcher.contains(locparam, (Pattern)this.m_maxPattern)) {
                this.setParameter("296", this.m_matcher.getMatch());
            } else if (this.m_matcher.contains(locparam, (Pattern)this.m_mtuPattern)) {
                this.setParameter("295", this.m_matcher.getMatch());
            } else if (this.m_matcher.contains(locparam, (Pattern)this.m_multiPattern)) {
                this.setParameter("291", this.m_matcher.getMatch());
            } else if (this.m_matcher.contains(locparam, (Pattern)this.m_netmaskPattern)) {
                this.setAddressParameter("15", this.m_matcher.getMatch());
            } else if (this.m_matcher.contains(locparam, (Pattern)this.m_natimapPattern)) {
                MatchResult result = this.m_matcher.getMatch();
                String proxy = result.group(3);
                if (proxy != null && proxy.startsWith("pr")) {
                    this.setNATParameter("357", result);
                } else {
                    this.setNATParameter("356", result);
                }
            } else if (this.m_matcher.contains(locparam, (Pattern)this.m_natimapproxyPattern)) {
                this.setNATParameter("357", this.m_matcher.getMatch());
            } else if (this.m_matcher.contains(locparam, (Pattern)this.m_natomapPattern)) {
                MatchResult result = this.m_matcher.getMatch();
                String proxy = result.group(3);
                if (proxy != null && proxy.startsWith("pr")) {
                    this.setNATParameter("359", result);
                } else {
                    this.setNATParameter("358", result);
                }
            } else if (this.m_matcher.contains(locparam, (Pattern)this.m_natomapproxyPattern)) {
                this.setNATParameter("359", this.m_matcher.getMatch());
            } else if (this.m_matcher.contains(locparam, (Pattern)this.m_natlogsysPattern)) {
                this.setNATParameter("362", this.m_matcher.getMatch());
            } else if (this.m_matcher.contains(locparam, (Pattern)this.m_natlogconPattern)) {
                this.setNATParameter("363", this.m_matcher.getMatch());
            } else if (this.m_matcher.contains(locparam, (Pattern)this.m_natlogssPattern) || this.m_matcher.contains(locparam, (Pattern)this.m_natlogssPattern2)) {
                this.setNATParameter("361", this.m_matcher.getMatch());
            } else if (this.m_matcher.contains(locparam, (Pattern)this.m_natlogsfPattern) || this.m_matcher.contains(locparam, (Pattern)this.m_natlogsfPattern2)) {
                this.setNATParameter("360", this.m_matcher.getMatch());
            } else if (this.m_matcher.contains(locparam, (Pattern)this.m_natfailPattern)) {
                this.setNATParameter("355", this.m_matcher.getMatch());
            } else if (this.m_matcher.contains(locparam, (Pattern)this.m_nattimeoutPattern)) {
                this.setNATTimeoutParameter(this.m_matcher.getMatch());
            } else if (this.m_matcher.contains(locparam, (Pattern)this.m_ofilterPattern)) {
                this.setParameter("194", this.m_matcher.getMatch());
            } else if (this.m_matcher.contains(locparam, (Pattern)this.m_ospfPattern)) {
                this.setOSPFParameters(locparam);
            } else if (this.m_matcher.contains(locparam, (Pattern)this.m_passwordPattern)) {
                this.setParameter("300", this.m_matcher.getMatch());
            } else if (this.m_matcher.contains(locparam, (Pattern)this.m_revdialPattern)) {
                this.setParameter("525", this.m_matcher.getMatch());
            } else if (this.m_matcher.contains(locparam, (Pattern)this.m_ripv2Pattern)) {
                this.setParameter("rip_v2", this.m_matcher.getMatch());
            } else if (this.m_matcher.contains(locparam, (Pattern)this.m_ripCostPattern)) {
                this.setParameter("198", this.m_matcher.getMatch());
            } else if (this.m_matcher.contains(locparam, (Pattern)this.m_ripPattern)) {
                this.setParameter("rip", this.m_matcher.getMatch());
            } else if (this.m_matcher.contains(locparam, (Pattern)this.m_scriptPattern)) {
                this.setScriptParameter("script", this.m_matcher.getMatch());
            } else if (this.m_matcher.contains(locparam, (Pattern)this.m_phonePattern) || this.m_matcher.contains(locparam, (Pattern)this.m_telePattern)) {
                this.setParameter("301", this.m_matcher.getMatch());
            } else if (this.m_matcher.contains(locparam, (Pattern)this.m_protocolPattern)) {
                this.setParameter("289", this.m_matcher.getMatch());
            } else if (this.m_matcher.contains(locparam, (Pattern)this.m_userPattern)) {
                this.setParameter("2", this.m_matcher.getMatch());
            } else if (this.m_matcher.contains(locparam, (Pattern)this.m_voicePattern)) {
                this.setParameter("293", this.m_matcher.getMatch());
            } else if (this.m_matcher.contains(locparam, (Pattern)this.m_v25bisPattern)) {
                this.setScriptParameter("v25bis", this.m_matcher.getMatch());
            }
        }
        catch (Exception e) {
            LEDebug.getLog().logln(20, e);
        }
    }

    protected void setLocation(MatchResult result) {
        String locname = result.group(1);
        if (!locname.equals(this.m_locname)) {
            this.m_location = (LELocation)this.m_locations.get(locname);
            this.m_locname = locname;
        }
    }

    protected void setParameter(String attribute, MatchResult result) {
        this.setLocation(result);
        String group2 = result.group(2);
        if (group2 != null) {
            this.m_location.setField(attribute, result.group(2));
        }
    }

    protected String setAddressParameter(String attribute, MatchResult result) {
        this.setLocation(result);
        String oct1 = result.group(2);
        String oct2 = result.group(3);
        String oct3 = result.group(4);
        String oct4 = result.group(5);
        StringBuffer address = new StringBuffer();
        address.append(oct1);
        address.append(".");
        address.append(oct2);
        address.append(".");
        address.append(oct3);
        address.append(".");
        address.append(oct4);
        this.m_location.setField(attribute, address.toString());
        return address.toString();
    }

    protected void setNATParameter(String attribute, MatchResult result) {
        String group2;
        this.setLocation(result);
        String inmap = (String)this.m_location.get("356");
        if (inmap == null) {
            this.m_location.initializeNAT();
        }
        if ((group2 = result.group(2)) != null) {
            this.m_location.setField(attribute, group2);
        }
    }

    protected void setNATTimeoutParameter(MatchResult result) {
        this.setLocation(result);
        String inmap = (String)this.m_location.get("356");
        if (inmap == null) {
            this.m_location.initializeNAT();
        }
        String type = result.group(2);
        String time = result.group(3);
        String scale = result.group(4);
        String timescale = scale == null ? new String(" minutes") : new String(" " + scale);
        if (type != null) {
            if (type.equals("tcp")) {
                this.m_location.setField("353", String.valueOf(time) + timescale);
            } else if (type.equals("other")) {
                this.m_location.setField("354", String.valueOf(time) + timescale);
            }
        }
    }

    protected void setIPSecParameter(String attribute, MatchResult result) {
        String group2;
        this.setLocation(result);
        String inmap = (String)this.m_location.get("501");
        if (inmap == null) {
            this.m_location.initializeIPSec();
        }
        if ((group2 = result.group(2)) != null) {
            this.m_location.setField(attribute, group2);
        }
    }

    protected void setScriptParameter(String attribute, MatchResult result) {
        this.setLocation(result);
        String numstr = result.group(2);
        String expect = "expect";
        String send = "send";
        String sendstr = result.group(3);
        String recvstr = result.group(4);
        if (sendstr != null && recvstr != null) {
            LEDialScript dial = (LEDialScript)this.m_location.getConfig(attribute);
            dial.setField(String.valueOf(send) + numstr, sendstr);
            dial.setField(String.valueOf(expect) + numstr, recvstr);
        }
    }

    protected void setRIPParameter(MatchResult result) {
        this.setLocation(result);
    }

    protected void setOSPFParameters(String line) {
        StringTokenizer tokenizer = new StringTokenizer(line);
        tokenizer.nextToken();
        tokenizer.nextToken();
        String locname = tokenizer.nextToken();
        tokenizer.nextToken();
        String status = tokenizer.nextToken();
        LELocation location = (LELocation)this.m_locations.get(locname);
        if (location != null) {
            if (location.get("246") == null) {
                location.initializeOSPF();
            }
            location.setField("246", status);
            while (tokenizer.hasMoreTokens()) {
                String attribute = tokenizer.nextToken().toLowerCase();
                if (attribute.startsWith("co")) {
                    location.setField("242", tokenizer.nextToken());
                    continue;
                }
                if (attribute.startsWith("he")) {
                    location.setField("243", tokenizer.nextToken());
                    continue;
                }
                if (attribute.startsWith("de")) {
                    location.setField("244", tokenizer.nextToken());
                    continue;
                }
                if (!attribute.startsWith("po") && !attribute.startsWith("nb") && !attribute.startsWith("wa")) continue;
                location.setField("245", attribute);
            }
        }
    }
}

