/*
 * Decompiled with CFR 0.152.
 */
package com.lucent.ra.nms.model;

import com.lucent.ra.nms.backend.LEConnectionManager;
import com.lucent.ra.nms.backend.LEDSSException;
import com.lucent.ra.nms.backend.LEDSSPortMaster;
import com.lucent.ra.nms.model.LEConfig;
import com.lucent.ra.nms.model.LEFileConnectionFacade;
import com.lucent.ra.nms.model.LEPMConnectionFacade;
import com.lucent.ra.nms.model.LEPortMaster;
import com.lucent.ra.nms.model.LETemplateFileConnectionFacade;
import com.lucent.ra.nms.util.LEVector;
import java.io.IOException;

public class LEPMFactory {
    public static LEPortMaster GetFromPM(LEConnectionManager cm, String host, String user, String password) throws IOException, LEDSSException {
        LEDSSPortMaster dss = cm.connectToPM(host, user, password);
        LEPortMaster pm = new LEPortMaster();
        LEPMConnectionFacade facade = new LEPMConnectionFacade(cm, dss, pm);
        pm.setConnectionFacade(facade);
        return pm;
    }

    public static LEPMConnectionFacade GetFromPM(LEConnectionManager cm, LEPortMaster pm, String addr, String user, String password) throws IOException, LEDSSException {
        LEDSSPortMaster dss = cm.connectToPM(addr, user, password);
        LEPMConnectionFacade facade = new LEPMConnectionFacade(cm, dss, pm);
        return facade;
    }

    public static LEPortMaster GetFromFile(LEConnectionManager cm, String fullpath) {
        LEPortMaster pm = new LEPortMaster();
        LEFileConnectionFacade facade = new LEFileConnectionFacade(cm, pm, fullpath);
        pm.setConnectionFacade(facade);
        return pm;
    }

    public static LEPortMaster GetFromFile(LEConnectionManager cm, String dirname, String filename) {
        LEPortMaster pm = new LEPortMaster();
        LEFileConnectionFacade facade = new LEFileConnectionFacade(cm, pm, dirname, filename);
        pm.setConnectionFacade(facade);
        return pm;
    }

    public static LEPortMaster GetFromTemplateFile(LEConnectionManager cm, String fullpath, LEVector templates) {
        LEPortMaster pm = new LEPortMaster();
        LETemplateFileConnectionFacade facade = new LETemplateFileConnectionFacade(cm, (LEConfig)pm, fullpath, templates);
        pm.setConnectionFacade(facade);
        return pm;
    }

    public static LEPortMaster GetFromTemplateFile(LEConnectionManager cm, String dirname, String filename, LEVector templates) {
        LEPortMaster pm = new LEPortMaster();
        LETemplateFileConnectionFacade facade = new LETemplateFileConnectionFacade(cm, pm, dirname, filename, templates);
        pm.setConnectionFacade(facade);
        return pm;
    }
}

