/*
 * Decompiled with CFR 0.152.
 */
package com.lucent.ra.nms.model;

import com.lucent.ra.nms.backend.LEPMCommand;
import com.lucent.ra.nms.model.LEConfig;
import com.lucent.ra.nms.model.LEConnectionFacade;
import com.lucent.ra.nms.model.LESubInterface;
import com.lucent.ra.nms.model.LETable;
import com.lucent.ra.nms.util.LEVector;

public class LESubInterfaces
extends LETable {
    public LESubInterfaces(LEConnectionFacade facade) {
        super(facade);
    }

    public Object clone() {
        LESubInterfaces config = new LESubInterfaces(this.m_facade);
        config.copy(this);
        return config;
    }

    public LEVector add(String subname) {
        LEVector errors = null;
        String cmd = this.makeAddCommand("subinterface", subname);
        LEPMCommand ret = this.m_facade.execute(cmd);
        if (ret.getStatus()) {
            ret = this.m_facade.execute("save all");
            this.refresh();
        }
        if (!ret.getStatus()) {
            errors = new LEVector();
            errors.addElement(ret);
        }
        return errors;
    }

    public LEVector delete(String subname) {
        LESubInterface sub = (LESubInterface)this.get(subname);
        if (sub == null) {
            return null;
        }
        LEVector errors = null;
        String cmd = this.makeDeleteCommand("subinterface", subname);
        LEPMCommand ret = this.m_facade.execute(cmd);
        if (ret.getStatus()) {
            this.m_fields.remove(subname);
            ret = this.m_facade.execute("save all");
            if (!ret.getStatus()) {
                this.refresh();
            }
        }
        if (!ret.getStatus()) {
            errors = new LEVector();
            errors.addElement(ret);
        }
        return errors;
    }

    LEConfig createConfig(String key) {
        return new LESubInterface(this.m_facade, key);
    }

    boolean generateAddCommand(String key, LEVector cmds) {
        cmds.addElement(this.makeAddCommand("subinterface", key));
        return true;
    }

    boolean generateDeleteCommand(String key, LEVector cmds) {
        cmds.addElement(this.makeDeleteCommand("subinterface", key));
        return true;
    }
}

