/*
 * Decompiled with CFR 0.152.
 */
package COM.livingston.model;

import COM.livingston.backend.LEDSSException;
import COM.livingston.backend.LEDSSPortMaster;
import COM.livingston.model.LEMonitorSetting;
import COM.livingston.util.LEDebug;
import java.util.Enumeration;
import java.util.Hashtable;

public class LEMonitorFacility {
    public static final int NO_BOARD = -1;
    LEDSSPortMaster m_dss;
    Hashtable m_monitors = new Hashtable();
    Hashtable m_deltas = new Hashtable();

    public static int GetMonitorTime(int entity) {
        int time = 0;
        switch (entity) {
            case 0x330000: {
                time = 5000;
                break;
            }
            case 0x120000: {
                time = 30000;
                break;
            }
            case 0x360000: {
                time = 30000;
                break;
            }
            case 0x370000: {
                time = 30000;
                break;
            }
            case 131072: {
                time = 30000;
                break;
            }
            case 0x2D0000: {
                time = 5000;
                break;
            }
            case 0x2C0000: {
                time = 5000;
                break;
            }
            case 196608: {
                time = 30000;
                break;
            }
            case 0x340000: {
                time = 30000;
                break;
            }
            case 983040: {
                time = 30000;
                break;
            }
            case 0x2E0000: {
                time = 5000;
                break;
            }
            case 65536: {
                time = 30000;
                break;
            }
            default: {
                time = 30000;
            }
        }
        return time;
    }

    public static int GetDeltaTime(int entity) {
        int time = 0;
        switch (entity) {
            case 0x120000: {
                time = 1000;
                break;
            }
            case 131072: {
                time = 1000;
                break;
            }
            case 196608: {
                time = 1000;
                break;
            }
            case 65536: {
                time = 1000;
                break;
            }
        }
        return time;
    }

    public LEMonitorFacility(LEDSSPortMaster dss) {
        this.m_dss = dss;
    }

    public synchronized boolean startMonitor(int entity, int board) {
        LEMonitorSetting setting;
        boolean success = true;
        Integer ent = new Integer(entity);
        Integer brd = new Integer(board);
        Hashtable<Integer, LEMonitorSetting> settings = (Hashtable<Integer, LEMonitorSetting>)this.m_monitors.get(ent);
        if (settings == null) {
            settings = new Hashtable<Integer, LEMonitorSetting>();
            this.m_monitors.put(ent, settings);
        }
        if ((setting = (LEMonitorSetting)settings.get(brd)) == null) {
            int time = LEMonitorFacility.GetMonitorTime(entity);
            if (time > 0) {
                try {
                    long req = board == -1 ? this.m_dss.monitor(entity, time) : this.m_dss.monitor(entity, time, board);
                    setting = new LEMonitorSetting(req);
                    settings.put(brd, setting);
                }
                catch (LEDSSException lEDSSException) {
                    success = false;
                }
                catch (Exception e) {
                    LEDebug.getLog().logln(20, e);
                    success = false;
                }
            }
        } else {
            setting.increment();
        }
        return success;
    }

    public synchronized boolean startDelta(int entity, int board) {
        LEMonitorSetting setting;
        boolean success = true;
        Integer ent = new Integer(entity);
        Integer brd = new Integer(board);
        Hashtable<Integer, LEMonitorSetting> settings = (Hashtable<Integer, LEMonitorSetting>)this.m_deltas.get(ent);
        if (settings == null) {
            settings = new Hashtable<Integer, LEMonitorSetting>();
            this.m_deltas.put(ent, settings);
        }
        if ((setting = (LEMonitorSetting)settings.get(brd)) == null) {
            int time = LEMonitorFacility.GetDeltaTime(entity);
            if (time > 0) {
                try {
                    long req = board == -1 ? this.m_dss.delta(entity, time) : this.m_dss.delta(entity, time, board);
                    setting = new LEMonitorSetting(req);
                    settings.put(brd, setting);
                }
                catch (LEDSSException lEDSSException) {
                    success = false;
                }
                catch (Exception e) {
                    LEDebug.getLog().logln(20, e);
                    success = false;
                }
            }
        } else {
            setting.increment();
        }
        return success;
    }

    public synchronized void stopMonitor(int entity, int board) {
        Integer ent = new Integer(entity);
        Integer brd = new Integer(board);
        Hashtable settings = (Hashtable)this.m_monitors.get(ent);
        if (settings == null) {
            return;
        }
        LEMonitorSetting setting = (LEMonitorSetting)settings.get(brd);
        if (setting == null) {
            return;
        }
        if (setting.decrement() == 0) {
            this.stopMonitor(setting);
            settings.remove(brd);
        }
    }

    public synchronized void stopDelta(int entity, int board) {
        Integer ent = new Integer(entity);
        Integer brd = new Integer(board);
        Hashtable settings = (Hashtable)this.m_deltas.get(ent);
        if (settings == null) {
            return;
        }
        LEMonitorSetting setting = (LEMonitorSetting)settings.get(brd);
        if (setting == null) {
            return;
        }
        if (setting.decrement() == 0) {
            this.stopDelta(setting);
            settings.remove(brd);
        }
    }

    public synchronized void shutdown() {
        LEMonitorSetting setting;
        Enumeration enum2;
        Hashtable settings;
        Enumeration enum1 = this.m_monitors.elements();
        while (enum1.hasMoreElements()) {
            settings = (Hashtable)enum1.nextElement();
            enum2 = settings.elements();
            while (enum2.hasMoreElements()) {
                setting = (LEMonitorSetting)enum2.nextElement();
                this.stopMonitor(setting);
            }
            settings.clear();
        }
        this.m_monitors.clear();
        enum1 = this.m_deltas.elements();
        while (enum1.hasMoreElements()) {
            settings = (Hashtable)enum1.nextElement();
            enum2 = settings.elements();
            while (enum2.hasMoreElements()) {
                setting = (LEMonitorSetting)enum2.nextElement();
                this.stopDelta(setting);
            }
            settings.clear();
        }
        this.m_deltas.clear();
    }

    void stopMonitor(LEMonitorSetting setting) {
        long req = setting.getRequestID();
        try {
            this.m_dss.killMonitor(req);
        }
        catch (LEDSSException lEDSSException) {
        }
        catch (Exception e) {
            LEDebug.getLog().logln(20, e);
        }
    }

    void stopDelta(LEMonitorSetting setting) {
        long req = setting.getRequestID();
        try {
            this.m_dss.killDelta(req);
        }
        catch (LEDSSException lEDSSException) {
        }
        catch (Exception e) {
            LEDebug.getLog().logln(20, e);
        }
    }
}

